/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit.Extensions.Fixtures;

namespace Db4oUnit.Extensions.Fixtures
{
	public abstract class AbstractFileBasedDb4oFixture : AbstractSoloDb4oFixture
	{
		private readonly Sharpen.IO.File _yap;

		public AbstractFileBasedDb4oFixture(IConfigurationSource configSource, string fileName
			) : base(configSource)
		{
			_yap = new Sharpen.IO.File(fileName);
		}

		public virtual string GetAbsolutePath()
		{
			return _yap.GetAbsolutePath();
		}

		protected override void DoClean()
		{
			_yap.Delete();
		}
	}
}
