/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Regression
{
	/// <exclude></exclude>
	public class COR234TestCase : Db4oUnit.ITestCase
	{
		public static void Main(string[] args)
		{
			new Db4oUnit.TestRunner(typeof(Db4objects.Db4o.Tests.Common.Regression.COR234TestCase)
				).Run();
		}

		public virtual void Test()
		{
			if (Db4objects.Db4o.Tests.Util.WorkspaceServices.WorkspaceRoot == null)
			{
				Sharpen.Runtime.Err.WriteLine("Build environment not available. Skipping test case..."
					);
				return;
			}
			Db4objects.Db4o.Db4oFactory.Configure().AllowVersionUpdates(false);
			Db4oUnit.Assert.Expect(typeof(Db4objects.Db4o.Ext.OldFormatException), new _AnonymousInnerClass28
				(this));
		}

		private sealed class _AnonymousInnerClass28 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass28(COR234TestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4objects.Db4o.Db4oFactory.OpenFile(this._enclosing.OldDatabaseFilePath());
			}

			private readonly COR234TestCase _enclosing;
		}

		protected virtual string OldDatabaseFilePath()
		{
			string oldFile = Db4objects.Db4o.Tests.Util.IOServices.BuildTempPath("old_db.yap"
				);
			Db4objects.Db4o.Foundation.IO.File4.Copy(Db4objects.Db4o.Tests.Util.WorkspaceServices
				.WorkspaceTestFilePath("db4oVersions/db4o_3.0.3"), oldFile);
			return oldFile;
		}
	}
}
