/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.IX
{
	/// <summary>A node to represent an entry removed from an Index</summary>
	public class IxRemove : Db4objects.Db4o.Internal.IX.IxPatch
	{
		public IxRemove(Db4objects.Db4o.Internal.IX.IndexTransaction a_ft, int a_parentID
			, object a_value) : base(a_ft, a_parentID, a_value)
		{
			_size = 0;
		}

		public override int OwnSize()
		{
			return 0;
		}

		public override string ToString()
		{
			return base.ToString();
			string str = "IxRemove " + _parentID + "\n " + Handler().ComparableObject(Trans()
				, _value);
			return str;
		}

		public override void FreespaceVisit(Db4objects.Db4o.Internal.Freespace.FreespaceVisitor
			 visitor, int index)
		{
		}

		public override void Visit(object obj)
		{
		}

		public override void Visit(Db4objects.Db4o.Foundation.IVisitor4 visitor, int[] lowerAndUpperMatch
			)
		{
		}

		public override int Write(Db4objects.Db4o.Internal.IX.IIndexable4 a_handler, Db4objects.Db4o.Internal.StatefulBuffer
			 a_writer)
		{
			return 0;
		}

		public override void VisitAll(Db4objects.Db4o.Foundation.IIntObjectVisitor visitor
			)
		{
		}

		public override object ShallowClone()
		{
			Db4objects.Db4o.Internal.IX.IxRemove remove = new Db4objects.Db4o.Internal.IX.IxRemove
				(_fieldTransaction, _parentID, _value);
			base.ShallowCloneInternal(remove);
			return remove;
		}
	}
}
