/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS
{
	internal class BlobProcessor : Sharpen.Lang.Thread
	{
		private Db4objects.Db4o.Internal.CS.ClientObjectContainer stream;

		private Db4objects.Db4o.Foundation.Queue4 queue = new Db4objects.Db4o.Foundation.Queue4
			();

		private bool terminated = false;

		internal BlobProcessor(Db4objects.Db4o.Internal.CS.ClientObjectContainer aStream)
		{
			stream = aStream;
			SetPriority(MIN_PRIORITY);
		}

		internal virtual void Add(Db4objects.Db4o.Internal.CS.Messages.MsgBlob msg)
		{
			lock (queue)
			{
				queue.Add(msg);
			}
		}

		internal virtual bool IsTerminated()
		{
			lock (this)
			{
				return terminated;
			}
		}

		public override void Run()
		{
			try
			{
				Db4objects.Db4o.Foundation.Network.ISocket4 socket = stream.CreateParalellSocket(
					);
				Db4objects.Db4o.Internal.CS.Messages.MsgBlob msg = null;
				lock (queue)
				{
					msg = (Db4objects.Db4o.Internal.CS.Messages.MsgBlob)queue.Next();
				}
				while (msg != null)
				{
					msg.Write(stream, socket);
					msg.ProcessClient(socket);
					lock (stream.blobLock)
					{
						lock (queue)
						{
							msg = (Db4objects.Db4o.Internal.CS.Messages.MsgBlob)queue.Next();
						}
						if (msg == null)
						{
							terminated = true;
							Db4objects.Db4o.Internal.CS.Messages.Msg.CLOSE.Write(stream, socket);
							try
							{
								socket.Close();
							}
							catch
							{
							}
						}
					}
				}
			}
			catch (System.Exception e)
			{
				Sharpen.Runtime.PrintStackTrace(e);
			}
		}
	}
}
