/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Foundation
{
	/// <summary>
	/// Using the CollectionElement the other way around:
	/// CollectionElement.i_next points to the previous element
	/// </summary>
	/// <exclude></exclude>
	public class Queue4
	{
		private sealed class Queue4Iterator : System.Collections.IEnumerator
		{
			private bool _active = false;

			private Db4objects.Db4o.Foundation.List4 _current = null;

			public object Current
			{
				get
				{
					return this._current._element;
				}
			}

			public bool MoveNext()
			{
				if (!this._active)
				{
					this._current = this._enclosing._last;
					this._active = true;
				}
				else
				{
					if (this._current != null)
					{
						this._current = this._current._next;
					}
				}
				return this._current != null;
			}

			public void Reset()
			{
				this._current = null;
				this._active = false;
			}

			internal Queue4Iterator(Queue4 _enclosing)
			{
				this._enclosing = _enclosing;
			}

			private readonly Queue4 _enclosing;
		}

		private Db4objects.Db4o.Foundation.List4 _first;

		private Db4objects.Db4o.Foundation.List4 _last;

		public void Add(object obj)
		{
			Db4objects.Db4o.Foundation.List4 ce = new Db4objects.Db4o.Foundation.List4(null, 
				obj);
			if (_first == null)
			{
				_last = ce;
			}
			else
			{
				_first._next = ce;
			}
			_first = ce;
		}

		public object Next()
		{
			if (_last == null)
			{
				return null;
			}
			object ret = _last._element;
			_last = _last._next;
			if (_last == null)
			{
				_first = null;
			}
			return ret;
		}

		public bool HasNext()
		{
			return _last != null;
		}

		public virtual System.Collections.IEnumerator Iterator()
		{
			return new Db4objects.Db4o.Foundation.Queue4.Queue4Iterator(this);
		}
	}
}
