/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Foundation
{
	internal class HashtableObjectEntry : Db4objects.Db4o.Foundation.HashtableIntEntry
	{
		internal object i_objectKey;

		internal HashtableObjectEntry(int a_hash, object a_key, object a_object) : base(a_hash
			, a_object)
		{
			i_objectKey = a_key;
		}

		internal HashtableObjectEntry(object a_key, object a_object) : base(a_key.GetHashCode
			(), a_object)
		{
			i_objectKey = a_key;
		}

		protected HashtableObjectEntry() : base()
		{
		}

		public override void AcceptKeyVisitor(Db4objects.Db4o.Foundation.IVisitor4 visitor
			)
		{
			visitor.Visit(i_objectKey);
		}

		public override object DeepClone(object obj)
		{
			return DeepCloneInternal(new Db4objects.Db4o.Foundation.HashtableObjectEntry(), obj
				);
		}

		protected override Db4objects.Db4o.Foundation.HashtableIntEntry DeepCloneInternal
			(Db4objects.Db4o.Foundation.HashtableIntEntry entry, object obj)
		{
			((Db4objects.Db4o.Foundation.HashtableObjectEntry)entry).i_objectKey = i_objectKey;
			return base.DeepCloneInternal(entry, obj);
		}

		public virtual bool HasKey(object key)
		{
			return i_objectKey.Equals(key);
		}

		public override bool SameKeyAs(Db4objects.Db4o.Foundation.HashtableIntEntry other
			)
		{
			return other is Db4objects.Db4o.Foundation.HashtableObjectEntry ? HasKey(((Db4objects.Db4o.Foundation.HashtableObjectEntry
				)other).i_objectKey) : false;
		}
	}
}
