/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Foundation
{
	/// <exclude></exclude>
	public class Collection4Iterator : Db4objects.Db4o.Foundation.Iterator4Impl
	{
		private readonly Db4objects.Db4o.Foundation.Collection4 _collection;

		private readonly int _initialVersion;

		public Collection4Iterator(Db4objects.Db4o.Foundation.Collection4 collection, Db4objects.Db4o.Foundation.List4
			 first) : base(first)
		{
			_collection = collection;
			_initialVersion = CurrentVersion();
		}

		public override bool MoveNext()
		{
			Validate();
			return base.MoveNext();
		}

		public override object Current
		{
			get
			{
				Validate();
				return base.Current;
			}
		}

		private void Validate()
		{
			if (_initialVersion != CurrentVersion())
			{
				throw new Db4objects.Db4o.Foundation.InvalidIteratorException();
			}
		}

		private int CurrentVersion()
		{
			return _collection.Version();
		}
	}
}
