/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Querying
{
	public abstract class QueryResultTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
		, Db4oUnit.Extensions.Fixtures.IOptOutCS, Db4oUnit.Extensions.Fixtures.IOptOutDefragSolo
	{
		private static readonly int[] VALUES = new int[] { 1, 5, 6, 7, 9 };

		private readonly int[] itemIds = new int[VALUES.Length];

		private int idForGetAll;

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			IndexField(config, typeof(Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.Item)
				, "foo");
		}

		public virtual void TestClassQuery()
		{
			AssertIDs(ClassOnlyQuery(), itemIds);
		}

		public virtual void TestGetAll()
		{
			Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult queryResult = NewQueryResult
				();
			queryResult.LoadFromClassIndexes(Stream().ClassCollection().Iterator());
			int[] ids = Db4objects.Db4o.Tests.Common.Foundation.IntArrays4.Concat(itemIds, new 
				int[] { idForGetAll });
			AssertIDs(queryResult, ids, true);
		}

		public virtual void TestIndexedFieldQuery()
		{
			Db4objects.Db4o.Query.IQuery query = NewItemQuery();
			query.Descend("foo").Constrain(6).Smaller();
			Db4objects.Db4o.Internal.Query.Result.IQueryResult queryResult = ExecuteQuery(query
				);
			AssertIDs(queryResult, new int[] { itemIds[0], itemIds[1] });
		}

		public virtual void TestNonIndexedFieldQuery()
		{
			Db4objects.Db4o.Query.IQuery query = NewItemQuery();
			query.Descend("bar").Constrain(6).Smaller();
			Db4objects.Db4o.Internal.Query.Result.IQueryResult queryResult = ExecuteQuery(query
				);
			AssertIDs(queryResult, new int[] { itemIds[0], itemIds[1] });
		}

		private Db4objects.Db4o.Internal.Query.Result.IQueryResult ClassOnlyQuery()
		{
			Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult queryResult = NewQueryResult
				();
			queryResult.LoadFromClassIndex(YapClass());
			return queryResult;
		}

		private Db4objects.Db4o.Internal.ClassMetadata YapClass()
		{
			return Stream().GetYapClass(Reflector().ForClass(typeof(Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.Item)
				));
		}

		private Db4objects.Db4o.Internal.Query.Result.IQueryResult ExecuteQuery(Db4objects.Db4o.Query.IQuery
			 query)
		{
			Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult queryResult = NewQueryResult
				();
			queryResult.LoadFromQuery((Db4objects.Db4o.Internal.Query.Processor.QQuery)query);
			return queryResult;
		}

		private void AssertIDs(Db4objects.Db4o.Internal.Query.Result.IQueryResult queryResult
			, int[] expectedIDs)
		{
			AssertIDs(queryResult, expectedIDs, false);
		}

		private void AssertIDs(Db4objects.Db4o.Internal.Query.Result.IQueryResult queryResult
			, int[] expectedIDs, bool ignoreUnexpected)
		{
			Db4objects.Db4o.Tests.Common.Btree.ExpectingVisitor expectingVisitor = new Db4objects.Db4o.Tests.Common.Btree.ExpectingVisitor
				(Db4objects.Db4o.Tests.Common.Foundation.IntArrays4.ToObjectArray(expectedIDs), 
				false, ignoreUnexpected);
			Db4objects.Db4o.Foundation.IIntIterator4 i = queryResult.IterateIDs();
			while (i.MoveNext())
			{
				expectingVisitor.Visit(i.CurrentInt());
			}
			expectingVisitor.AssertExpectations();
		}

		protected virtual Db4objects.Db4o.Query.IQuery NewItemQuery()
		{
			return NewQuery(typeof(Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.Item)
				);
		}

		protected override void Store()
		{
			StoreItems(VALUES);
			Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.ItemForGetAll ifga = new 
				Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.ItemForGetAll();
			Store(ifga);
			idForGetAll = (int)Db().GetID(ifga);
		}

		protected virtual void StoreItems(int[] foos)
		{
			for (int i = 0; i < foos.Length; i++)
			{
				Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.Item item = new Db4objects.Db4o.Tests.Common.Querying.QueryResultTestCase.Item
					(foos[i]);
				Store(item);
				itemIds[i] = (int)Db().GetID(item);
			}
		}

		public class Item
		{
			public int foo;

			public int bar;

			public Item()
			{
			}

			public Item(int foo_)
			{
				foo = foo_;
				bar = foo;
			}
		}

		public class ItemForGetAll
		{
		}

		protected abstract Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult NewQueryResult
			();
	}
}
