/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Header
{
	public class SimpleTimeStampIdTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
		, Db4oUnit.Extensions.Fixtures.IOptOutCS
	{
		public static void Main(string[] arguments)
		{
			new Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase().RunSolo();
		}

		public class STSItem
		{
			public string _name;

			public STSItem()
			{
			}

			public STSItem(string name)
			{
				_name = name;
			}
		}

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			Db4objects.Db4o.Config.IObjectClass objectClass = config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem)
				);
			objectClass.GenerateUUIDs(true);
			objectClass.GenerateVersionNumbers(true);
		}

		protected override void Store()
		{
			Db().Set(new Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem
				("one"));
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem item = (Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem
				)Db().Get(typeof(Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem)
				).Next();
			long version = Db().GetObjectInfo(item).GetVersion();
			Db4oUnit.Assert.IsGreater(0, version);
			Db4oUnit.Assert.IsGreaterOrEqual(version, CurrentVersion());
			Reopen();
			Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem item2 = new 
				Db4objects.Db4o.Tests.Common.Header.SimpleTimeStampIdTestCase.STSItem("two");
			Db().Set(item2);
			long secondVersion = Db().GetObjectInfo(item2).GetVersion();
			Db4oUnit.Assert.IsGreater(version, secondVersion);
			Db4oUnit.Assert.IsGreaterOrEqual(secondVersion, CurrentVersion());
		}

		private long CurrentVersion()
		{
			return ((Db4objects.Db4o.Internal.LocalObjectContainer)Db()).CurrentVersion();
		}
	}
}
