/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Foundation
{
	public class Stack4TestCase : Db4oUnit.ITestCase
	{
		public static void Main(string[] args)
		{
			new Db4oUnit.TestRunner(typeof(Db4objects.Db4o.Tests.Common.Foundation.Stack4TestCase)
				).Run();
		}

		public virtual void TestPushPop()
		{
			Db4objects.Db4o.Foundation.Stack4 stack = new Db4objects.Db4o.Foundation.Stack4();
			AssertEmpty(stack);
			stack.Push("a");
			stack.Push("b");
			stack.Push("c");
			Db4oUnit.Assert.IsFalse(stack.IsEmpty());
			Db4oUnit.Assert.AreEqual("c", stack.Peek());
			Db4oUnit.Assert.AreEqual("c", stack.Peek());
			Db4oUnit.Assert.AreEqual("c", stack.Pop());
			Db4oUnit.Assert.AreEqual("b", stack.Pop());
			Db4oUnit.Assert.AreEqual("a", stack.Peek());
			Db4oUnit.Assert.AreEqual("a", stack.Pop());
			AssertEmpty(stack);
		}

		private void AssertEmpty(Db4objects.Db4o.Foundation.Stack4 stack)
		{
			Db4oUnit.Assert.IsTrue(stack.IsEmpty());
			Db4oUnit.Assert.IsNull(stack.Peek());
			Db4oUnit.Assert.Expect(typeof(System.InvalidOperationException), new _AnonymousInnerClass35
				(this, stack));
		}

		private sealed class _AnonymousInnerClass35 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass35(Stack4TestCase _enclosing, Db4objects.Db4o.Foundation.Stack4
				 stack)
			{
				this._enclosing = _enclosing;
				this.stack = stack;
			}

			public void Run()
			{
				stack.Pop();
			}

			private readonly Stack4TestCase _enclosing;

			private readonly Db4objects.Db4o.Foundation.Stack4 stack;
		}
	}
}
