/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System.Collections.Generic;
using Mono.GetOptions;

namespace Db4oAdmin
{
	public class ProgramOptions : Options
	{
		private bool _prettyVerbose;
		
		[Option("Optimize predicate subclasses", "optimize-predicates")]
		public bool OptimizePredicates;
		
		[Option("Enable delegate style queries for CompactFramework 2", "cf2-delegates")]
		public bool EnableCF2DelegateQueries;

		[Option("Case sensitive queries", "case-sensitive")]
		public bool CaseSensitive;

		[Option("Verbose operation mode", 'v', "verbose")]
		public bool Verbose;

		[Option("Pretty verbose operation mode", "vv")]
		public bool PrettyVerbose
		{
			get
			{
				return _prettyVerbose;
			}
			
			set
			{
				_prettyVerbose = value;
				Verbose = value;
			}
		}

		[Option("Fake operation mode, assembly won't be written", "fake")]
		public bool Fake;

		public List<string> CustomInstrumentations = new List<string>();
		
		[Option("Custom instrumentation type", "instrumentation", MaxOccurs=-1)]
		public WhatToDoNext CustomInstrumentation(string instrumentation)
		{	
			CustomInstrumentations.Add(instrumentation);
			return WhatToDoNext.GoAhead;
		}

		public string Assembly
		{
			get
			{
				if (RemainingArguments.Length != 1) return null;
				return RemainingArguments[0];
			}
		}
		
		public bool IsValid
		{
			get
			{
				return Assembly != null
				       && (OptimizePredicates
				           || EnableCF2DelegateQueries
				           || CustomInstrumentations.Count > 0);
			}
		}
		
		public ProgramOptions(string[] args) : this()
		{
			ProcessArgs(args);
		}
		
		public ProgramOptions()
		{	
			this.DontSplitOnCommas = true;
		}
	}
}