/* 
** WebDAV header file
**
** This library and program is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**   
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
** MA 02111-1307, USA
*/

#ifndef __WEBDAV_H__
#define __WEBDAV_H__

#include "util.h"

/* boolean */
#define true 1
#define false 0

#define DAVFS_BLKSIZE 1024

/* Davfs read time out in sec */
#define DAV_READ_TIMEOUT 30

/* Simple Result from PROPFIND */
typedef struct dav_prop_result
{
    char *fname;
    struct stat f_st;
    struct dav_prop_result *next;
}
dav_prop_result;


typedef struct
{
    dav_prop_result *first;
    dav_prop_result *last;
    int is_stat;
    char *uri;
}
dav_prop_result_header;

/*--------------------------------------------------------------------
 * Function proto types 
 *-------------------------------------------------------------------*/

/* Open DAV connection */
int dav_open_connection(dav_args *args);

/* Close connection */
void dav_close_connection(void);

/* Get WebDAV error no */
int dav_get_errno();

/* Free dav_prop_result */
void dav_prop_result_destroy (dav_prop_result *res);
    
/* Get propfind and return info */
dav_prop_result  *dav_opendir(const char *name);

/* Close dir and free the result */
void dav_closedir(dav_prop_result *);

/* Make directory */
int dav_mkdir(char *name, int mode);

/* remove dir */
int dav_rmdir(char *name);

/* Delete file */    
int dav_delete(char *name);

/* Get and save it to the file. Return file name */
char *dav_getlocalcopy(const char *name);

/* Changet name */
int dav_rename(char *buf, char *buf2, int is_dir, int try_num);


/* Lock the file */
int dav_lock(const char *name);

int dav_unlock(const char *name);

int dav_put(const char *name, const char *fname);

/* Get localfile and save it to the server */
int dav_put_unlock(const char *name, const char *fname);

/* let's get stat */
int dav_stat(const char *name, struct stat *st, 
         int is_dir, int is_second);


/* let's get stat from cache*/
int dav_stat_cache(const char *name, struct stat *st, 
           dav_prop_result *result,
           const char *base_dir);

/* Change mode */
int dav_chmod(const char *name, unsigned short mode);

#endif




/* start emacs stuff */
/* 
 * local variables: 
 * eval: (load-file "../tools/davfs-emacs.el") 
 * end: 
 */ 

