/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef DATATABLEVIEW_H
#define DATATABLEVIEW_H

#include <qdatatable.h>

class DataTable;

class DataTableView : public QDataTable
{
    Q_OBJECT
public:
    enum SelectionMode { Default = 0, MouseOver = 1 };
    DataTableView( DataTable *parent = 0, const char *name = 0 );

    virtual ~DataTableView();

    QColor selectionColor() const;

    SelectionMode selectionMode() const;
    void setSelectionMode( SelectionMode m );

public slots:
    void setSelectionColor( const QColor &color );
    virtual void columnWidthChanged( int col );
    virtual void setColumnWidth( int col, int w );
    void slotSelectFirstRow( bool updateCursor = true );
    void slotSelectPrevRow( bool updateCursor = true );
    void slotSelectNextRow( bool updateCursor = true );
    void slotSelectLastRow( bool updateCursor = true );
    void slotSelectRow( int row, bool updateCursor = true );

protected:
    void handleError( const QSqlError & error );
    virtual void paintCell( QPainter * p, int row, int col, const QRect & cr,
                            bool selected, const QColorGroup &cg );
    virtual void paintField( QPainter * p, const QSqlField* field,
                             const QRect & cr, bool b );

    QWidget* beginEdit( int row, int col, bool replace = false );

    virtual void sortColumn( int col, bool ascending = true, bool wholeRows = false );
    virtual void contentsContextMenuEvent( QContextMenuEvent *e );
    virtual void contentsMouseMoveEvent( QMouseEvent * e );

private:
    DataTable *m_dataTable;
    QColor m_selectionColor;
    SelectionMode m_mode;
};

#endif
