/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathException;

public class XQueryExpression {
    private Expression expression;
    private Executable executable;
    private DocumentInstr documentInstruction;

    protected XQueryExpression(Expression expression, Executable executable, StaticQueryContext staticQueryContext, Configuration configuration) {
        this.expression = expression;
        this.executable = executable;
        this.executable.setConfiguration(configuration);
        this.executable.setDefaultCollationName(staticQueryContext.getDefaultCollationName());
        this.executable.setCollationTable(staticQueryContext.getAllCollations());
        this.executable.setSlotSpace(staticQueryContext.getNumberOfGlobalVariables(), staticQueryContext.getNumberOfLocalVariables());
        String[] stringArray = new String[]{staticQueryContext.getSystemId()};
        this.executable.setModuleArray(stringArray);
    }

    protected void setDocumentInstruction(DocumentInstr documentInstr) {
        this.documentInstruction = documentInstr;
    }

    public List evaluate(DynamicQueryContext dynamicQueryContext) throws TransformerException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public Object evaluateSingle(DynamicQueryContext dynamicQueryContext) throws TransformerException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return XPathEvaluator.convert(item);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public SequenceIterator iterator(DynamicQueryContext var1_1) throws TransformerException {
        var2_2 = this.getController();
        this.initializeController(var1_1, var2_2);
        try {
            var3_3 = var1_1.getContextNode();
            if (var3_3 != null) {
                var2_2.makeContext(var3_3);
                var2_2.setPrincipalSourceDocument(var3_3.getDocumentRoot());
            }
            var4_5 = var2_2.getBindery();
            var4_5.openStackFrame();
            var2_2.defineGlobalParameters(var4_5);
            var5_7 = var2_2.newXPathContext();
            var6_8 = this.expression.iterate(var5_7);
            return new ErrorReportingIterator(var6_8, var2_2.getErrorListener());
        }
        catch (XPathException var3_4) {
            var4_6 /* !! */  = var3_4;
            ** while (var4_6 /* !! */ .getException() instanceof TransformerException)
        }
lbl-1000:
        // 1 sources

        {
            var4_6 /* !! */  = (TransformerException)var4_6 /* !! */ .getException();
            continue;
        }
lbl19:
        // 1 sources

        var2_2.getErrorListener().error(var4_6 /* !! */ );
        throw var4_6 /* !! */ ;
    }

    private void initializeController(DynamicQueryContext dynamicQueryContext, Controller controller) {
        HashMap hashMap = dynamicQueryContext.getParameters();
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = hashMap.get(string);
                controller.setParameter(string, v);
            }
        }
        controller.setURIResolver(dynamicQueryContext.getURIResolver());
        controller.setErrorListener(dynamicQueryContext.getErrorListener());
    }

    public void run(DynamicQueryContext dynamicQueryContext, Result result, Properties properties) throws TransformerException {
        OutputStream outputStream;
        if (properties == null) {
            properties = new Properties();
        }
        Controller controller = this.getController();
        this.initializeController(dynamicQueryContext, controller);
        Bindery bindery = controller.getBindery();
        bindery.openStackFrame();
        controller.defineGlobalParameters(bindery);
        boolean bl = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        controller.changeOutputDestination(properties, result, true, 3, null);
        try {
            this.documentInstruction.process(controller.newXPathContext());
        }
        catch (TransformerException transformerException) {
            controller.getErrorListener().fatalError(transformerException);
        }
        bindery.closeStackFrame();
        controller.resetOutputDestination(null);
        if (bl && result instanceof StreamResult && (outputStream = ((StreamResult)result).getOutputStream()) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
    }

    public Controller getController() {
        Controller controller = new Controller(this.executable.getConfiguration());
        controller.setExecutable(this.executable);
        this.executable.initialiseBindery(controller.getBindery());
        return controller;
    }

    public void explain(NamePool namePool) {
        System.err.println("============ Compiled Expression ============");
        this.expression.display(10, namePool);
        System.err.println("=============================================");
    }

    private static class ErrorReportingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private ErrorListener listener;

        public ErrorReportingIterator(SequenceIterator sequenceIterator, ErrorListener errorListener) {
            this.base = sequenceIterator;
            this.listener = errorListener;
        }

        public Item next() throws XPathException {
            try {
                return this.base.next();
            }
            catch (XPathException xPathException) {
                try {
                    this.listener.error(xPathException);
                }
                catch (TransformerException transformerException) {}
                throw xPathException;
            }
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ErrorReportingIterator(this.base.getAnother(), this.listener);
        }
    }
}

