/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.objects.Comparator;
import org.apache.xpath.objects.EqualComparator;
import org.apache.xpath.objects.GreaterThanComparator;
import org.apache.xpath.objects.GreaterThanOrEqualComparator;
import org.apache.xpath.objects.LessThanComparator;
import org.apache.xpath.objects.LessThanOrEqualComparator;
import org.apache.xpath.objects.NotEqualComparator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNodeSet
extends XObject {
    protected DTMManager m_dtmMgr;
    static LessThanComparator S_LT = new LessThanComparator();
    static LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static GreaterThanComparator S_GT = new GreaterThanComparator();
    static GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static EqualComparator S_EQ = new EqualComparator();
    static NotEqualComparator S_NEQ = new NotEqualComparator();

    protected XNodeSet() {
    }

    public XNodeSet(int n, DTMManager dTMManager) {
        super(new NodeSetDTM(dTMManager));
        this.m_dtmMgr = dTMManager;
        if (n != -1) {
            ((NodeSetDTM)this.m_obj).addNode(n);
        }
    }

    public XNodeSet(DTMIterator dTMIterator) {
        super(dTMIterator);
        this.m_dtmMgr = dTMIterator.getDTMManager();
    }

    public XNodeSet(DTMManager dTMManager) {
        super(new NodeSetDTM(dTMManager));
        this.m_dtmMgr = dTMManager;
    }

    public void allowDetachToRelease(boolean bl) {
        if (this.m_obj != null) {
            ((DTMIterator)this.m_obj).allowDetachToRelease(bl);
        }
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        XString xString = (XString)this.xstr();
        xString.appendToFsb(fastStringBuffer);
    }

    public boolean bool() {
        return this.iter().nextNode() != -1;
    }

    public boolean boolWithSideEffects() {
        return this.iterRaw().nextNode() != -1;
    }

    public boolean compare(XObject xObject, Comparator comparator) throws TransformerException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            int n2;
            DTMIterator dTMIterator = this.iter();
            DTMIterator dTMIterator2 = ((XNodeSet)xObject).iter();
            Vector<XMLString> vector = null;
            block0: while ((n2 = dTMIterator.nextNode()) != -1) {
                int n3;
                XMLString xMLString = this.getStringFromNode(n2);
                if (vector == null) {
                    while ((n3 = dTMIterator2.nextNode()) != -1) {
                        XMLString xMLString2 = this.getStringFromNode(n3);
                        if (comparator.compareStrings(xMLString, xMLString2)) {
                            bl = true;
                            continue block0;
                        }
                        if (vector == null) {
                            vector = new Vector<XMLString>();
                        }
                        vector.addElement(xMLString2);
                    }
                    continue;
                }
                n3 = vector.size();
                int n4 = 0;
                while (n4 < n3) {
                    if (comparator.compareStrings(xMLString, (XMLString)vector.elementAt(n4))) {
                        bl = true;
                        continue block0;
                    }
                    ++n4;
                }
            }
        } else if (n == 1) {
            double d = this.bool() ? 1.0 : 0.0;
            double d2 = xObject.num();
            bl = comparator.compareNumbers(d, d2);
        } else if (n == 2) {
            int n5;
            DTMIterator dTMIterator = this.iter();
            double d = xObject.num();
            while ((n5 = dTMIterator.nextNode()) != -1) {
                double d3 = this.getNumberFromNode(n5);
                if (!comparator.compareNumbers(d3, d)) continue;
                bl = true;
                break;
            }
        } else if (n == 5) {
            int n6;
            XMLString xMLString = xObject.xstr();
            DTMIterator dTMIterator = this.iter();
            while ((n6 = dTMIterator.nextNode()) != -1) {
                XMLString xMLString3 = this.getStringFromNode(n6);
                if (!comparator.compareStrings(xMLString3, xMLString)) continue;
                bl = true;
                break;
            }
        } else if (n == 3) {
            int n7;
            XMLString xMLString = xObject.xstr();
            DTMIterator dTMIterator = this.iter();
            while ((n7 = dTMIterator.nextNode()) != -1) {
                XMLString xMLString4 = this.getStringFromNode(n7);
                if (!comparator.compareStrings(xMLString4, xMLString)) continue;
                bl = true;
                break;
            }
        } else {
            bl = comparator.compareNumbers(this.num(), xObject.num());
        }
        return bl;
    }

    public void detach() {
        if (this.m_obj != null) {
            Object object = this.m_obj;
            this.m_obj = null;
            ((DTMIterator)object).detach();
        }
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        DTMIterator dTMIterator = this.iter();
        int n = dTMIterator.nextNode();
        if (n != -1) {
            this.m_dtmMgr.getDTM(n).dispatchCharactersEvents(n, contentHandler, false);
        }
    }

    public boolean equals(XObject xObject) {
        try {
            return this.compare(xObject, S_EQ);
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }

    public DTMManager getDTMMgr() {
        return this.m_dtmMgr;
    }

    public double getNumberFromNode(int n) {
        XMLString xMLString = this.m_dtmMgr.getDTM(n).getStringValue(n);
        return xMLString.toDouble();
    }

    public XMLString getStringFromNode(int n) {
        if (n != -1) {
            return this.m_dtmMgr.getDTM(n).getStringValue(n);
        }
        return XString.EMPTYSTRING;
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public boolean greaterThan(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_GT);
    }

    public boolean greaterThanOrEqual(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_GTE);
    }

    public DTMIterator iter() {
        try {
            return ((DTMIterator)this.m_obj).cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public DTMIterator iterRaw() {
        return (DTMIterator)this.m_obj;
    }

    public boolean lessThan(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_LT);
    }

    public boolean lessThanOrEqual(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_LTE);
    }

    public NodeSetDTM mutableNodeset() {
        NodeSetDTM nodeSetDTM;
        if (this.m_obj instanceof NodeSetDTM) {
            nodeSetDTM = (NodeSetDTM)this.m_obj;
        } else {
            nodeSetDTM = new NodeSetDTM(this.iter());
            this.m_obj = nodeSetDTM;
        }
        return nodeSetDTM;
    }

    public NodeList nodelist() throws TransformerException {
        return new DTMNodeList(this.iter());
    }

    public NodeIterator nodeset() throws TransformerException {
        return new DTMNodeIterator(this.iter());
    }

    public boolean notEquals(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_NEQ);
    }

    public double num() {
        DTMIterator dTMIterator = this.iter();
        int n = dTMIterator.nextNode();
        return n != -1 ? this.getNumberFromNode(n) : Double.NaN;
    }

    public double numWithSideEffects() {
        DTMIterator dTMIterator = this.iterRaw();
        int n = dTMIterator.nextNode();
        return n != -1 ? this.getNumberFromNode(n) : Double.NaN;
    }

    public String str() {
        DTMIterator dTMIterator = this.iter();
        int n = dTMIterator.nextNode();
        return n != -1 ? this.getStringFromNode(n).toString() : "";
    }

    public XMLString xstr() {
        DTMIterator dTMIterator = this.iter();
        int n = dTMIterator.nextNode();
        return n != -1 ? this.getStringFromNode(n) : XString.EMPTYSTRING;
    }
}

