#!/usr/bin/env bash

set -ev

rm -rf temp1
mkdir temp1
cd temp1
darcs init
touch foo
darcs add foo

# Check that prompting works as expected when answering yes...
echo yes | darcs whatsnew -s --posthook 'touch posthook-ran'
test -f posthook-ran
rm posthook-ran

# Check that prompting works as expected when answering no...
echo no | darcs whatsnew -s --posthook 'touch posthook-ran'
test ! -f posthook-ran

# Check that prompting works as expected with defaults (yes)...
echo ALL --posthook touch posthook-ran > _darcs/prefs/defaults
echo yes | darcs whatsnew -s
test -f posthook-ran
rm posthook-ran

# Check that prompting works as expected with defaults (no)...
echo no | darcs whatsnew -s
test ! -f posthook-ran

# Check that --run-posthook works in defaults
echo ALL --run-posthook >> _darcs/prefs/defaults
darcs whatsnew -s
test -f posthook-ran
rm posthook-ran

# Check that --run-posthook works when specified both in defaults and on
# command line
darcs whatsnew --run-posthook -s
test -f posthook-ran
rm posthook-ran

# Check that --posthook works when --run-posthook is in defaults
echo ALL --run-posthook > _darcs/prefs/defaults
darcs whatsnew --posthook 'touch posthook-ran' -s
test -f posthook-ran
rm posthook-ran

echo Successful.

cd ..
rm -rf temp1
