/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tree_builder.hpp"

#include "parallel_node.hpp"
#include "configuration_node.hpp"

#include "intrusive_ptr_list.hpp"
#include "intrusive_ptr.hpp"

#include <dammit/integration_project.hpp>
#include <dammit/build_project.hpp>

#include <map>

namespace dammit {

void tree_builder::add_project(build_project &project)
{
	project_info info;

	info.node = new project_node;

	info.node->project_name = project.project_name;
	info.node->project_type = project.project_type;

	for(build_project::input_file_iterator i = project.input_files.begin();
			i != project.input_files.end(); ++i)
	{
		info.node->nodes.push_back(new input_node(project.project_path, *i));
	}

	for(build_project::library_iterator i = project.libraries.begin();
			i != project.libraries.end(); ++i)
	{
		info.libraries.push_back(*i);
	}

	info.toplevel = true;

	projects.push_back(info);
}

void tree_builder::recursive_add_project(project &root)
{
	if(typeid(root) == typeid(integration_project))
	{
		integration_project &ip = dynamic_cast<integration_project &>(root);
		for(integration_project::subproject_iterator i = ip.subprojects.begin();
				i != ip.subprojects.end(); ++i)
		{
			recursive_add_project(*i);
		}
	}
	else if(typeid(root) == typeid(build_project))
	{
		build_project &bp = dynamic_cast<build_project &>(root);
		add_project(bp);
	}
}

intrusive_ptr<node> tree_builder::operator()(void)
{
	// TODO: detect/resolve cycles
	for(project_iterator i = projects.begin(); i != projects.end(); ++i)
	{
		for(project_info::library_iterator l = i->libraries.begin();
				l != i->libraries.end(); ++l)
		{
			bool found = false;
			for(project_iterator p = projects.begin();
					p != projects.end(); ++p)
			{
				if((*l == p->node->project_name) &&
					(p->node->project_type == build_project::library))
				{
					i->node->nodes.push_back(p->node);
					p->toplevel = false;
					found = true;
					break;
				}
			}
			if(found)
				continue;
			project_info info;
			info.node = new project_node;
			info.node->project_name = *l;
			info.node->project_type = build_project::library;
			info.toplevel = false;
			i->node->nodes.push_back(info.node);
			projects.push_back(info);
		}
	}

	intrusive_ptr<parallel_node> ret(new parallel_node);

	for(project_iterator i = projects.begin(); i != projects.end(); ++i)
	{
		if(i->toplevel)
			ret->nodes.push_back(i->node);
	}

	if(ret->nodes.size() == 1)
		return *ret->nodes.begin();

	return ret;
}

intrusive_ptr<node> tree_builder::operator()(project &p)
{
	recursive_add_project(p);

	return (*this)();
}

	/*
	std::map<project::name, intrusive_ptr<project_node> > executable_projects;
	std::map<project::name, intrusive_ptr<project_node> > library_projects;

	intrusive_ptr_list<project_node> all_projects;
	intrusive_ptr_list<project_node> top_projects;

	for(project_iterator i = active_projects.begin(); i != active_projects.end(); ++i)
	{
		all_projects.push_back(i);
		top_projects.push_back(i);
		switch(i->project_type)
		{
		case build_project::program:
			executable_projects[i->project_name] = i;
			break;
		case build_project::library:
			library_projects[i->project_name] = i;
			break;
		}
	}

	while(true)
	{
		for(intrusive_ptr_list<project_node>::iterator i = all_projects.begin();
				i != all_projects.end(); ++i)
		{
			
		}

		break;
	}

	*/


/*
	std::auto_ptr<project_node> proj(new project_node);

	proj->project_name = project_name;

	std::auto_ptr<link_node> link(new link_node);

	for(input_file_iterator i = input_files.begin(); i != input_files.end(); ++i)
	{
		std::string extension = boost::filesystem::extension(*i);
		if(extension == ".h")
			continue;
		else if(extension == ".cc")
			link->inputs.push_back(std::auto_ptr<node>(new cxx_compile_node(*i)));
	}

	for(library_iterator i = libraries.begin(); i != libraries.end(); ++i)
		link->libraries.push_back(*i);

	proj->nodes.push_back(link);

	return std::auto_ptr<node>(proj);
}

std::auto_ptr<node> integration_project::build_tree(void)
{
	std::auto_ptr<parallel_node> par(new parallel_node);

	for(subproject_iterator i = subprojects.begin(); i != subprojects.end(); ++i)
		par->nodes.push_back(i->build_tree());

	return std::auto_ptr<node>(par);
}

*/

}
