/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the Boost Software Licence version 1.0.
 */

#ifndef util_reference_list_hpp_
#define util_reference_list_hpp_ 1

#include <list>

namespace util {

template<typename T>
class reference_list
{
public:
	void push_back(T &ref)
	{
		list.push_back(ref);
	}

private:
	class reference
	{
	public:
		reference(T &ref) : ref(ref) { }

		operator T &(void) { return ref; }

	private:
		T &ref;
	};

	typedef std::list<reference> list_type;

	list_type list;

public:
	class iterator
	{
	public:
		typedef typename list_type::iterator slave_type;

		iterator(slave_type i) : iter(i) { }

		typedef typename std::iterator_traits<slave_type>::value_type value_type;
		typedef typename std::iterator_traits<slave_type>::reference reference;
		typedef typename std::iterator_traits<slave_type>::pointer pointer;
		typedef typename std::iterator_traits<slave_type>::iterator_category iterator_category;
		typedef typename std::iterator_traits<slave_type>::difference_type difference_type;

		reference operator*(void) { return *iter; }
		pointer operator->(void) { return &*iter; }

		bool operator==(iterator const &rhs) const { return iter == rhs.iter; }
		bool operator!=(iterator const &rhs) const { return iter != rhs.iter; }

		iterator &operator++(void) { ++iter; return *this; }
		iterator &operator--(void) { --iter; return *this; }

	private:
		slave_type iter;
	};

	iterator begin(void) { return list.begin(); }
	iterator end(void) { return list.end(); }
};

}

#endif
