/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_input_node_hpp_
#define dammit_input_node_hpp_ 1

#include "node.hpp"

#include <dammit/path.hpp>

namespace dammit {

/** Represents an input file */
class input_node :
	public node
{
public:
	input_node(path const &directory, path const &filename);
	virtual ~input_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);
	virtual void apply(const_visitor &) const;

	path directory;
	path filename;
};

}

#endif
