/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_execute_hpp_
#define dammit_execute_hpp_ 1

#include "const_visitor.hpp"

#include "cache.hpp"

namespace dammit {

class execute :
	public const_visitor
{
public:
	execute(cache &);
	virtual ~execute(void) throw() { }

	virtual void visit(parallel_node const &);
	virtual void visit(project_node const &);
	virtual void visit(configuration_node const &);
	virtual void visit(input_node const &);
	virtual void visit(temporary_node const &);
	virtual void visit(output_node const &);
	virtual void visit(tool_node const &);
	virtual void visit(environment_node const &);
	virtual void visit(action_node const &);

	bool keep_going(void) { return keep_going_; }
	void keep_going(bool k) { keep_going_ = k; }

private:
	cache &c;

	bool keep_going_;
};

}

#endif
