/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_environment_node_hpp_
#define dammit_environment_node_hpp_ 1

#include "node.hpp"

#include "output_node.hpp"

#include "intrusive_ptr_list.hpp"

#include <list>

namespace dammit {

class environment_node :
	public node
{
public:
	virtual ~environment_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);

	typedef std::list<path> include_path_list;
	typedef include_path_list::iterator include_path_iterator;

	include_path_list include_paths;

	typedef intrusive_ptr_list<output_node> library_list;
	typedef library_list::iterator library_iterator;

	library_list libraries;
};

}

#endif
