/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_command_hpp_
#define dammit_command_hpp_ 1

#include <dammit/path.hpp>

#include <list>

#include <ostream>

namespace dammit {

class command
{
public:
	std::string executable;
	path workingdir;

	typedef std::list<std::string> argument_list;
	typedef argument_list::iterator argument_iterator;
	typedef argument_list::const_iterator const_argument_iterator;

	argument_list arguments;
};

template<typename CharT_, typename Traits_>
std::basic_ostream<CharT_, Traits_> &operator<<(
		std::basic_ostream<CharT_, Traits_> &stream,
		command const &cmd)
{
	stream << cmd.executable;

	for(command::const_argument_iterator i = cmd.arguments.begin(); i != cmd.arguments.end(); ++i)
	{
		bool const need_quotes = (i->find(' ') != std::string::npos);
		stream << ' ';
		if(need_quotes)
			stream << '\'';
		stream << *i;
		if(need_quotes)
			stream << '\'';
	}

	return stream;
}

}

#endif
