/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "apply_configurations.hpp"

#include "parallel_node.hpp"
#include "project_node.hpp"
#include "configuration_node.hpp"
#include "input_node.hpp"
#include "temporary_node.hpp"
#include "output_node.hpp"
#include "tool_node.hpp"
#include "environment_node.hpp"
#include "action_node.hpp"

namespace dammit {

intrusive_ptr<node> apply_configurations::visit(parallel_node &n)
{
	for(parallel_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end();)
		if(*i = (**i).apply(*this))
			++i;
		else
			i = n.nodes.erase(i);
	
	return &n;
}

intrusive_ptr<node> apply_configurations::visit(configuration_node &n)
{
	apply_configurations ac;
	ac.current_config = &n;

	intrusive_ptr<parallel_node> ret = new parallel_node;

	for(configuration_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); i = n.nodes.erase(i))
	{
		intrusive_ptr<node> nn = (**i).apply(ac);
		if(nn)
			ret->nodes.push_back(nn);
	}

	switch(ret->nodes.size())
	{
	case 0:
		return 0;
	case 1:
		return *ret->nodes.begin();
	default:
		return ret;
	}
}

intrusive_ptr<node> apply_configurations::visit(project_node &n)
{
	if(!current_config)
		return &n;

	intrusive_ptr<configuration_node> project_cfg =
		new configuration_node(*current_config);
	
	std::string project_shortname;

	switch(n.project_type)
	{
	case build_project::program:
		project_shortname = "p-" + n.project_name;
		break;
	case build_project::library:
		project_shortname = "l-" + n.project_name;
		break;
	}

	project_cfg->output_dir /= project_shortname;
	project_cfg->temporary_dir /= project_shortname;

	for(project_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
	{
		if(typeid(**i) == typeid(configuration_node))
			continue;

		intrusive_ptr<node> nn = (**i).apply(*this);
		if(nn)
			project_cfg->nodes.push_back(nn);
	}

	n.nodes.push_back(project_cfg);

	return &n;
}

intrusive_ptr<node> apply_configurations::visit(input_node &n)
{
	return &n;
}

intrusive_ptr<node> apply_configurations::visit(temporary_node &n)
{
	return &n;
}

intrusive_ptr<node> apply_configurations::visit(output_node &n)
{
	return &n;
}

intrusive_ptr<node> apply_configurations::visit(tool_node &n)
{
	return &n;
}

intrusive_ptr<node> apply_configurations::visit(environment_node &n)
{
	return &n;
}

intrusive_ptr<node> apply_configurations::visit(action_node &n)
{
	return &n;
}

}
