/* $Id: fontselector.js 2530 2011-09-23 22:32:19Z brachman $ */

var currentInfo = 2;

var refentryInfo = [];
refentryInfo.push("para12");
refentryInfo.push("para14");
refentryInfo.push("para16");
refentryInfo.push("para18");

var fontsizeInfo = [];
fontsizeInfo.push("size00");
fontsizeInfo.push("size01");
fontsizeInfo.push("size02");
fontsizeInfo.push("size03");

function getRef(obj){

  return (typeof obj == "string") ?  document.getElementById(obj) : obj;
}
  
function setFont(num) {

  if (num == "-") {
    if ((currentInfo - 1) >= 0) {
      currentInfo--;
      getRef('refentry').className = refentryInfo[currentInfo];
      getRef('fontsizecontainer').className = fontsizeInfo[currentInfo];
    }
  }
  else if (num == "+") {
    if ((currentInfo + 1) < refentryInfo.length) {
      currentInfo++;
      getRef('refentry').className = refentryInfo[currentInfo];
      getRef('fontsizecontainer').className = fontsizeInfo[currentInfo];
    }
  }
  else if (num >= 0 && num < refentryInfo.length) {
    getRef('refentry').className = refentryInfo[num];
    getRef('fontsizecontainer').className = fontsizeInfo[num];
    currentInfo = num;
  }
}

function getClassName(obj) {

  return(getRef(obj).className);
}

function getCookieValue(cookieName) {

  if (document.cookie.length > 0) {
    cookieStart = document.cookie.indexOf(cookieName + "=");
    if (cookieStart != -1) {
      cookieStart = cookieStart + cookieName.length + 1;
      cookieEnd = document.cookie.indexOf(";", cookieStart);
      if (cookieEnd == -1)
        cookieEnd = document.cookie.length;
      return(unescape(document.cookie.substring(cookieStart, cookieEnd)));
    }
  }
  return("");
}

function setCookie(cookieName, cookieValue)
{
  var now = new Date();
  var expiresDate = new Date();
  var e;

  /* Will expire 90 days from now. */
  expiresDate.setDate(now.getDate() + 90);

  e = expiresDate.toUTCString();
  document.cookie = cookieName + "=" + escape(cookieValue)
    + "; expires=" + e + ";";
}

/*
 * This is called at page load time.
 * If query arg SETDACSMANFONT is present, use it for the font size and
 * set a cookie to remember the preference; otherwise, if a preference has
 * been selected (a cookie has been set), use it; otherwise, if query arg
 * DACSMANFONT is present, use it but don't set a preference;
 * otherwise, use the default.
 * Ignore an invalid request.
 */
function doFontConfig() {

  arg = getQueryParam("SETDACSMANFONT");
  if (arg != "") {
    setFont(arg);
    setFontConfig();
  }
  else {
    num = getCookieValue("DACSMANFONT");
    if (num != "") {
      setFont(num);
    }
    else {
      arg = getQueryParam("DACSMANFONT");
      if (arg != "") {
        setFont(arg);
      }
      else {
        setFont(currentInfo);
      }
    }
  }
}

function setFontConfig() {

  setCookie("DACSMANFONT", currentInfo);
}

var paramName = [];
var paramValue = [];

function initQueryParams() { 
  var loc = location.search.substring(1, location.search.length);
  var params = loc.split("&");

  for (i = 0; i < params.length; i++) {
      paramName[i] = unescape(params[i].substring(0, params[i].indexOf('=')));
      paramValue[i] = unescape(params[i].substring(params[i].indexOf('=') + 1));
  }
}

function getQueryParam(name) { 

  initQueryParams();
  for (i = 0; i < paramName.length; i++) {
    if (paramName[i] == name)
      return(paramValue[i]);
  }

  return("");
}

