/* dummy.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002, 2003 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef dummy_H
#define dummy_H

@class Song;

@protocol Format;

@interface dummyPlayerThread : NSObject
{
  int totalBytes;
  int bytesRead;
  long bytesPerSec;

  id stream;
  id streamToRelease;

  char buffer[176400];
}

- (id) init;

- (void) setStream: (id) aStream;
- (void) seek: (unsigned int) aPos;

- (int) getSeconds;

@end

@interface dummy : PlayerBase <Player>
{
  int speed;
  int channels;

  Song *song;

  NSMutableDictionary *dict;
  dummyPlayerThread *_thread;
}

- (id) init;

- (void) threadWillExit;

@end

#endif /* dummy_H */
