/* Esound.h - this file is part of Cynthiune
 *
 * Copyright (C) 2003 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef Esound_H
#define Esound_H

@protocol Format;
@protocol Preference;

#define BUF_SIZE 4096
#define SPEED_LIMIT 200

@interface EsoundPlayerThread : NSObject
{
  int totalBytes;
  int bytesRead;
  long bytesPerSec;

  id stream;
  id streamToRelease;

  char buffer[BUF_SIZE];
}

- (id) init;

- (void) setStream: (id) aStream;

- (void) seek: (unsigned int) aPos;

- (int) getSeconds;

@end

@interface Esound : PlayerBase <CynthiuneBundle, Player>
{
  int speed;
  int channels;

  int esdSock;
  NSString *host;

  Song *song;

  NSMutableDictionary *dict;
  EsoundPlayerThread *_thread;
}

- (id) init;

- (void) threadWillExit;

- (void) _esdReinit;

@end

@interface EsoundPreference : NSObject <Preference>
{
  NSMutableDictionary *preference;

  NSWindow *prefsWindow;

  NSButton *unixBtn;
  NSButton *tcpBtn;
  NSTextField *hostField;
  NSTextField *portField;

  NSBox *connectionTypeBox;
  NSBox *tcpOptionsBox;
  NSTextField *hostLabel;
  NSTextField *portLabel;

  BOOL defaultsInited;
}

- (id) _init;
- (void) _initDefaults;

- (BOOL) socketIsTCP;
- (NSString *) tcpHostConnectString;

/* radio buttons */
- (void) selectUnixBtn: (id) sender;
- (void) selectTcpBtn: (id) sender;

/* text fields */
- (void) hostAction: (id) sender;
- (void) portAction: (id) sender;

@end

#endif /* Esound_H */
