/***************************************************************************
                          cuyo.h  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CUYO_H
#define CUYO_H

#include "inkompatibel.h"

#include <qwidget.h>

#include <qpopmenu.h>
#include <qmenubar.h>
#include <qlabel.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bilddatei.h"
#include "fehler.h"

#define gmodus_kein_spiel 0
#define gmodus_spiel_start 1  // ... wie gmodus_spiel, aber Text muss noch gelscht werden
#define gmodus_spiel 2
#define gmodus_pause 20 // Nach Pause wird wieder in gmodus_spiel geschaltet
/* die folgenden beiden Modi bedeuten beide, dass das Spiel (der Level) zu Ende geht */
#define gmodus_warte_tot 3    	// ... weil ein Spieler tot ist
#define gmodus_warte_level 4  	// ... weil der Level fertig ist
#define gmodus_bonus_animation 5	// Zeit-Bonus bekommen...
#define gmodus_bonus_warte 6		// Nach dem Zeit-Bonus noch ein bisschen warten...

#define max_spielerzahl 2



class KIPlayer;
class Spielfeld;
class Punktefeld;

/** Cuyo -- Das Fenster.

    Ein paar allgemeine Definitionen:
    
    Blop: eins von diesen Kgelchen. Auch Graue oder Gras, etc.
    
    Version (eines Blops): Untersorte (usprnglich vom Gras)
    
    Zustand eines Blops: 1. Wo in der Animation befindet es sich?
    2. Welche Version ist es?
    
    Standardblop: Kgelchen, aber kein Graues, etc.
    
    Farbe: eine Sorte von Standardblops.
    
    Bilddatei: Ein Pixmap so wie es geladen wurde.
    
    Bildchen: ein 16x16-Pixmap(-Ausschnitt).
    
    Schema: System, nach dem die Blob-Bildchen mit Anschlssen aus den xpms
    erzeugt werden
 */

class Cuyo : public QWidget {
  Q_OBJECT
    public:
  /** construtor */
  Cuyo(QWidget*parent=0,const char* name=0);
  /** destructor */
  ~Cuyo();
  /** liefert true, wenn das Spiel normal luft, false
      wenn das Spiel am zuende gehen ist. (Liefert whrend Pause
      auch true) */
  bool spielLaeuft();
  /** liefert true, wenn das Spiel gepaust ist. */
  bool spielPause() { return mGModus == gmodus_pause; }
  /** Liefert die Anzahl der Mitspieler zurck. */
  bool getSpielerZahl() const;


  /***** Debug-Variablen *****/
  /* Es gibt auerdem noch die globale Variable gDebug; */
  bool mEinzelschritt;
  bool mZeitlupe;
  int mZaehlerZeitlupe;
  bool mRueberReihenTest;
  bool mAbspielen;
  bool mSchnellvorlauf;



  /** Das Bild, das angezeigt wird, whrend das Spiel auf Pause steht.
      (Etwas provisorisch public) */
  Bilddatei * mPauseBild;


 protected: // Private attributes


  /***** Q-Objekt-Variablen (widgets u. .) *****/
  /** Die Menleiste */
  QMenuBar* mMenuBar;
  /** Das Men */
  QPopupMenu * mSpielMenu;
  /** Die beiden Spielfelder... */
  Spielfeld* mSpielfeld[max_spielerzahl];
  /** Die Punkte-Anzeigen */
  Punktefeld * mPunkteFeld[max_spielerzahl];

  /** Der Timer fr's eigentliche Spiel. Wird in startSpiel() erzeugt
      und in stopSpiel() vernichtet */
  QTimer * mTimer;
  /** Computer-Spieler. (Existiert immer.) */
  KIPlayer * mKI;



  /***** Zustandsvariablen *****/

  /** global-Modus (Spielerbergreifend). ** Nur mit setGModus() ndern! ** */
  int mGModus;
  /** true, wenn das Spiel grad nicht weitergehen soll, sondern auf einen
      Tastendruck gewartet wird. (Wird dann von tasteWeiter() wieder auf
      true gesetzt.) */
  bool mWarteAufTaste;
  /* Wenn > 0, wird hchstens so lange auf Taste gewartet */
  int mWarteTimeout;
  
  /** Ein oder zwei Spieler? (Hat auch beim Spielen gegen die KI den Wert 2,
      und *nicht* spz_ki) */
  int mSpielerZahl;
  /** Falls zwei Spieler: Gegen Computer? */
  bool mGegenKI;

  /** Aktuelle Level-Nummer; enthlt, wenn grade kein Spiel luft, die Nummer
      vom Level zum weiterspielen. Ist (wenn kein Spiel luft) 0, wenn es
      keine vorige Level-Nummer gibt */
  int mLevelNr;
  /** (Interner) Name des aktuellen Levels. Enthlt, wenn grade kein Spiel
      luft, den Namen vom Level zum weiterspielen. Ist (wenn kein Spiel
      luft) "", wenn es keine vorige Level-Nummer gibt*/
  //__String mIntLevelName;
  int mPunkte[max_spielerzahl];
  /** Wird nur whrend der Zeitbonus-Animation gebraucht... */
  int mZeitBonus;
  
  /* Wird am Anfang von spielSchritt() gesetzt: auf false, wenn der Computer
     grad zu langsam ist. Dann kann an der Grafik gespart werden. */
  bool mInTime;
		
 public slots: // Public slots
  /** Fhrt alle Men-Befehle aus */
  void MenuAufruf(int id);
  /** stoppt das Spiel sofort (egal, ob grad ein Level luft oder nicht) */
  void stopSpiel(bool wegen_fehler = false);
  /** Die Haupt-Spielschritt-Routine, whrend das Spiel luft. Wird direkt
      von QT aufgerufen. Ruft alle anderen spielschritt()-Routinen auf. */
  void spielSchritt();
  /** Wird von startLevel() und von spielSchritt() aufgerufen. Lsst
      smtliche Blops animieren und updatet die Grafik. */
  void animiere();
  /**  */
  void neuePunkte(bool reSp, int pt);
  /** wird aufgerufen, wenn ein Spieler tot ist */
  void spielerTot();
 public: // nicht slots
  /** wird aufgerufen, wenn der Benutzer was-auch-immer
      fertiggelesen (und eine Taste gedrckt) hat. */
  void tasteWeiter();
  /** Liefert ein Spielfeld zurck. */
  Spielfeld * getSpielfeld(bool reSp);
  /** Liefert zurck, ob die Zeit fr Grafik grade reicht */
  bool getInTime() const;
 protected: // Protected methods
  /**  */
  void MenuErz();
  /** Startet das Spiel */
  void startSpiel();
  /** tut alles, was beim Starten eines Levels
      getan werden muss; liefert false, wenn es
      den Level gar nicht mehr gibt. Throwt bei Fehler. */
  bool startLevel();
  /** tut alles, was beim Stoppen eines Levels
      getan werden muss (ohne Animation, d. h. entweder
      ist die Animation schon vorbei oder es gibt halt keine).
      Wenn malen = true ist, Bildschirm sofort updaten */
  void stopLevel(bool malen, bool wegen_fehler = false);
  /**  */
  void setPunkte(int sp, int pu);
  /** Ein key-Event halt... (Kmmert sich um alle Tasten,
      die whrend des Spiels so gedrckt werden...) */
  void keyPressEvent(QKeyEvent * e);
  /** Ldt die Preferences aus wo-auch-immer-sie-abgespeichert-werden
      in die Variablen. */
  void liesPreferences();
  /** Schreibt die Preferences nach wo-auch-immer-sie-abgespeichert-werden. */
  void schreibPreferences();
  /** Setzt die Anzahl der Spieler. Auch in der Menleiste. 
      Bei a == spz_ki wird auf ki-Modus geschaltet. (spz_ki wird in
      aufnahme.h definiert, weil es dort auch gebraucht wird.) */
  void setSpielerZahl(int a);
  /** ndert mGModus und aktualisiert das Enabled-Sein der Mens. */
  void setGModus(int gm);
  /** Setzt das Enabled-Sein der Mens auf das Richtige,
      abhngig von mGModus und mLevelNr */
  void aktualisiereMenuEnabled();
  
  /** Gibt die Fehlermeldung bestehend aus t und fe aus:
      Sowohl als Text im Cuyo-Fenster
      (bei anz_sp vielen Spielern) als auch auf stderr. 
      mitLog wird an fe.getText() weitergegeben. (D. h.: soll
      ggf. die Send-Log-Meldung ausgegeben werden?) */
  void printFehler(int anz_sp, __String t, Fehler fe,
                   bool mitLog = false);


public:
  /* *Das* Cuyo-Objekt. Jetzt neu: In einer globalen Variable. */
  static Cuyo * gCuyo;

};


/** Liefert den Namen und Pfad der Prefs-Datei zurck
    ($HOME/.cuyo) */
__String getPrefsName();
/** Liefert den Namen und Pfad der Log-Datei zurck
    ($HOME/cuyo.log) */
__String getLogName();


#endif

