
dnl
dnl         ac_have_qt.m4 - search for trolltech's Qt
dnl
dnl  begin                : Sat May 18 2002
dnl  copyright            : (C) 2002 by ahmet inan
dnl  email                : auto@ainan.org
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl

dnl
dnl @synopsis AC_HAVE_QT
dnl
dnl search for Qt and set these variables to represent the last
dnl version of Qt installed:
dnl
dnl	QT_CXXFLAGS	: holds the needed CXXFLAGS to compile qt apps
dnl	QT_MOC		: points to the found meta object compiler
dnl	QT_UIC		: points to the found user interface compiler
dnl	QT_INCLUDE	: points to the include path of Qt headers
dnl	QT_LIB		: points to the exact filename of found lib
dnl	QT_LIBS		: holds the needed libs to link qt apps with
dnl	QT_VERSION	: version string of found Qt
dnl	QT_MT		: either "yes" or "no" if no builtin threading support
dnl	QT_GL		: either "yes" or "no" if no builtin OpenGL support
dnl	have_qt		: either "yes" or "no" if qt was not found
dnl
dnl and a few defines in config.h:
dnl
dnl	HAVE_QT		: only defined if Qt found
dnl	HAVE_QT_MT	: only defined if buildin threading support
dnl	HAVE_QT_GL	: only defined if buildin OpenGL support
dnl
dnl these options can be used, to force configure to use your own config:
dnl
dnl	--with-qt=no		disable the use of Qt
dnl	--with-qt-moc=MOC	use MOC for mocing, overrides qt-dir/bin/moc
dnl	--with-qt-uic=UIC	use UIC for uicing, overrides qt-dir/bin/uic
dnl	--with-qt-include=DIR	use DIR as path to the Qt headers, overrides qt-dir/include
dnl	--with-qt-lib=LIB	use LIB for linking, overrides qt-dir/lib/libqt*
dnl	--with-qt-dir=DIR	use DIR as path to the Qt root dir
dnl
dnl if you want to use the multithreading support (eg. QThread, QMutex)
dnl of Qt, then download acx_pthread.m4 and use it before this.
dnl if you dont use the threading support, but want to be paranoid,
dnl then use it, too. i have seen some systems, which accidentaly
dnl include only the threaded version of Qt, which is a bad mistake ...
dnl if you want to use the OpenGL support of Qt, then you have to download
dnl mdl_have_opengl.m4 and use it before this, too.
dnl
dnl this file is written from scratch, if you have some comments or bugfixes,
dnl please let me know.
dnl i've tested it on FreeBSD, Debian, RedHat and SuSE
dnl look at http://www.ainan.org/auto/ for complete documentation
dnl and for the example-ac_have_qt-autoconf/automake-test-toy, testqt :)
dnl
dnl @version $Id: ac_have_qt.m4,v 1.3 2002/10/16 09:49:37 immi Exp $
dnl @author ahmet inan <auto@ainan.org>
dnl

AC_DEFUN([AC_HAVE_QT], [

dnl i added only a few ones here, which works on the most systems.
dnl but if you have a system, where this would not work, please look
dnl for the moc, uic, include and lib and mail me what youve found out.
dnl if you add it by your self, even better, mail me :-)

	ac_have_qt_moc="
		/usr/bin/moc
		/usr/bin/moc2
		/usr/local/bin/moc
		/usr/local/bin/moc2
		`ls /usr/local/qt*/bin/moc 2> /dev/null`
		/usr/X11R6/bin/moc
		/usr/X11R6/bin/moc2
		`ls /usr/lib/qt*/bin/moc 2> /dev/null`
	"
	ac_have_qt_uic="
		/usr/bin/uic
		/usr/local/bin/uic
		`ls /usr/local/qt*/bin/uic 2> /dev/null`
		/usr/X11R6/bin/uic
		`ls /usr/lib/qt*/bin/uic 2> /dev/null`
	"
	ac_have_qt_include="
		`ls /usr/include/qt*/qglobal.h 2> /dev/null`
		`ls /usr/local/include/qt*/qglobal.h 2> /dev/null`
		`ls /usr/local/qt*/include/qglobal.h 2> /dev/null`
		`ls /usr/X11R6/include/X11/qt*/qglobal.h 2> /dev/null`
		`ls /usr/X11R6/include/qt*/qglobal.h 2> /dev/null`
		`ls /usr/lib/qt*/include/qglobal.h 2> /dev/null`
	"
	ac_have_qt_lib="
		`ls /usr/lib/libqt*.so* 2> /dev/null`
		`ls /usr/local/lib/libqt*.so* 2> /dev/null`
		`ls /usr/local/qt*/lib/libqt*.so* 2> /dev/null`
		`ls /usr/X11R6/lib/X11/qt*/libqt*.so* 2> /dev/null`
		`ls /usr/X11R6/lib/libqt*.so* 2> /dev/null`
		`ls /usr/lib/qt*/lib/libqt*.so* 2> /dev/null`
	"

dnl this is for the threaded Qt libs, you need acx_pthread.m4 before this
	if test "$acx_pthread_ok" = "yes" ; then
		ac_have_qt_test_mt="yes"
		ac_have_qt_mt_libs="$PTHREAD_LIBS"
		ac_have_qt_mt_cflags="-DQT_THREAD_SUPPORT $PTHREAD_CFLAGS"
		ac_have_qt_mt="yes"
	else
		ac_have_qt_test_mt="no"
		ac_have_qt_mt_libs=
		ac_have_qt_mt_cflags=
		ac_have_qt_mt="no"
	fi
dnl this is for the Qt libs with OpenGL support, you need mdl_have_opengl.m4
	if test "$mdl_cv_have_OpenGL" = "yes" ; then
		ac_have_qt_test_gl="yes"
		ac_have_qt_gl_libs="$GL_LIBS"
		ac_have_qt_gl_cflags="$GL_CFLAGS"
		ac_have_qt_gl="yes"
	else
		ac_have_qt_test_gl="no"
		ac_have_qt_gl_libs=
		ac_have_qt_gl_cflags=
		ac_have_qt_gl="no"
	fi

	AC_ARG_WITH([qt],
		[  --with-qt=no            disable the use of Qt])
	AC_ARG_WITH([qt-moc],
		[  --with-qt-moc=MOC       use MOC for mocing, overrides qt-dir/bin/moc])
	AC_ARG_WITH([qt-uic],
		[  --with-qt-uic=UIC       use UIC for uicing, overrides qt-dir/bin/uic])
	AC_ARG_WITH([qt-include],
		[  --with-qt-include=DIR   use DIR as path to the Qt headers, overrides qt-dir/include])
	AC_ARG_WITH([qt-lib],
		[  --with-qt-lib=LIB       use LIB for linking, overrides qt-dir/lib/libqt*])
	AC_ARG_WITH([qt-dir],
		[  --with-qt-dir=DIR       use DIR as path to the Qt root dir])

	ac_have_qt_with="no"

dnl if user (or system) already set environment variable, then use it
	if test -n "$QTDIR" ; then
		ac_have_qt_dir="${QTDIR%/}"
		ac_have_qt_moc="$ac_have_qt_dir/bin/moc"
		ac_have_qt_uic="$ac_have_qt_dir/bin/uic"
		ac_have_qt_include="$ac_have_qt_dir/include/qglobal.h"
		ac_have_qt_lib="`ls $ac_have_qt_dir/lib/libqt* 2> /dev/null`"
	fi

	if test -n "$with_qt_dir" ; then
		ac_have_qt_with="yes"
		ac_have_qt_dir="${with_qt_dir%/}"
		ac_have_qt_moc="$ac_have_qt_dir/bin/moc"
		ac_have_qt_uic="$ac_have_qt_dir/bin/uic"
		ac_have_qt_include="$ac_have_qt_dir/include/qglobal.h"
		ac_have_qt_lib="`ls $ac_have_qt_dir/lib/libqt* 2> /dev/null`"
	fi

	if test -n "$with_qt_moc" ; then
		ac_have_qt_with="yes"
		ac_have_qt_moc="$with_qt_moc"
	fi

	if test -n "$with_qt_uic" ; then
		ac_have_qt_with="yes"
		ac_have_qt_uic="$with_qt_uic"
	fi

	if test -n "$with_qt_include" ; then
		ac_have_qt_with="yes"
		ac_have_qt_include="${with_qt_include%/}/qglobal.h"
	fi

	if test -n "$with_qt_lib" ; then
		ac_have_qt_with="yes"
		ac_have_qt_lib="$with_qt_lib"
	fi

	have_qt="yes"

	if test "$with_qt" = "no" ; then
		have_qt="no"
		ac_have_qt_with="yes"
		QT_CXXFLAGS=
		QT_MOC=
		QT_UIC=
		QT_INCLUDE=
		QT_LIB=
		QT_LIBS=
		QT_MT=
		QT_GL=
		QT_VERSION=

		AC_MSG_CHECKING([for Qt])
		AC_MSG_RESULT([disabled])
	else
		if test "$ac_have_qt_with" = "no" ; then
			AC_CACHE_CHECK([for Qt], ac_cv_have_qt, 
				[AC_HAVE_QT_MAIN()])
		else
			AC_MSG_CHECKING([for Qt])
			AC_HAVE_QT_MAIN()
			if test "$have_qt" = "yes" ; then
				AC_MSG_RESULT([yes])
			else
				AC_MSG_RESULT([no])
			fi
		fi
		have_qt="$ac_cv_have_qt"
		QT_CXXFLAGS="$ac_cv_qt_cxx_flags"
		QT_MOC="$ac_cv_qt_moc"
		QT_UIC="$ac_cv_qt_uic"
		QT_INCLUDE="$ac_cv_qt_include"
		QT_LIB="$ac_cv_qt_lib"
		QT_LIBS="$ac_cv_qt_libs"
		QT_MT="$ac_cv_qt_mt"
		QT_GL="$ac_cv_qt_gl"
		QT_VERSION="$ac_cv_qt_version"
	fi

	AC_SUBST([QT_CXXFLAGS])
	AC_SUBST([QT_MOC])
	AC_SUBST([QT_UIC])
	AC_SUBST([QT_INCLUDE])
	AC_SUBST([QT_LIB])
	AC_SUBST([QT_LIBS])
	AC_SUBST([QT_MT])
	AC_SUBST([QT_GL])
	AC_SUBST([QT_VERSION])

	if test "$have_qt" = "yes" ; then
		AC_DEFINE([HAVE_QT],,[Define if you have Qt.])
	fi
	if test "$QT_MT" = "yes" ; then
		AC_DEFINE([HAVE_QT_MT],,[Define if multithreading is supported.])
	fi
	if test "$QT_GL" = "yes" ; then
		AC_DEFINE([HAVE_QT_GL],,[Define if OpenGL is supported.])
	fi
])

AC_DEFUN([AC_HAVE_QT_MAIN], [

	AC_REQUIRE([AC_PROG_CXX])
	AC_REQUIRE([AC_PATH_X])
	AC_REQUIRE([AC_PATH_XTRA])

	AC_HAVE_QT_SHORTEN_LIST([ac_have_qt_include])
	if test -z "$ac_have_qt_include" ; then
		have_qt="no"
	else
		AC_HAVE_QT_TAKE_INCLUDE([ac_have_qt_include])
		if test -z "$ac_have_qt_include" ; then
			have_qt="no"
		fi
	fi

	AC_HAVE_QT_SHORTEN_LIST([ac_have_qt_lib])
	if test -z "$ac_have_qt_lib" ; then
		have_qt="no"
	else
		AC_HAVE_QT_TAKE_LIB([ac_have_qt_lib])
		if test -z "$ac_have_qt_lib" ; then
			have_qt="no"
		fi
	fi

	AC_HAVE_QT_SHORTEN_LIST([ac_have_qt_moc])
	if test -z "$ac_have_qt_moc" ; then
		have_qt="no"
	else
		AC_HAVE_QT_TAKE_MOC([ac_have_qt_moc])
		if test -z "$ac_have_qt_moc" ; then
			have_qt="no"
		fi
	fi

	AC_HAVE_QT_SHORTEN_LIST([ac_have_qt_uic])
	if test -z "$ac_have_qt_uic" ; then
		ac_have_qt_uic="no"
dnl		have_qt="no"
	else
		AC_HAVE_QT_TAKE_UIC([ac_have_qt_uic])
		if test -z "$ac_have_qt_uic" ; then
			ac_have_qt_uic="no"
dnl			have_qt="no"
		fi
	fi

	if test "$ac_have_qt_mt" = "no" ; then
		ac_have_qt_mt_libs=
		ac_have_qt_mt_cflags=
	fi

	if test "$ac_have_qt_gl" = "no" ; then
		ac_have_qt_gl_libs=
		ac_have_qt_gl_cflags=
	fi

	if test "$have_qt" = "yes" ; then
		ac_cv_have_qt="yes"
		ac_cv_qt_cxx_flags="-I$ac_have_qt_include \
$ac_have_qt_mt_cflags $ac_have_qt_gl_cflags"
		ac_cv_qt_moc="$ac_have_qt_moc"
		ac_cv_qt_uic="$ac_have_qt_uic"
		ac_cv_qt_include="$ac_have_qt_include"
		ac_cv_qt_lib="$ac_have_qt_lib"
		ac_have_qt_tmp=${ac_have_qt_lib##*lib}
		ac_cv_qt_libs="-L${ac_have_qt_lib%/libqt*} \
-l${ac_have_qt_tmp%%.*} $X_PRE_LIBS $X_LIBS -lX11 -lXext -lXmu -lXt -lXi \
$X_EXTRA_LIBS $ac_have_qt_mt_libs $ac_have_qt_gl_libs"
		ac_cv_qt_mt="$ac_have_qt_mt"
		ac_cv_qt_gl="$ac_have_qt_gl"
		ac_cv_qt_version="$ac_have_qt_version"
	else
		ac_cv_have_qt="no"
		ac_cv_qt_cxx_flags=
		ac_cv_qt_moc=
		ac_cv_qt_uic=
		ac_cv_qt_include=
		ac_cv_qt_lib=
		ac_cv_qt_libs=
		ac_cv_qt_mt=
		ac_cv_qt_gl=
		ac_cv_qt_version=
	fi
])

AC_DEFUN([AC_HAVE_QT_SHORTEN_LIST], [
	ac_have_qt_tmp1=""
	for ac_have_qt_tmp2 in $$1 ; do
		if test -e "$ac_have_qt_tmp2" ; then
			ac_have_qt_tmp1="$ac_have_qt_tmp1 $ac_have_qt_tmp2"
		fi
	done
	$1="$ac_have_qt_tmp1"
])

AC_DEFUN([AC_HAVE_QT_TAKE_MOC], [
	AC_HAVE_QT_CREATE_MOC_TEST()
	AC_HAVE_QT_TAKE_ONE([$1], [
		ac_have_qt_tmp6="`$ac_have_qt_tmp5 -v 2>&1 | grep ersion`"
		if test -n "$ac_have_qt_tmp6" ; then
			ac_have_qt_tmp6="${ac_have_qt_tmp6##*Qt }"
			ac_have_qt_tmp6="${ac_have_qt_tmp6%)}"
		else
			rm -f ac_have_qt_moc_tmp.cpp
			$ac_have_qt_tmp5 ac_have_qt_tmp.cpp \
				-o ac_have_qt_moc_tmp.cpp 2> /dev/null
			if test -e ac_have_qt_moc_tmp.cpp ; then
				ac_have_qt_tmp6="`grep 'The Qt MOC' \
					ac_have_qt_moc_tmp.cpp | sed 's/*//g'`"
				ac_have_qt_tmp6="${ac_have_qt_tmp6%%  edi*}"
				ac_have_qt_tmp6="${ac_have_qt_tmp6##*  }"
				rm -f ac_have_qt_moc_tmp.cpp
			else
				ac_have_qt_tmp6="0.0.0"
			fi
		fi
		if test -z "$ac_have_qt_tmp6" ; then
dnl okay, this can only be a <= 1.45 moc, so we assume this,
dnl noone uses < 1.45 really anymore and i dont have the nerve for it :)
			ac_have_qt_tmp6="1.45"
		fi
		ac_have_qt_tmp7="$ac_have_qt_tmp5"
	])
	rm -f ac_have_qt_tmp.cpp
])

AC_DEFUN([AC_HAVE_QT_TAKE_UIC], [
	AC_HAVE_QT_TAKE_ONE([$1], [
		ac_have_qt_tmp6="`$ac_have_qt_tmp5 -version 2>&1 | grep ersion`"
		ac_have_qt_tmp6="${ac_have_qt_tmp6##*ersion }"
		if test -z "$ac_have_qt_tmp6" ; then
dnl okay, uic exists since > 2.2 (?) so we assume this
			ac_have_qt_tmp6="2.3.0"
		fi
		ac_have_qt_tmp7="$ac_have_qt_tmp5"
	])
])

AC_DEFUN([AC_HAVE_QT_TAKE_INCLUDE], [
	AC_HAVE_QT_TAKE_ONE([$1], [
		ac_have_qt_tmp6="`grep QT_VERSION_STR $ac_have_qt_tmp5 |
			sed 's/#//g;s/"//g;s/ //g;s/defineQT_VERSION_STR//g'`"
		ac_have_qt_tmp7="${ac_have_qt_tmp5%/qglobal.h}"
	])
	ac_have_qt_version="$ac_have_qt_tmp4"
])

AC_DEFUN([AC_HAVE_QT_TAKE_LIB], [
	ac_have_qt_tmp1=""
	ac_have_qt_tmp4=""
	ac_have_qt_tmp5=""
	for ac_have_qt_tmp2 in $$1 ; do
		ac_have_qt_tmp3="${ac_have_qt_tmp2%/*}"
		if test "$ac_have_qt_tmp3" = "$ac_have_qt_tmp4" ; then
			ac_have_qt_tmp6="${ac_have_qt_tmp2##*lib}"
			ac_have_qt_tmp6="${ac_have_qt_tmp6%%.*}"
			if test "$ac_have_qt_tmp5" != "$ac_have_qt_tmp6" ; then
				ac_have_qt_tmp5="$ac_have_qt_tmp6"
				ac_have_qt_tmp1="$ac_have_qt_tmp1 $ac_have_qt_tmp2"
			fi
		else
			ac_have_qt_tmp4="$ac_have_qt_tmp3"
			ac_have_qt_tmp5="${ac_have_qt_tmp2##*lib}"
			ac_have_qt_tmp5="${ac_have_qt_tmp5%%.*}"
			ac_have_qt_tmp1="$ac_have_qt_tmp1 $ac_have_qt_tmp2"
		fi
	done
	$1="$ac_have_qt_tmp1"
	AC_HAVE_QT_CREATE_LIB_TEST
	AC_HAVE_QT_TAKE_ONE([$1], [
		ac_have_qt_tmp="${ac_have_qt_tmp5##*lib}"
		rm -f ac_have_qt_tmp
		$CXX $ac_have_qt_mt_cflags $ac_have_qt_mt_libs \
			$ac_have_qt_gl_cflags $ac_have_qt_gl_libs \
			-L${ac_have_qt_tmp5%/*} -l${ac_have_qt_tmp%%.*} \
			ac_have_qt_tmp.cpp -o ac_have_qt_tmp 2> /dev/null

		if test -e ac_have_qt_tmp ; then
			ac_have_qt_tmp6="`./ac_have_qt_tmp`"
		else
			ac_have_qt_tmp6="0.0.0"
		fi

		ac_have_qt_tmp7="$ac_have_qt_tmp5"
		rm -f ac_have_qt_tmp
	])
	if test "$ac_have_qt_test_gl" = "yes" ; then
		AC_HAVE_QT_CREATE_GL_TEST
		rm -f ac_have_qt_tmp
		ac_have_qt_tmp="${$1##*lib}"

		$CXX $ac_have_qt_mt_cflags $ac_have_qt_mt_libs \
			$ac_have_qt_gl_cflags $ac_have_qt_gl_libs \
			-L${$1%/*} -l${ac_have_qt_tmp%%.*} \
			-I$ac_have_qt_include ac_have_qt_tmp.cpp \
			-o ac_have_qt_tmp 2> /dev/null

		if test -e ac_have_qt_tmp ; then
			ac_have_qt_gl="yes"
		else
			ac_have_qt_gl="no"
		fi
	fi

	if test "$ac_have_qt_test_mt" = "yes" ; then
		AC_HAVE_QT_CREATE_MT_TEST
		rm -f ac_have_qt_tmp
		ac_have_qt_tmp="${$1##*lib}"

		$CXX $ac_have_qt_mt_cflags $ac_have_qt_mt_libs \
			$ac_have_qt_gl_cflags $ac_have_qt_gl_libs \
			-L${$1%/*} -l${ac_have_qt_tmp%%.*} \
			-I$ac_have_qt_include ac_have_qt_tmp.cpp \
			-o ac_have_qt_tmp 2> /dev/null

		if test -e ac_have_qt_tmp ; then
			ac_have_qt_mt="yes"
		else
			ac_have_qt_mt="no"
		fi
	fi

	rm -f ac_have_qt_tmp
	rm -f ac_have_qt_tmp.cpp
])

AC_DEFUN([AC_HAVE_QT_TAKE_ONE], [
	ac_have_qt_tmp3=""
	ac_have_qt_tmp4="0.0.0"
	ac_have_qt_tmp8="000000"
	for ac_have_qt_tmp5 in $$1 ; do
		$2
		ac_have_qt_tmp6="`echo $ac_have_qt_tmp6 | sed 's/\ //g'`"
		ac_have_qt_tmp6="${ac_have_qt_tmp6%%-*}"
		if test -z "${ac_have_qt_tmp6#?.??}" ; then
			ac_have_qt_tmp6="1.4.5"
		fi

		AC_HAVE_QT_ADD_ZERO([ac_have_qt_tmp9], [${ac_have_qt_tmp6%%.*}])

		ac_have_qt_tmp="${ac_have_qt_tmp6#*.}"
		AC_HAVE_QT_ADD_ZERO([ac_have_qt_tmp], [${ac_have_qt_tmp%.*}])
		ac_have_qt_tmp9="${ac_have_qt_tmp9}${ac_have_qt_tmp}"

		AC_HAVE_QT_ADD_ZERO([ac_have_qt_tmp], [${ac_have_qt_tmp6##*.}])
		ac_have_qt_tmp9="${ac_have_qt_tmp9}${ac_have_qt_tmp}"

		if test "$ac_have_qt_tmp9" -gt "$ac_have_qt_tmp8" ; then
			ac_have_qt_tmp8="$ac_have_qt_tmp9"
			ac_have_qt_tmp4="$ac_have_qt_tmp6"
			ac_have_qt_tmp3="$ac_have_qt_tmp7"
		fi
	done
	if test "${ac_have_qt_tmp4}" != "${ac_have_qt_tmp4#1.}" ; then
		ac_have_qt_tmp4="1.45"
	fi
	$1="$ac_have_qt_tmp3"
])

AC_DEFUN([AC_HAVE_QT_ADD_ZERO], [
	if test "9" -ge "$2" ; then
		$1="0$2"
	else
		$1="$2"
	fi
])

AC_DEFUN([AC_HAVE_QT_CREATE_MOC_TEST], [
	cat > ac_have_qt_tmp.cpp << EOF
#include <qobject.h>
#include <qapplication.h>
class Foo : public QObject
{
Q_OBJECT
public:
	Foo(){}
	~Foo(){}
public slots:
	void me(){}
signals:
	void donation();
};
int main(int argC, char **argV)
{
	QApplication app(argC, argV);
	Foo *pFoo = new Foo();
	QObject::connect(pFoo, SIGNAL(donation()), pFoo, SLOT(me()));
	return app.exec();
}
EOF
])
AC_DEFUN([AC_HAVE_QT_CREATE_LIB_TEST], [
	cat > ac_have_qt_tmp.cpp << EOF
#include <stdio.h>
const char *qVersion();
int main()
{
	printf(qVersion());
	return 0;
}
EOF
])
AC_DEFUN([AC_HAVE_QT_CREATE_GL_TEST], [
	cat > ac_have_qt_tmp.cpp << EOF
#include <qgl.h>
#include <qapplication.h>
int main(int argC, char **argV)
{
	QApplication app(argC, argV);
	QGLWidget *pFoo = new QGLWidget();
	app.setMainWidget(pFoo);
	pFoo->show();
	return app.exec();
}
EOF
])
AC_DEFUN([AC_HAVE_QT_CREATE_MT_TEST], [
	cat > ac_have_qt_tmp.cpp << EOF
#include <qthread.h>
#include <qapplication.h>
class Foo : public QThread
{
public:
        Foo(){}
        virtual ~Foo(){}
protected:
        void run(){}
};
int main(int argC, char **argV)
{
	QApplication app(argC, argV);
        Foo *pFoo = new Foo();
        pFoo->start();
	pFoo->exit();
	return app.exec();
}
EOF
])

