
/*
 * Copyright (C) 2000 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <assert.h>
#include <curses.h>

#include <Object.h>
#include <octext.h>
#include <paragrph.h>
#include <txtstyle.h>
#include <ordcltn.h>

#include "charscan.h"
#include "dispscan.h"
#include "textline.h"

@implementation DisplayScanner 

- space
{
  mvwaddch(eti_win,desty,destx,' ');
  destx++;
  ++lastindex;
  stopscanning = NO;
  return self;
}

- setdestx
{
  char *s = [textStyle str];
  assert(s);
  if (!strcmp(s,"left")) { destx = leftmargin; }
  if (!strcmp(s,"right")) { destx = leftmargin + [line paddingwidth]; }
  if (!strcmp(s,"center")) { destx = leftmargin + [line paddingwidth]/2; }
  if (!strcmp(s,"justify")) { destx = leftmargin; }
  return self;
}

- tab
{
  destx += MYTABWIDTH; 
  stopscanning = NO;
  ++lastindex;
  return self;
}

- newline
{
  stopscanning = NO;
  ++lastindex;
  return self;
}

- crossedx
{
  stopscanning = YES;
  return self;
}

- toggleAttr:(BOOL)x:(int)a
{
  if (x) wattron(eti_win,a); else wattroff(eti_win,a);
  return self;
}

- endOfRun /* we're one position after last run */
{
  int linebreak = [line last];
  if (lastindex > linebreak) {
    stopscanning = YES;
  } else {
    int length = [text runLengthFor:lastindex];
    runstopindex = lastindex + length - 1;
    if (runstopindex > linebreak) runstopindex = linebreak;
    [self setfont];
    stopscanning = NO;
  }
  return self;
}

- displayLine:aLine num:(int)i in:paragraph at:(int)liney
{
  int length,linebreak;

  [self setparagraph:paragraph];
  line = aLine;

  lastindex = [line first];
  linebreak = [line last];
  lineheight = [line lineheight];

  [self setdestx];
  desty = liney + [line ascent];
  length = [text runLengthFor:lastindex];
  runstopindex = lastindex + length - 1;
  if (runstopindex > linebreak) runstopindex = linebreak;

  displaying = YES;

  [self setfont]; /* also set by -endOfRun */

  for(stopscanning = NO;!stopscanning;) {
    [self scancharsfrom:lastindex to:runstopindex in:[text string] rightx:rightmargin];
  }

  return self;
}


@end

