
/*
 * Copyright (C) 1998,99,2000 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <assert.h>
#include <curses.h>

#include <Object.h>
#include <octext.h>
#include <paragrph.h>
#include <txtstyle.h>
#include <txtattr.h>

#include <ordcltn.h>
#include "textline.h"
#include "charscan.h"


@implementation CharacterScanner 

- setwrapping:(BOOL)x
{
  dowrap=x;
  return self;
}

- setetiwin:(WINDOW*)w
{
  eti_win=w;
  return self;
}

- setparagraph:p
{
  text = [p text];
  textStyle = [p textStyle];
  return self; 
}

- setleftmargin:(int)x
{
  leftmargin = x;
  return self;
}

- setrightmargin:(int)x
{
  rightmargin = x;
  return self;
}
  
- setfont
{
  int i,n;
  id attrs;
  spacewidth=1;
  attrs = [text attributesAt:lastindex];
  if (eti_win) for(i=0,n=[attrs size];i<n;i++) {
    wattrset(eti_win,[[attrs at:i] emphasiscode]);
  }
  return self;
}

- space
{
  return [self subclassResponsibility];
}

- tab
{
  return [self subclassResponsibility];
}

- newline
{
  return [self subclassResponsibility];
}

- crossedx
{
  return [self subclassResponsibility];
}

- endOfRun
{
  return [self subclassResponsibility];
}

- toggleAttr:(BOOL)x:(int)a
{
  return self;
}

- scancharsfrom:(int)p to:(int)q in:string rightx:(int)rightx 
{
  char *ptr = [string str];

  lastindex = p;
  while (stopscanning == NO && lastindex <= q) {
    char c = ptr[lastindex];

    switch (c) {
      case ' '  : {
	[self space];
	break;
      }
      case '\n' : {
	[self newline];
	break;
      }
      case '\t' : {
	[self tab];
	break;
      }
      default   : {
	int newx;
        newx = destx + 1;
	if (displaying) mvwaddch(eti_win,desty,destx,c);
	if (newx > rightx) {
	  return [self crossedx];
	} else {
	  destx = newx;
	}
        ++lastindex;
	break;
      }
    }
  }

  return (stopscanning)?self:[self endOfRun];
}

@end

