/*
 * PT
 * Copyright (C) 2002, 2003  The Printing Tool Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * preferences.c
 */

#include <stdlib.h>

#include "preferences.h"


/*
 * p_read_preferences () - try to read preferences
 */

void p_read_preferences (preferences_t *p)
{
	FILE *file_pointer;
	gchar *home_dir, *pref_file_with_path, *s;
	gint i, v;
	preferences_t q;

	/*
	 * set default preferences
	 */

	q.show_rank = TRUE;
	q.show_priority = FALSE;
	q.show_id = FALSE;
	q.show_user = TRUE;
	q.show_title = TRUE;
	q.show_format = FALSE;
	q.show_copies = FALSE;
	q.show_dest = TRUE;
	q.show_state = TRUE;
	q.show_size = TRUE;
	q.show_creation_time = FALSE;
	q.show_processing_time = FALSE;
	q.sort_toggle = FALSE;
	q.sort_item = 0;
	q.filter_dest = g_strdup (NO_ARG);
	q.host = g_strdup (cupsServer ());
	q.port = ippPort ();
	q.refresh_interval = 1;
	q.priority_change = 10;
	q.width = 400;
	q.height = 200;
	q.user = g_strdup (cupsUser ());
#ifdef HAVE_LIBGNUTLS
	q.ssl = cupsEncryption ();
#else /*HAVE_LIBGNUTLS*/
	q.ssl = HTTP_ENCRYPT_NEVER;
#endif /*HAVE_LIBGNUTLS*/

	/*
	 * try to open preferences file in read mode
	 */

	if ((home_dir = getenv (HOME_ENV)) != NULL)
	{
		pref_file_with_path = g_strdup_printf ("%s/%s", home_dir, PREF_FILE);
		if ((file_pointer = fopen (pref_file_with_path, "r")) != NULL)
		{
			s = g_malloc (MAX_STRING_LENGTH + 2);

			for (i = 0; i <= 12; i++)
				if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer))
					!= NULL) && (s[0] != '\n'))
				{
					s[strlen (s) - 1] = 0;
					v = atoi (s);
					if ((v == 0) || (v == 1))
					{
						switch (i)
						{
							case 0 : q.show_rank = v; continue;
							case 1 : q.show_priority = v; continue;
							case 2 : q.show_id = v; continue;
							case 3 : q.show_user = v; continue;
							case 4 : q.show_title = v; continue;
							case 5 : q.show_format = v; continue;
							case 6 : q.show_copies = v; continue;
							case 7 : q.show_dest = v; continue;
							case 8 : q.show_state = v; continue;
							case 9 : q.show_size = v; continue;
							case 10 : q.show_creation_time = v; continue;
							case 11 : q.show_processing_time = v; continue;
							case 12 : q.sort_toggle = v;
						}
					}
				}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= 11))
					q.sort_item = v;
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				g_free (q.filter_dest);
				q.filter_dest = g_strdup (s);
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				g_free (q.host);
				q.host = g_strdup (s);
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= MAX_PORT_VALUE))
					q.port = v;
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= 10))
					q.refresh_interval = v;
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= 100))
					q.priority_change = v;
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= 10000))
					q.width = v;
			}
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= 10000))
					q.height = v;
			}
#ifdef ALIEN_USER
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				g_free (q.user);
				q.user = g_strdup (s);
			}
#endif /*ALIEN_USER*/
#ifdef HAVE_LIBGNUTLS
#ifndef ALIEN_USER
			fgets (s, MAX_STRING_LENGTH + 2, file_pointer);
#endif /*ALIEN_USER*/
			if (((s = fgets (s, MAX_STRING_LENGTH + 2, file_pointer)) != NULL) && (s[0] != '\n'))
			{
				s[strlen (s) - 1] = 0;
				v = atoi (s);
				if ((v >= 0) && (v <= 3))
					q.ssl = v;
			}
#endif /*HAVE_LIBGNUTLS*/

			fclose (file_pointer);
			g_free (s);
		}
		g_free (pref_file_with_path);
	}
	
	/*
	 * call by reference
	 */	

	*p = q;
	return;
}

/*
 * p_write_preferences () - try to write preferences
 */

void p_write_preferences (const preferences_t *p)
{
	FILE *file_pointer;
	gchar *home_dir, *pref_file_with_path, *tmp;

	/*
	 * try to open preferences file in (over)writing mode
	 */

	if ((home_dir = getenv (HOME_ENV)) != NULL)
	{
		pref_file_with_path = g_strdup_printf ("%s/%s", home_dir, PREF_FILE);
		if ((file_pointer = fopen (pref_file_with_path, "w+")) != NULL)
		{
			tmp = g_strdup_printf (
				"%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%s\n%s\n%d\n%d\n%d\n%d\n%d\n%s\n%d\n",
				p->show_rank,
				p->show_priority,
				p->show_id,
				p->show_user,
				p->show_title,
				p->show_format,
				p->show_copies,
				p->show_dest,
				p->show_state,
				p->show_size,
				p->show_creation_time,
				p->show_processing_time,
				p->sort_toggle,
				p->sort_item,
				p->filter_dest,
				p->host,
				p->port,
				p->refresh_interval,
				p->priority_change,
				p->width,
				p->height,
				p->user,
				p->ssl);
			fputs (tmp, file_pointer);	
			fclose (file_pointer);
		}
		g_free (pref_file_with_path);
	}
	return;
}
