# smooth.rb : A simple averageing filter
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

module SciYAG

  # A filter that sorts data and then averages the Y values of all the
  # elements which have the same X value.
  class AverageDupFilter < Filter
    include Dobjects

    describe "avgdup", "Average duplicates",
    "Sorts the points according to the X values and average successive "+
      "points with identical X values"

    def initialize
    end

    # There you go: a simple sorting/averaging filter.
    def apply(f)
      a = Function.new(f.x.dup, f.y.dup)
      a.sort
      nb_currently_averaged = 1
      nx = Dvector.new
      ny = Dvector.new
        
      for x,y in a
        if x == nx.last
          ny[ny.size - 1] += y
          nb_currently_averaged += 1
        else
          ny[ny.size - 1] /= nb_currently_averaged if ny.last
          nb_currently_averaged = 1
          nx.push(x)
          ny.push(y)
        end
      end
      return Function.new(nx,ny)
    end

    # We simply replace the old vectors by the new ones.
    def apply!(f)
      new_f = apply(f)
      f.x.replace(new_f.x)
      f.y.replace(new_f.y)
    end
  end
end
