<CsoundSynthesizer>

; Id: A01.CSD mg (2006, rev.2009)
; author: marco gasperini (marcogsp at yahoo dot it)

; G.M. Koenig
; ESSAY (1957)

<CsOptions>
-W -f -oA01.wav
</CsOptions>

<CsInstruments>


sr     = 192000
kr     = 192000
ksmps  = 1
nchnls = 1

;=============================================
; SINUS TONES
;=============================================
	instr 1	
iamp	= ampdb(87+p4)
ifreq	= p5

a1	oscili iamp , ifreq , 1
aenv	expseg .001 , .005, 1 , p3-.01 ,1, .005,.001

aout	= a1 * aenv

	out aout
	endin
;=============================================

;=============================================
; FILTERED NOISE
;=============================================
	instr 2
iamp	= ampdb(87+p4)
ifreq	= p5
ibw	= ifreq * .05		; filtered noise's bandwidth 5% of central frequency

a1	rnd31 iamp , 1 
k1	rms a1

afilt	butterbp a1 , ifreq , ibw
afilt	butterbp afilt , ifreq , ibw

aenv	expseg .001 , .005, .8 , p3-.01 ,.8 ,.005,.001

aout	gain afilt , k1
aout	= aout * aenv 

	out aout
	endin
;=============================================

;=============================================
; FILTERED IMPULSES
;=============================================
	instr 3
iamp	= ampdb(87+p4)
ifreq	= p5
ibw	= ifreq * .01		; filtered pulse's bandwidth 1% of central frequency
				
if1	= ifreq-(ibw/3)
if2	= ifreq+((2*ibw)/3)

				
a1	mpulse iamp , 0 

afilt	atonex a1 , if1 , 4
afilt	tonex afilt*500 , if2 , 4 
afilt	butterbp afilt*900 , ifreq , ibw*.05


aenv	linseg 1 , p3-.01, 1 , .01 , 0

aout	= afilt * aenv 

	out aout*(sr/192000)
	endin
;=============================================

</CsInstruments>
<CsScore>
;functions--------------------------------------------------
f1	0	8192	10	1	; sinusoid
;/functions--------------------------------------------------

t0	4572	; 76.2 cm/sec. tape speed (durations in cm)
		
;test--------------------------------------------------
;mute-------------------------------------------------
q 1 0 1
q 2 0 1
q 3 0 1
;/mute-------------------------------------------------
;/test-------------------------------------------------

;==================================================
; 110. MATERIAL A
; 111. total length: 384.7 cm, 7 sections
;
; length   sequence 	
; 12    cm (1)
; 17.9  cm (2)
; 60.5  cm (5)
; 40.4  cm (4)
; 26.9  cm (3)
; 136.2 cm (7)
; 90.8  cm (6)
;==================================================

;==================================111.1
; 12 cm ratio 12/11
;---------------------------------------
; x
;			p4	p5
;			iamp	ifreq
;			[dB]	[Hz]	timbre
i1	0	1.5	-6	456 	; S
i1	+	1.4	. 	441	; S
i1	+	1.1	. 	400	; S
i1	+	1.8	. 	486	; S
i1	+	1.7	. 	471	; S
i2	7.5	1.2	-9	413	; N
i1	8.7	2	-6	502	; S
i1	+	1.3	. 	427	; S
; y
i1	0	1.5	-6	703	; S
i1	+	1.4	. 	644	; S
i1	+	1.1	. 	591	; S
i1	+	1.8	. 	542	; S
i1	+	1.7	. 	519	; S
i2	7.5	1.2	-9 	566	; N
i1	8.7	2	-6 	617	; S
i1	+	1.3	. 	673	; S
s                                   
t0	4572	
;==================================111.2
; 17.9 cm ratio 11/10
;---------------------------------------
i1	0	2.1	-3	476	; S
i1	+	1.9	. 	508	; S
i2	4	3	-6	542	; N
i2	+	2.5	. 	578	; N
i1	9.5	2.3	-3	617	; S
i1	+	1.6	. 	658	; S
i1	+	2.7	. 	703	; S
i2	16.1	1.7	-6	750	; N
s                                   
t0	4572	
;==================================111.3
; 60.5 cm ratio 8/7
;---------------------------------------
; x 
i2	0	4.5	-9	591	; N
i2	+	11.5	. 	584	; N
i1	16	7.7	-6	566	; S	
i1	+	5.9	. 	604	; S	
i2	29.6	5.2	-9	597	; N		
i2	+	8.8	. 	572	; N
i2	+	6.8	.	610	; N	
i2	+	10.1	-10	578	; N
; y                                 
i2	0	4.5	-9	554	; N
i2	+	11.5	. 	542	; N
i1	16	7.7	-6	530	; S
i1	+	5.9	. 	519	; S
i2	29.6	5.2	-9	524	; N
i2	+	8.8	. 	536	; N
i2	+	6.8	. 	548	; N
i2	+	10.1	-10 	560	; N
s                                   
t0	4572	
;==================================111.4
; 40.4 cm ratio 9/8
;---------------------------------------
; x
i1	0	6.5	-6	436	; S
i2	6.5	5.8	-9	476	; N
i2	+	4.1	.	519	; N
i2	+	3.2	.	566	; N
i2	+	7.4	.	617	; N
i2	+	4.6	.	673	; N	
i2	+	3.6	.	734	; N
i3	35.2	5.2	-1	800	; I
; y                                 
i1	0	6.5	-6	734	; S
i2	6.5	5.8	-9	673	; N
i2	+	4.1	.	617	; N
i2	+	3.2	.	566	; N
i2	+	7.4	.	519	; N
i2	+	4.6	.	476	; N
i2	+	3.6	.	436	; N
i3	35.2	5.2	-2	400	; I
s                                   
t0	4572	
;==================================111.5
; 26.9 cm ratio 10/9
;---------------------------------------
; x
i2	0	3.8	-9	497	; N
i2	+	3.4	.	491	; N
i2	+	2.5	-10	476	; N
i2	+	4.7	-9	508	; N
i3	14.4	4.3	0	502	; I
i3	+	2.8	.	481	; I
i2	21.5	2.3	-9	513	; N
i2	+	3.1	.	486	; N
; y                                 
i2	0	3.8	-9	530	; N
i2	+	3.4	.	554	; N
i2	+	2.5	.	578	; N
i2	+	4.7	.	604	; N
i3	14.4	4.3	0	591	; I
i3	+	2.8	.	566	; I
i2	21.5	2.3	-9	542	; N
i2	+	3.1	.	519	; N
s                                   
t0	4572	
;==================================111.6
; 136.2 cm ratio 6/5
;---------------------------------------
i2	0	9.9	-6	637	; N
i3	9.9	8.3	3	604	; I
i3	+	20.5	3	572	; I
i3	+	14.3	3	542	; I
i2	53	11.9	-6	513	; N	
i2	+	24.6	-6	486	; N
i3	89.5	17.1	3	461	; I
i3	+	29.6	3	436	; I
s                                   
t0	4572	
;==================================111.7
; 90.8 cm ratio 7/6
;---------------------------------------
; x
i3	0	18.3	-1	617	; I
i3	+	15.7	-1	604     ; I
i2	34	9.9	-9	566	; N
i3	43.9	7.2	-1	644	; I
i3	+	6.2	-1	630     ; I
i3	+	11.5	-1	578     ; I
i3	+	8.5	-1	658     ; I
i3	+	13.5	-1	591     ; I
; y                                 
i3	0	18.3	-1	476	; I
i3	+	15.7	-1	497     ; I
i2	34	9.9	-9	519	; N
i3	43.9	7.2	-1	542	; I
i3	+	6.2	-1	554     ; I
i3	+	11.5	-1	530     ; I
i3	+	8.5	-1	508     ; I
i3	+	13.5	-1	486     ; I
                                    
; total length: 384.7 cm
e
</CsScore>
</CsoundSynthesizer>