// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "CsoundGUI.hpp"

void CsoundUtilitiesWindow::cb_cvanalButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_CVANAL_RUNNING)
  p->stopCvanal();
else
  p->startCvanal();
}
void CsoundUtilitiesWindow::cb_cvanalButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_cvanalButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_cvanalInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->cvanal_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_cvanalInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_cvanalInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb__i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->cvanal_inputFile, "Select input file for convolve analysis", CSOUND5GUI_FILETYPE_AUDIO, false);
  cvanalInputFileInput->value(u_cfg->cvanal_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb__i(o,v);
}

void CsoundUtilitiesWindow::cb_cvanalOutputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->cvanal_outputFile, o->value());
}
void CsoundUtilitiesWindow::cb_cvanalOutputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_cvanalOutputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_1_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->cvanal_outputFile, "Select output file for convolve analysis", CSOUND5GUI_FILETYPE_CONVOLVE, true);
  cvanalOutputFileInput->value(u_cfg->cvanal_outputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_1(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Channel_i(Fl_Spinner* o, void*) {
  u_cfg->cvanal_channel = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Channel(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_Channel_i(o,v);
}

void CsoundUtilitiesWindow::cb_Begin_i(Fl_Value_Input* o, void*) {
  u_cfg->cvanal_beginTime = o->value();
}
void CsoundUtilitiesWindow::cb_Begin(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_Begin_i(o,v);
}

void CsoundUtilitiesWindow::cb_Duration_i(Fl_Value_Input* o, void*) {
  u_cfg->cvanal_duration = o->value();
}
void CsoundUtilitiesWindow::cb_Duration(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_Duration_i(o,v);
}

void CsoundUtilitiesWindow::cb_pvanalInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->pvanal_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_pvanalInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pvanalInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_2_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->pvanal_inputFile, "Select input file for PVOC analysis", CSOUND5GUI_FILETYPE_AUDIO, false);
  pvanalInputFileInput->value(u_cfg->pvanal_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_2(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_2_i(o,v);
}

void CsoundUtilitiesWindow::cb_pvanalOutputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->pvanal_outputFile, o->value());
}
void CsoundUtilitiesWindow::cb_pvanalOutputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pvanalOutputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_3_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->pvanal_outputFile, "Select output file for PVOC analysis", CSOUND5GUI_FILETYPE_PVOC, true);
  pvanalOutputFileInput->value(u_cfg->pvanal_outputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_3(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_3_i(o,v);
}

void CsoundUtilitiesWindow::cb_Channel1_i(Fl_Spinner* o, void*) {
  u_cfg->pvanal_channel = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Channel1(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Channel1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Begin1_i(Fl_Value_Input* o, void*) {
  u_cfg->pvanal_beginTime = o->value();
}
void CsoundUtilitiesWindow::cb_Begin1(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Begin1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Duration1_i(Fl_Value_Input* o, void*) {
  u_cfg->pvanal_duration = o->value();
}
void CsoundUtilitiesWindow::cb_Duration1(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Duration1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Frame_i(Fl_Choice* o, void*) {
  u_cfg->pvanal_frameSize = (1 << ((int) (o->value() + 0.5) + 8));
}
void CsoundUtilitiesWindow::cb_Frame(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Frame_i(o,v);
}

void CsoundUtilitiesWindow::cb_Overlaps_i(Fl_Choice* o, void*) {
  {
  u_cfg->pvanal_overlap = (o->value() > 0 ? (1 << (int) (o->value() + 0.5)) : 0);
  if (u_cfg->pvanal_overlap > 1) {
    pvanalHopSizeInput->deactivate();
    pvanalHopSizeInput->value((int) (std::log((double) (u_cfg->pvanal_frameSize / u_cfg->pvanal_overlap)) / std::log(2.0) + 0.5) - 4);
  }
  else {
    pvanalHopSizeInput->value((int) (std::log((double) u_cfg->pvanal_hopSize) / std::log(2.0) + 0.5) - 4);
    pvanalHopSizeInput->activate();
  }
};
}
void CsoundUtilitiesWindow::cb_Overlaps(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Overlaps_i(o,v);
}

void CsoundUtilitiesWindow::cb_Window_i(Fl_Choice* o, void*) {
  u_cfg->pvanal_windowType = o->value();
}
void CsoundUtilitiesWindow::cb_Window(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Window_i(o,v);
}

void CsoundUtilitiesWindow::cb_pvanalHopSizeInput_i(Fl_Choice* o, void*) {
  {
  u_cfg->pvanal_hopSize = (1 << ((int) (o->value() + 0.5) + 4));
  if (u_cfg->pvanal_hopSize >= u_cfg->pvanal_frameSize) {
    u_cfg->pvanal_hopSize = u_cfg->pvanal_frameSize >> 1;
    o->value((int) (std::log((double) u_cfg->pvanal_hopSize) / std::log(2.0) + 0.5) - 4);
  }
};
}
void CsoundUtilitiesWindow::cb_pvanalHopSizeInput(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pvanalHopSizeInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_pvanalButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_PVANAL_RUNNING)
  p->stopPvanal();
else
  p->startPvanal();
}
void CsoundUtilitiesWindow::cb_pvanalButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_pvanalButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_hetroInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->hetro_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_hetroInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hetroInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_4_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->hetro_inputFile, "Select input file for hetrodyne analysis", CSOUND5GUI_FILETYPE_AUDIO, false);
  hetroInputFileInput->value(u_cfg->hetro_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_4(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_4_i(o,v);
}

void CsoundUtilitiesWindow::cb_hetroOutputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->hetro_outputFile, o->value());
}
void CsoundUtilitiesWindow::cb_hetroOutputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hetroOutputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_5_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->hetro_outputFile, "Select output file for hetrodyne analysis", CSOUND5GUI_FILETYPE_HETRO, true);
  hetroOutputFileInput->value(u_cfg->hetro_outputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_5(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_5_i(o,v);
}

void CsoundUtilitiesWindow::cb_Channel2_i(Fl_Spinner* o, void*) {
  u_cfg->hetro_channel = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Channel2(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Channel2_i(o,v);
}

void CsoundUtilitiesWindow::cb_Begin2_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_beginTime = o->value();
}
void CsoundUtilitiesWindow::cb_Begin2(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Begin2_i(o,v);
}

void CsoundUtilitiesWindow::cb_Duration2_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_duration = o->value();
}
void CsoundUtilitiesWindow::cb_Duration2(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Duration2_i(o,v);
}

void CsoundUtilitiesWindow::cb_Starting_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_startFreq = o->value();
}
void CsoundUtilitiesWindow::cb_Starting(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Starting_i(o,v);
}

void CsoundUtilitiesWindow::cb_Number_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_partials = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Number(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Number_i(o,v);
}

void CsoundUtilitiesWindow::cb_Breakpoints_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_breakPoints = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Breakpoints(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Breakpoints_i(o,v);
}

void CsoundUtilitiesWindow::cb_Amplitude_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_minAmp = o->value();
}
void CsoundUtilitiesWindow::cb_Amplitude(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Amplitude_i(o,v);
}

void CsoundUtilitiesWindow::cb_Cutoff_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_cutoffFreq = o->value();
}
void CsoundUtilitiesWindow::cb_Cutoff(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Cutoff_i(o,v);
}

void CsoundUtilitiesWindow::cb_Maximum_i(Fl_Value_Input* o, void*) {
  u_cfg->hetro_maxAmp = o->value();
}
void CsoundUtilitiesWindow::cb_Maximum(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Maximum_i(o,v);
}

void CsoundUtilitiesWindow::cb_hetroButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_HETRO_RUNNING)
  p->stopHetro();
else
  p->startHetro();
}
void CsoundUtilitiesWindow::cb_hetroButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_hetroButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_lpanalInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->lpanal_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_lpanalInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_lpanalInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_6_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->lpanal_inputFile, "Select input file for LPC analysis", CSOUND5GUI_FILETYPE_AUDIO, false);
  lpanalInputFileInput->value(u_cfg->lpanal_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_6(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_6_i(o,v);
}

void CsoundUtilitiesWindow::cb_lpanalOutputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->lpanal_outputFile, o->value());
}
void CsoundUtilitiesWindow::cb_lpanalOutputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_lpanalOutputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_7_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->lpanal_outputFile, "Select output file for LPC analysis", CSOUND5GUI_FILETYPE_LPC, true);
  lpanalOutputFileInput->value(u_cfg->lpanal_outputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_7(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_7_i(o,v);
}

void CsoundUtilitiesWindow::cb_Channel3_i(Fl_Spinner* o, void*) {
  u_cfg->lpanal_channel = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Channel3(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Channel3_i(o,v);
}

void CsoundUtilitiesWindow::cb_Begin3_i(Fl_Value_Input* o, void*) {
  u_cfg->lpanal_beginTime = o->value();
}
void CsoundUtilitiesWindow::cb_Begin3(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Begin3_i(o,v);
}

void CsoundUtilitiesWindow::cb_Duration3_i(Fl_Value_Input* o, void*) {
  u_cfg->lpanal_duration = o->value();
}
void CsoundUtilitiesWindow::cb_Duration3(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Duration3_i(o,v);
}

void CsoundUtilitiesWindow::cb_Number1_i(Fl_Value_Input* o, void*) {
  u_cfg->lpanal_poles = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Number1(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Number1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Hop_i(Fl_Value_Input* o, void*) {
  u_cfg->lpanal_hopSize = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Hop(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Hop_i(o,v);
}

void CsoundUtilitiesWindow::cb_Minimum_i(Fl_Value_Input* o, void*) {
  u_cfg->lpanal_minFreq = o->value();
}
void CsoundUtilitiesWindow::cb_Minimum(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Minimum_i(o,v);
}

void CsoundUtilitiesWindow::cb_Verbosity_i(Fl_Choice* o, void*) {
  u_cfg->lpanal_verbosity = o->value();
}
void CsoundUtilitiesWindow::cb_Verbosity(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Verbosity_i(o,v);
}

void CsoundUtilitiesWindow::cb_Maximum1_i(Fl_Value_Input* o, void*) {
  u_cfg->lpanal_maxFreq = o->value();
}
void CsoundUtilitiesWindow::cb_Maximum1(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Maximum1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Alternate_i(Fl_Check_Button* o, void*) {
  u_cfg->lpanal_altMode = (o->value() == 0 ? false : true);
}
void CsoundUtilitiesWindow::cb_Alternate(Fl_Check_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Alternate_i(o,v);
}

void CsoundUtilitiesWindow::cb_Comment_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->lpanal_comment, o->value());
}
void CsoundUtilitiesWindow::cb_Comment(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Comment_i(o,v);
}

void CsoundUtilitiesWindow::cb_lpanalButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_LPANAL_RUNNING)
  p->stopLpanal();
else
  p->startLpanal();
}
void CsoundUtilitiesWindow::cb_lpanalButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_lpanalButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_srconvInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->srconv_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_srconvInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_srconvInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_8_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->srconv_inputFile, "Select input file for sample rate conversion", CSOUND5GUI_FILETYPE_AUDIO, false);
  srconvInputFileInput->value(u_cfg->srconv_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_8(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_8_i(o,v);
}

void CsoundUtilitiesWindow::cb_srconvOutputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->srconv_outputFile, o->value());
}
void CsoundUtilitiesWindow::cb_srconvOutputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_srconvOutputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_9_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->srconv_outputFile, "Select output file for sample rate conversion", CSOUND5GUI_FILETYPE_AUDIO, true);
  srconvOutputFileInput->value(u_cfg->srconv_outputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_9(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_9_i(o,v);
}

void CsoundUtilitiesWindow::cb_Pitch_i(Fl_Value_Input* o, void*) {
  u_cfg->srconv_pitchRatio = o->value();
if (u_cfg->srconv_pitchRatio <= 0.0) {
  srconvSampleRateInput->value(u_cfg->srconv_sampleRate);
  srconvSampleRateInput->activate();
}
else {
  srconvSampleRateInput->deactivate();
  srconvSampleRateInput->value(-1.0);
};
}
void CsoundUtilitiesWindow::cb_Pitch(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Pitch_i(o,v);
}

void CsoundUtilitiesWindow::cb_srconvSampleRateInput_i(Fl_Value_Input* o, void*) {
  u_cfg->srconv_sampleRate = o->value();
if (u_cfg->srconv_sampleRate <= 0.0) {
  u_cfg->srconv_sampleRate = 44100.0;
  o->value(u_cfg->srconv_sampleRate);
};
}
void CsoundUtilitiesWindow::cb_srconvSampleRateInput(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_srconvSampleRateInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_Quality_i(Fl_Spinner* o, void*) {
  u_cfg->srconv_quality = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Quality(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Quality_i(o,v);
}

void CsoundUtilitiesWindow::cb_Enable_i(Fl_Check_Button* o, void*) {
  u_cfg->srconv_peakChunks = (o->value() == 0 ? false : true);
}
void CsoundUtilitiesWindow::cb_Enable(Fl_Check_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Enable_i(o,v);
}

void CsoundUtilitiesWindow::cb_File_i(Fl_Choice* o, void*) {
  u_cfg->srconv_fileType = o->value();
}
void CsoundUtilitiesWindow::cb_File(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_File_i(o,v);
}

void CsoundUtilitiesWindow::cb_Rewrite_i(Fl_Check_Button* o, void*) {
  u_cfg->srconv_rewriteHeader = (o->value() == 0 ? false : true);
}
void CsoundUtilitiesWindow::cb_Rewrite(Fl_Check_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Rewrite_i(o,v);
}

void CsoundUtilitiesWindow::cb_Sample_i(Fl_Choice* o, void*) {
  u_cfg->srconv_sampleFormat = o->value();
}
void CsoundUtilitiesWindow::cb_Sample(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Sample_i(o,v);
}

void CsoundUtilitiesWindow::cb_Heartbeat_i(Fl_Choice* o, void*) {
  u_cfg->srconv_heartBeat = o->value();
}
void CsoundUtilitiesWindow::cb_Heartbeat(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Heartbeat_i(o,v);
}

void CsoundUtilitiesWindow::cb_srconvButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_SRCONV_RUNNING)
  p->stopSrconv();
else
  p->startSrconv();
}
void CsoundUtilitiesWindow::cb_srconvButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_srconvButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_dnoiseInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->dnoise_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_dnoiseInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_dnoiseInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_a_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->dnoise_inputFile, "Select input file for noise reduction", CSOUND5GUI_FILETYPE_AUDIO, false);
  dnoiseInputFileInput->value(u_cfg->dnoise_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_a(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_a_i(o,v);
}

void CsoundUtilitiesWindow::cb_dnoiseOutputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->dnoise_outputFile, o->value());
}
void CsoundUtilitiesWindow::cb_dnoiseOutputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_dnoiseOutputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_b_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->dnoise_outputFile, "Select output file for noise reduction", CSOUND5GUI_FILETYPE_AUDIO, true);
  dnoiseOutputFileInput->value(u_cfg->dnoise_outputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_b(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_b_i(o,v);
}

void CsoundUtilitiesWindow::cb_dnoiseNoiseFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->dnoise_noiseFile, o->value());
}
void CsoundUtilitiesWindow::cb_dnoiseNoiseFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_dnoiseNoiseFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_c_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->dnoise_noiseFile, "Select noise reference file", CSOUND5GUI_FILETYPE_AUDIO, false);
  dnoiseNoiseFileInput->value(u_cfg->dnoise_noiseFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_c(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_c_i(o,v);
}

void CsoundUtilitiesWindow::cb_FFT_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_fftSize = o->value();
}
void CsoundUtilitiesWindow::cb_FFT(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_FFT_i(o,v);
}

void CsoundUtilitiesWindow::cb_Synthesis_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_synLen = o->value();
}
void CsoundUtilitiesWindow::cb_Synthesis(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Synthesis_i(o,v);
}

void CsoundUtilitiesWindow::cb_Analysis_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_overlap = o->value();
}
void CsoundUtilitiesWindow::cb_Analysis(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Analysis_i(o,v);
}

void CsoundUtilitiesWindow::cb_Decimation_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_decFact = o->value();
}
void CsoundUtilitiesWindow::cb_Decimation(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Decimation_i(o,v);
}

void CsoundUtilitiesWindow::cb_Begin4_i(Fl_Value_Input* o, void*) {
  u_cfg->dnoise_beginTime = o->value();
}
void CsoundUtilitiesWindow::cb_Begin4(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Begin4_i(o,v);
}

void CsoundUtilitiesWindow::cb_FFT1_i(Fl_Spinner* o, void*) {
  u_cfg->dnoise_numFFT = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_FFT1(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_FFT1_i(o,v);
}

void CsoundUtilitiesWindow::cb_End_i(Fl_Value_Input* o, void*) {
  u_cfg->dnoise_endTime = o->value();
}
void CsoundUtilitiesWindow::cb_End(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_End_i(o,v);
}

void CsoundUtilitiesWindow::cb_Threshold_i(Fl_Value_Input* o, void*) {
  u_cfg->dnoise_threshold = o->value();
}
void CsoundUtilitiesWindow::cb_Threshold(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Threshold_i(o,v);
}

void CsoundUtilitiesWindow::cb_Noise_i(Fl_Spinner* o, void*) {
  u_cfg->dnoise_sharpness = (int) (o->value() + 0.5);
}
void CsoundUtilitiesWindow::cb_Noise(Fl_Spinner* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Noise_i(o,v);
}

void CsoundUtilitiesWindow::cb_Minimum1_i(Fl_Value_Input* o, void*) {
  u_cfg->dnoise_minGain = o->value();
}
void CsoundUtilitiesWindow::cb_Minimum1(Fl_Value_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Minimum1_i(o,v);
}

void CsoundUtilitiesWindow::cb_File1_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_fileType = o->value();
}
void CsoundUtilitiesWindow::cb_File1(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_File1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Heartbeat1_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_heartBeat = o->value();
}
void CsoundUtilitiesWindow::cb_Heartbeat1(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Heartbeat1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Sample1_i(Fl_Choice* o, void*) {
  u_cfg->dnoise_sampleFormat = o->value();
}
void CsoundUtilitiesWindow::cb_Sample1(Fl_Choice* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Sample1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Rewrite1_i(Fl_Check_Button* o, void*) {
  u_cfg->dnoise_rewriteHeader = (o->value() == 0 ? false : true);
}
void CsoundUtilitiesWindow::cb_Rewrite1(Fl_Check_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Rewrite1_i(o,v);
}

void CsoundUtilitiesWindow::cb_Verbose_i(Fl_Check_Button* o, void*) {
  u_cfg->dnoise_verbose = (o->value() == 0 ? false : true);
}
void CsoundUtilitiesWindow::cb_Verbose(Fl_Check_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Verbose_i(o,v);
}

void CsoundUtilitiesWindow::cb_dnoiseButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_DNOISE_RUNNING)
  p->stopDnoise();
else
  p->startDnoise();
}
void CsoundUtilitiesWindow::cb_dnoiseButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_dnoiseButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_sndinfoInputFileInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(u_cfg->sndinfo_inputFile, o->value());
}
void CsoundUtilitiesWindow::cb_sndinfoInputFileInput(Fl_Input* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sndinfoInputFileInput_i(o,v);
}

void CsoundUtilitiesWindow::cb_d_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(u_cfg->sndinfo_inputFile, "Select sound file", CSOUND5GUI_FILETYPE_AUDIO, false);
  sndinfoInputFileInput->value(u_cfg->sndinfo_inputFile.c_str());
};
}
void CsoundUtilitiesWindow::cb_d(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_d_i(o,v);
}

void CsoundUtilitiesWindow::cb_sndinfoButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_SNDINFO_RUNNING)
  p->stopSndinfo();
else
  p->startSndinfo();
}
void CsoundUtilitiesWindow::cb_sndinfoButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_sndinfoButton_i(o,v);
}

void CsoundUtilitiesWindow::cb_Print_i(Fl_Check_Button* o, void*) {
  u_cfg->listOpcodes_printDetails = (o->value() == 0 ? false : true);
}
void CsoundUtilitiesWindow::cb_Print(Fl_Check_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Print_i(o,v);
}

void CsoundUtilitiesWindow::cb_listOpcodesButton_i(Fl_Button*, void*) {
  if (p->utilityState & CSOUND5GUI_LISTOPCODES_RUNNING)
  p->stopListOpcodes();
else
  p->startListOpcodes();
}
void CsoundUtilitiesWindow::cb_listOpcodesButton(Fl_Button* o, void* v) {
  ((CsoundUtilitiesWindow*)(o->parent()->parent()->parent()->user_data()))->cb_listOpcodesButton_i(o,v);
}

CsoundUtilitiesWindow::CsoundUtilitiesWindow(CsoundGUIMain *p) {
  Fl_Double_Window* w;
  {
  this->p = p;
  this->u_cfg = &(p->currentUtilitySettings);
}
  { Fl_Double_Window* o = window = new Fl_Double_Window(450, 390, "Utilities");
    w = o;
    o->user_data((void*)(this));
    { Fl_Tabs* o = new Fl_Tabs(0, 0, 450, 390);
      o->box(FL_PLASTIC_THIN_UP_BOX);
      o->selection_color(FL_BACKGROUND2_COLOR);
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "Convolve");
        o->tooltip("Sound file analysis for convolve");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          o->end();
        }
        { Fl_Button* o = cvanalButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_cvanalButton);
          if (!(p->utilityState & CSOUND5GUI_CVANAL_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_CVANAL_RUNNING) o->label("Stop");
        }
        { Fl_Input* o = cvanalInputFileInput = new Fl_Input(25, 50, 305, 25, "Input file");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_cvanalInputFileInput);
          o->align(FL_ALIGN_RIGHT);
          o->value(u_cfg->cvanal_inputFile.c_str());
        }
        { Fl_Button* o = new Fl_Button(410, 50, 25, 25, "...");
          o->tooltip("Browse input file for convolve analysis");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_);
        }
        { Fl_Input* o = cvanalOutputFileInput = new Fl_Input(25, 85, 305, 25, "Output file");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_cvanalOutputFileInput);
          o->align(FL_ALIGN_RIGHT);
          o->value(u_cfg->cvanal_outputFile.c_str());
        }
        { Fl_Button* o = new Fl_Button(410, 85, 25, 25, "...");
          o->tooltip("Browse output file for convolve analysis");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_1);
        }
        { Fl_Spinner* o = new Fl_Spinner(25, 120, 60, 25, "Channel number (0: all)");
          o->callback((Fl_Callback*)cb_Channel);
          o->align(FL_ALIGN_RIGHT);
          o->range(0.0, 8.0);
          o->step(1.0);
          o->value((double) u_cfg->cvanal_channel);
        }
        { Fl_Value_Input* o = new Fl_Value_Input(25, 155, 60, 25, "Begin time in seconds");
          o->box(FL_THIN_DOWN_BOX);
          o->maximum(10000);
          o->callback((Fl_Callback*)cb_Begin);
          o->align(FL_ALIGN_RIGHT);
          o->value(u_cfg->cvanal_beginTime);
        }
        { Fl_Value_Input* o = new Fl_Value_Input(25, 190, 60, 25, "Duration in seconds (<= 0: until end of input file)");
          o->box(FL_THIN_DOWN_BOX);
          o->minimum(-1);
          o->maximum(10000);
          o->callback((Fl_Callback*)cb_Duration);
          o->align(FL_ALIGN_RIGHT);
          o->value(u_cfg->cvanal_duration);
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "PVOC");
        o->tooltip("Sound file analysis for PVOC");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Input* o = pvanalInputFileInput = new Fl_Input(20, 45, 305, 25, "Input file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_pvanalInputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->pvanal_inputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 45, 25, 25, "...");
            o->tooltip("Browse input file for PVOC analysis");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_2);
          }
          { Fl_Input* o = pvanalOutputFileInput = new Fl_Input(20, 80, 305, 25, "Output file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_pvanalOutputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->pvanal_outputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 80, 25, 25, "...");
            o->tooltip("Browse output file for PVOC analysis");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_3);
          }
          { Fl_Spinner* o = new Fl_Spinner(20, 115, 60, 25, "Channel number (0: all)");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Channel1);
            o->align(FL_ALIGN_RIGHT);
            o->range(0.0, 8.0);
            o->step(1.0);
            o->value((double) u_cfg->pvanal_channel);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 150, 60, 25, "Begin time in seconds");
            o->box(FL_THIN_DOWN_BOX);
            o->maximum(10000);
            o->callback((Fl_Callback*)cb_Begin1);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->pvanal_beginTime);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 185, 60, 25, "Duration in seconds (<= 0: until end of input file)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(10000);
            o->callback((Fl_Callback*)cb_Duration1);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->pvanal_duration);
          }
          { Fl_Choice* o = new Fl_Choice(20, 220, 115, 25, "Frame size");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Frame);
            o->align(FL_ALIGN_RIGHT);
            o->add("256|512|1024|2048|4096|8192");
            o->value((int) (std::log((double) u_cfg->pvanal_frameSize) / std::log(2.0) + 0.5) - 8);
          }
          { Fl_Choice* o = new Fl_Choice(235, 220, 115, 25, "Overlaps");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Overlaps);
            o->align(FL_ALIGN_RIGHT);
            o->add("Use hop size|2|4|8|16");
            o->value(u_cfg->pvanal_overlap > 1 ? (int) (std::log((double) u_cfg->pvanal_frameSize) / std::log(2.0) + 0.5) : 0);
          }
          { Fl_Choice* o = new Fl_Choice(20, 255, 115, 25, "Window type");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Window);
            o->align(FL_ALIGN_RIGHT);
            o->add("Hamming|von Hann|Kaiser");
            o->value(u_cfg->pvanal_windowType);
          }
          { Fl_Choice* o = pvanalHopSizeInput = new Fl_Choice(235, 255, 115, 25, "Hop size");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_pvanalHopSizeInput);
            o->align(FL_ALIGN_RIGHT);
            o->add("16|32|64|128|256|512|1024|2048|4096");
            if (u_cfg->pvanal_overlap < 2) o->value((int) (std::log((double) u_cfg->pvanal_hopSize) / std::log(2.0) + 0.5) - 4);
            if (u_cfg->pvanal_overlap >= 2) { o->deactivate(); o->value((int) (std::log((double) (u_cfg->pvanal_frameSize / u_cfg->pvanal_overlap)) / std::log(2.0) + 0.5) - 4); }
          }
          o->end();
        }
        { Fl_Button* o = pvanalButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_pvanalButton);
          if (!(p->utilityState & CSOUND5GUI_PVANAL_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_PVANAL_RUNNING) o->label("Stop");
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "Adsyn");
        o->tooltip("Sound file analysis for adsyn");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Input* o = hetroInputFileInput = new Fl_Input(20, 45, 305, 25, "Input file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_hetroInputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_inputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 45, 25, 25, "...");
            o->tooltip("Browse input file for hetrodyne analysis");
            o->callback((Fl_Callback*)cb_4);
          }
          { Fl_Input* o = hetroOutputFileInput = new Fl_Input(20, 80, 305, 25, "Output file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_hetroOutputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_outputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 80, 25, 25, "...");
            o->tooltip("Browse output file for hetrodyne analysis");
            o->callback((Fl_Callback*)cb_5);
          }
          { Fl_Spinner* o = new Fl_Spinner(20, 115, 60, 25, "Channel number");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Channel2);
            o->align(FL_ALIGN_RIGHT);
            o->range(1.0, 8.0);
            o->step(1.0);
            o->value((double) u_cfg->hetro_channel);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 150, 60, 25, "Begin time in seconds");
            o->box(FL_THIN_DOWN_BOX);
            o->maximum(10000);
            o->callback((Fl_Callback*)cb_Begin2);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_beginTime);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 185, 60, 25, "Duration in seconds (<= 0: until end of input file)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(10000);
            o->callback((Fl_Callback*)cb_Duration2);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_duration);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 220, 60, 25, "Starting frequency");
            o->tooltip("Estimated starting frequency of the fundamental");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(10);
            o->maximum(1000);
            o->callback((Fl_Callback*)cb_Starting);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_startFreq);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(235, 220, 60, 25, "Number of partials");
            o->tooltip("Number of harmonic partials sought in the audio file");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(1);
            o->maximum(1000);
            o->step(1);
            o->callback((Fl_Callback*)cb_Number);
            o->align(FL_ALIGN_RIGHT);
            o->value((double) u_cfg->hetro_partials);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 255, 60, 25, "Breakpoints");
            o->tooltip("Initial number of analysis breakpoints in each amplitude and frequency track");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(10);
            o->maximum(10000);
            o->step(1);
            o->callback((Fl_Callback*)cb_Breakpoints);
            o->align(FL_ALIGN_RIGHT);
            o->value((double) u_cfg->hetro_breakPoints);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(235, 255, 60, 25, "Amplitude threshold");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(1e+06);
            o->callback((Fl_Callback*)cb_Amplitude);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_minAmp);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 290, 60, 25, "Cutoff frequency");
            o->tooltip("If > 0, use a 3rd order Butterworth low-pass filter with this cutoff frequenc\
y (in Hz)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(20000);
            o->callback((Fl_Callback*)cb_Cutoff);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_cutoffFreq);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(235, 290, 60, 25, "Maximum amplitude");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(1e+06);
            o->callback((Fl_Callback*)cb_Maximum);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->hetro_maxAmp);
          }
          o->end();
        }
        { Fl_Button* o = hetroButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_hetroButton);
          if (!(p->utilityState & CSOUND5GUI_HETRO_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_HETRO_RUNNING) o->label("Stop");
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "LPC");
        o->tooltip("Linear predictive analysis");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Input* o = lpanalInputFileInput = new Fl_Input(20, 45, 310, 20, "Input file");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_lpanalInputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_inputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(410, 45, 20, 20, "...");
            o->tooltip("Browse input file for LPC analysis");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_6);
          }
          { Fl_Input* o = lpanalOutputFileInput = new Fl_Input(20, 75, 310, 20, "Output file");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_lpanalOutputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_outputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(410, 75, 20, 20, "...");
            o->tooltip("Browse output file for LPC analysis");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_7);
          }
          { Fl_Spinner* o = new Fl_Spinner(20, 105, 60, 20, "Channel number");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Channel3);
            o->align(FL_ALIGN_RIGHT);
            o->range(1.0, 8.0);
            o->step(1.0);
            o->value((double) u_cfg->lpanal_channel);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 135, 60, 20, "Begin time in seconds");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->maximum(10000);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Begin3);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_beginTime);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 165, 60, 20, "Duration in seconds (<= 0: until end of input file)");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(-1);
            o->maximum(10000);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Duration3);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_duration);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 195, 60, 20, "Number of poles");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(5);
            o->maximum(50);
            o->step(1);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Number1);
            o->align(FL_ALIGN_RIGHT);
            o->value((double) u_cfg->lpanal_poles);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(235, 195, 60, 20, "Hop size");
            o->tooltip("Hop size (in samples) between frames of analysis");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(25);
            o->maximum(500);
            o->step(1);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Hop);
            o->align(FL_ALIGN_RIGHT);
            o->value((double) u_cfg->lpanal_hopSize);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 225, 60, 20, "Minimum frequency");
            o->tooltip("Lowest frequency (in Hz) of pitch tracking. 0 means no pitch tracking");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->maximum(500);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Minimum);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_minFreq);
          }
          { Fl_Choice* o = new Fl_Choice(235, 225, 75, 20, "Verbosity");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Verbosity);
            o->align(FL_ALIGN_RIGHT);
            o->add("Normal|Verbose|Debug");
            o->value(u_cfg->lpanal_verbosity);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 255, 60, 20, "Maximum frequency");
            o->tooltip("Highest frequency (in Hz) of pitch tracking. The narrower the pitch range, th\
e more accurate the pitch estimate");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(10);
            o->maximum(1500);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Maximum1);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_maxFreq);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(235, 255, 20, 20, "Alternate storage");
            o->tooltip("Write a file with filter poles values rather than the usual filter coefficien\
t files");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(12);
            o->callback((Fl_Callback*)cb_Alternate);
            o->value(u_cfg->lpanal_altMode ? 1 : 0);
          }
          { Fl_Input* o = new Fl_Input(20, 285, 340, 20, "Comment");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Comment);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->lpanal_comment.c_str());
          }
          o->end();
        }
        { Fl_Button* o = lpanalButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_lpanalButton);
          if (!(p->utilityState & CSOUND5GUI_LPANAL_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_LPANAL_RUNNING) o->label("Stop");
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "Srconv");
        o->tooltip("Sample rate conversion");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Input* o = srconvInputFileInput = new Fl_Input(20, 45, 305, 25, "Input file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_srconvInputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->srconv_inputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 45, 25, 25, "...");
            o->tooltip("Browse input file for sample rate conversion");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_8);
          }
          { Fl_Input* o = srconvOutputFileInput = new Fl_Input(20, 80, 305, 25, "Output file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_srconvOutputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->srconv_outputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 80, 25, 25, "...");
            o->tooltip("Browse output file for sample rate conversion");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_9);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 115, 60, 25, "Pitch transposition ratio");
            o->tooltip("Ratio of the original and new sample rate, a lower value means higher output \
sample rate (if <= 0, use output sample rate as set below instead)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(100);
            o->callback((Fl_Callback*)cb_Pitch);
            o->align(FL_ALIGN_RIGHT);
            o->when(FL_WHEN_RELEASE);
            o->value(u_cfg->srconv_pitchRatio);
          }
          { Fl_Value_Input* o = srconvSampleRateInput = new Fl_Value_Input(20, 150, 60, 25, "Output sample rate (Hz)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(1e+06);
            o->callback((Fl_Callback*)cb_srconvSampleRateInput);
            o->align(FL_ALIGN_RIGHT);
            o->when(FL_WHEN_RELEASE);
            if (u_cfg->srconv_pitchRatio <= 0.0) o->value(u_cfg->srconv_sampleRate);
            if (u_cfg->srconv_pitchRatio > 0.0) { o->deactivate(); o->value(-1.0); }
          }
          { Fl_Spinner* o = new Fl_Spinner(20, 185, 60, 25, "Quality");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Quality);
            o->align(FL_ALIGN_RIGHT);
            o->range(1.0, 8.0);
            o->step(1.0);
            o->value((double) u_cfg->srconv_quality);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(235, 185, 25, 25, "Enable peak chunks");
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Enable);
            o->value(u_cfg->srconv_peakChunks ? 1 : 0);
          }
          { Fl_Choice* o = new Fl_Choice(20, 220, 80, 25, "File type");
            o->tooltip("Type of output file");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_File);
            o->align(FL_ALIGN_RIGHT);
            o->add("RAW|WAV|AIFF|IRCAM");
            o->value(u_cfg->srconv_fileType);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(235, 220, 25, 25, "Rewrite header");
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Rewrite);
            o->value(u_cfg->srconv_rewriteHeader ? 1 : 0);
          }
          { Fl_Choice* o = new Fl_Choice(20, 255, 80, 25, "Sample format");
            o->tooltip("Sample format of output file");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Sample);
            o->align(FL_ALIGN_RIGHT);
            o->add("uchar|short|long|float");
            o->value(u_cfg->srconv_sampleFormat);
          }
          { Fl_Choice* o = new Fl_Choice(235, 255, 80, 25, "Heartbeat");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Heartbeat);
            o->align(FL_ALIGN_RIGHT);
            o->add("None|Bar|Dot|Time|Bell");
            o->value(u_cfg->srconv_heartBeat);
          }
          o->end();
        }
        { Fl_Button* o = srconvButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_srconvButton);
          if (!(p->utilityState & CSOUND5GUI_SRCONV_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_SRCONV_RUNNING) o->label("Stop");
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "Dnoise");
        o->tooltip("Noise reduction");
        o->color((Fl_Color)139);
        o->labelsize(12);
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Input* o = dnoiseInputFileInput = new Fl_Input(20, 45, 310, 20, "Input file");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_dnoiseInputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_inputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(410, 45, 20, 20, "...");
            o->tooltip("Browse input file for noise reduction");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_a);
          }
          { Fl_Input* o = dnoiseOutputFileInput = new Fl_Input(20, 75, 310, 20, "Output file");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_dnoiseOutputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_outputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(410, 75, 20, 20, "...");
            o->tooltip("Browse output file for noise reduction");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_b);
          }
          { Fl_Input* o = dnoiseNoiseFileInput = new Fl_Input(20, 105, 310, 20, "Noise file");
            o->tooltip("Noise reference sound file");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_dnoiseNoiseFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_noiseFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(410, 105, 20, 20, "...");
            o->tooltip("Browse noise reference file");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_c);
          }
          { Fl_Choice* o = new Fl_Choice(20, 135, 75, 20, "FFT size");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_FFT);
            o->align(FL_ALIGN_RIGHT);
            o->add("64|128|256|512|1024|2048|4096|8192");
            o->value(u_cfg->dnoise_fftSize);
          }
          { Fl_Choice* o = new Fl_Choice(235, 135, 75, 20, "Synthesis w. length");
            o->tooltip("Synthesis window length");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Synthesis);
            o->align(FL_ALIGN_RIGHT);
            o->add("Default|64|128|256|512|1024|2048|4096|8192|16384|32768");
            o->value(u_cfg->dnoise_synLen);
          }
          { Fl_Choice* o = new Fl_Choice(20, 165, 75, 20, "Analysis window size");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Analysis);
            o->align(FL_ALIGN_RIGHT);
            o->add("4 * FFT size|2 * FFT size|1 * FFT size|0.5 * FFT size");
            o->value(u_cfg->dnoise_overlap);
          }
          { Fl_Choice* o = new Fl_Choice(235, 165, 75, 20, "Decimation factor");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Decimation);
            o->align(FL_ALIGN_RIGHT);
            o->add("Default|8|16|32|64|128|256|512|1024|2048|4096");
            o->value(u_cfg->dnoise_decFact);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 195, 60, 20, "Begin time");
            o->tooltip("Begin time in noise reference file");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->maximum(100000);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Begin4);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_beginTime);
          }
          { Fl_Spinner* o = new Fl_Spinner(235, 195, 60, 20, "FFT frames to average");
            o->tooltip("Number of FFT frames to average over");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_FFT1);
            o->align(FL_ALIGN_RIGHT);
            o->range(1.0, 20.0);
            o->step(1.0);
            o->value((double) u_cfg->dnoise_numFFT);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 225, 60, 20, "End time");
            o->tooltip("End time in noise reference file (if <= 0, read until the end of the file)");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(-1);
            o->maximum(100000);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_End);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_endTime);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(235, 225, 60, 20, "Threshold (dB)");
            o->tooltip("Threshold above noise reference in dB");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(-12);
            o->maximum(90);
            o->step(0.1);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Threshold);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_threshold);
          }
          { Fl_Spinner* o = new Fl_Spinner(20, 255, 60, 20, "Noise gate sharpness");
            o->tooltip("Sharpness of noise-gate turnoff");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Noise);
            o->align(FL_ALIGN_RIGHT);
            o->range(1.0, 5.0);
            o->step(1.0);
            o->value((double) u_cfg->dnoise_sharpness);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(235, 255, 60, 20, "Minimum gain (dB)");
            o->tooltip("Minimum gain of noise-gate when off in dB");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->minimum(-96);
            o->maximum(-6);
            o->step(0.1);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Minimum1);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->dnoise_minGain);
          }
          { Fl_Choice* o = new Fl_Choice(20, 285, 75, 20, "File type");
            o->tooltip("Type of output file");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_File1);
            o->align(FL_ALIGN_RIGHT);
            o->add("RAW|WAV|AIFF|IRCAM");
            o->value(u_cfg->dnoise_fileType);
          }
          { Fl_Choice* o = new Fl_Choice(235, 285, 75, 20, "Heartbeat");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Heartbeat1);
            o->align(FL_ALIGN_RIGHT);
            o->add("None|Bar|Dot|Time|Bell");
            o->value(u_cfg->dnoise_heartBeat);
          }
          { Fl_Choice* o = new Fl_Choice(20, 315, 75, 20, "Sample format");
            o->tooltip("Sample format of output file");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Sample1);
            o->align(FL_ALIGN_RIGHT);
            o->add("uchar|short|long|float");
            o->value(u_cfg->dnoise_sampleFormat);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(210, 315, 20, 20, "Rewrite header");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(12);
            o->callback((Fl_Callback*)cb_Rewrite1);
            o->value(u_cfg->dnoise_rewriteHeader ? 1 : 0);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(345, 315, 20, 20, "Verbose");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(12);
            o->callback((Fl_Callback*)cb_Verbose);
            o->value(u_cfg->dnoise_verbose ? 1 : 0);
          }
          o->end();
        }
        { Fl_Button* o = dnoiseButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_dnoiseButton);
          if (!(p->utilityState & CSOUND5GUI_DNOISE_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_DNOISE_RUNNING) o->label("Stop");
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "Sndinfo");
        o->tooltip("Print information about a sound file");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Input* o = sndinfoInputFileInput = new Fl_Input(20, 45, 305, 25, "Input file");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_sndinfoInputFileInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(u_cfg->sndinfo_inputFile.c_str());
          }
          { Fl_Button* o = new Fl_Button(405, 45, 25, 25, "...");
            o->tooltip("Browse sound file");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_d);
          }
          o->end();
        }
        { Fl_Button* o = sndinfoButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_sndinfoButton);
          if (!(p->utilityState & CSOUND5GUI_SNDINFO_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_SNDINFO_RUNNING) o->label("Stop");
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 450, 365, "List opcodes");
        o->tooltip("List opcodes in this version of Csound");
        o->color((Fl_Color)139);
        o->labelsize(12);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 35, 430, 310);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Check_Button* o = new Fl_Check_Button(20, 45, 25, 25, "Print detailed opcode information");
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Print);
            o->value(u_cfg->listOpcodes_printDetails ? 1 : 0);
          }
          o->end();
        }
        { Fl_Button* o = listOpcodesButton = new Fl_Button(365, 355, 75, 25, "Start");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_listOpcodesButton);
          if (!(p->utilityState & CSOUND5GUI_LISTOPCODES_RUNNING)) o->label("Start");
          if (p->utilityState & CSOUND5GUI_LISTOPCODES_RUNNING) o->label("Stop");
        }
        o->end();
      }
      o->end();
    }
    o->end();
  }
}

CsoundUtilitiesWindow::~CsoundUtilitiesWindow() {
  {
  if (window) {
    delete window;
    window = (Fl_Double_Window*) 0;
  }
}
}
