/* This file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <libgnomecanvas/gnome-canvas.h>

#include <ccc/utils.h>

#ifndef CANVAS_H
#define CANVAS_H

G_BEGIN_DECLS

typedef struct _CriaCanvas CriaCanvas;
typedef struct _CriaCanvasClass CriaCanvasClass;

typedef struct _CriaItem CriaItem;
typedef struct _CriaItemClass CriaItemClass;

GnomeCanvasItem*  cria_canvas_get_focused      (CriaCanvas	* self);
guint64		  cria_canvas_get_padding      (CriaCanvas	* self);
GType		  cria_canvas_get_type	       (void);
gdouble		  cria_canvas_get_zoom	       (CriaCanvas	* self);
CriaCanvas*	  cria_canvas_new	       (void);
void		  cria_canvas_set_padding      (CriaCanvas	* self,
						guint64		  padding);
void		  cria_canvas_set_extents      (CriaCanvas	* self,
						const CcRectangle*extents);
void		  cria_canvas_set_zoom	       (CriaCanvas	* self,
						gdouble		  zoom);

#define CRIA_TYPE_CANVAS		(cria_canvas_get_type ())
#define CRIA_CANVAS(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_CANVAS, CriaCanvas))
#define CRIA_CANVAS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), CRIA_TYPE_CANVAS, CriaCanvasClass))
#define CRIA_IS_CANVAS(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_CANVAS))
#define CRIA_IS_CANVAS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_CANVAS))
#define CRIA_CANVAS_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_CANVAS, CriaCanvasClass))

GType		cria_item_get_type	 (void);
void		cria_item_grab_focus     (CriaItem	  * self);
gboolean        cria_item_is_interactive (CriaItem	  * self);
void		cria_item_set_interactive(CriaItem	  * self,
					  gboolean	    interactive);

#define CRIA_TYPE_ITEM			(cria_item_get_type())
#define CRIA_ITEM(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_ITEM, CriaItem))
#define CRIA_ITEM_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), CRIA_TYPE_ITEM, CriaItemClass))
#define CRIA_IS_ITEM(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_ITEM))
#define CRIA_IS_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_ITEM))
#define CRIA_ITEM_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_ITEM, CriaItemClass))

typedef enum {
	CRIA_CAN_FOCUS   = 1 << 0,
	CRIA_INTERACTIVE = 1 << 1,
} CriaItemFlags;

G_END_DECLS

#endif /* !CANVAS_H */

