/* 
 * tileset.c
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "tileset.h"

guint16 solid_tiles[LAST_SOLID_TILE][16];
guint16 mixed_tiles[LAST_MIXED_TILE][256];

static void load_summer_tileset(void)
{ /* FIXME: should use ccl (SIOD) */
  gint i, j;

  for (i=0 ; i<13 ; i++)
    for (j=0 ; j<16 ; j++)
      solid_tiles[i][j] = 0;
  for (i=0 ; i<10 ; i++)
    for (j=0 ; j<256 ; j++)
      mixed_tiles[i][j] = 0;

  solid_tiles[LIGHT_WATER][0] = 328;
  solid_tiles[LIGHT_WATER][1] = 329;
  solid_tiles[LIGHT_WATER][2] = 329;
  solid_tiles[LIGHT_WATER][3] = 330;

  solid_tiles[DARK_WATER][0] = 331;
  solid_tiles[DARK_WATER][1] = 332;
  solid_tiles[DARK_WATER][2] = 332;
  solid_tiles[DARK_WATER][3] = 333;

  solid_tiles[LIGHT_COAST][0]  = 334;
  solid_tiles[LIGHT_COAST][1]  = 335;
  solid_tiles[LIGHT_COAST][2]  = 336;
  solid_tiles[LIGHT_COAST][3]  = 0;
  solid_tiles[LIGHT_COAST][4]  = 337;
  solid_tiles[LIGHT_COAST][5]  = 338;
  solid_tiles[LIGHT_COAST][6]  = 339;
  solid_tiles[LIGHT_COAST][7]  = 340;
  solid_tiles[LIGHT_COAST][8]  = 341;
  solid_tiles[LIGHT_COAST][9]  = 342;
  solid_tiles[LIGHT_COAST][10] = 343;
  solid_tiles[LIGHT_COAST][11] = 344;

  solid_tiles[DARK_COAST][0]  = 345;
  solid_tiles[DARK_COAST][1]  = 346;
  solid_tiles[DARK_COAST][2]  = 347;
  solid_tiles[DARK_COAST][3]  = 0;
  solid_tiles[DARK_COAST][4]  = 348;
  solid_tiles[DARK_COAST][5]  = 349;
  solid_tiles[DARK_COAST][6]  = 350;
  solid_tiles[DARK_COAST][7]  = 351;
  solid_tiles[DARK_COAST][8]  = 352;
  solid_tiles[DARK_COAST][9]  = 353;
  solid_tiles[DARK_COAST][10] = 354;
  solid_tiles[DARK_COAST][11] = 355;

  solid_tiles[LIGHT_GRASS][0]  = 356;
  solid_tiles[LIGHT_GRASS][1]  = 357;
  solid_tiles[LIGHT_GRASS][2]  = 356;
  solid_tiles[LIGHT_GRASS][3]  = 0;
  solid_tiles[LIGHT_GRASS][4]  = 358;
  solid_tiles[LIGHT_GRASS][5]  = 359;
  solid_tiles[LIGHT_GRASS][6]  = 360;
  solid_tiles[LIGHT_GRASS][7]  = 361;
  solid_tiles[LIGHT_GRASS][8]  = 362;
  solid_tiles[LIGHT_GRASS][9]  = 363;
  solid_tiles[LIGHT_GRASS][10] = 358;
  solid_tiles[LIGHT_GRASS][11] = 359;
  solid_tiles[LIGHT_GRASS][12] = 358;
  solid_tiles[LIGHT_GRASS][13] = 359;
  solid_tiles[LIGHT_GRASS][14] = 358;
  solid_tiles[LIGHT_GRASS][15] = 359;

  solid_tiles[DARK_GRASS][0]  = 364;
  solid_tiles[DARK_GRASS][1]  = 365;
  solid_tiles[DARK_GRASS][2]  = 364;
  solid_tiles[DARK_GRASS][3]  = 0;
  solid_tiles[DARK_GRASS][4]  = 366;
  solid_tiles[DARK_GRASS][5]  = 367;
  solid_tiles[DARK_GRASS][6]  = 368;
  solid_tiles[DARK_GRASS][7]  = 369;
  solid_tiles[DARK_GRASS][8]  = 370;
  solid_tiles[DARK_GRASS][9]  = 371;
  solid_tiles[DARK_GRASS][10] = 366;
  solid_tiles[DARK_GRASS][11] = 367;
  solid_tiles[DARK_GRASS][12] = 366;
  solid_tiles[DARK_GRASS][13] = 367;
  solid_tiles[DARK_GRASS][14] = 366;
  solid_tiles[DARK_GRASS][15] = 367;

  solid_tiles[FOREST][0] = 125;
  solid_tiles[FOREST][1] = 127;
  solid_tiles[FOREST][2] = 128;

  solid_tiles[ROCKS][0] = 165;
  solid_tiles[ROCKS][1] = 177;
  solid_tiles[ROCKS][2] = 178;
  solid_tiles[ROCKS][3] = 179;

  solid_tiles[HUMAN_CLOSED_WALL][0] = 16;
  solid_tiles[HUMAN_CLOSED_WALL][1] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][2] = 52;
  solid_tiles[HUMAN_CLOSED_WALL][3] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][4] = 88;

  solid_tiles[ORC_CLOSED_WALL][0] = 34;
  solid_tiles[ORC_CLOSED_WALL][1] = 0;
  solid_tiles[ORC_CLOSED_WALL][2] = 70;
  solid_tiles[ORC_CLOSED_WALL][3] = 0;
  solid_tiles[ORC_CLOSED_WALL][4] = 88;

  solid_tiles[HUMAN_OPEN_WALL][0] = 33;
  solid_tiles[HUMAN_OPEN_WALL][1] = 0;
  solid_tiles[HUMAN_OPEN_WALL][2] = 69;
  solid_tiles[HUMAN_OPEN_WALL][3] = 0;
  solid_tiles[HUMAN_OPEN_WALL][4] = 101;

  solid_tiles[ORC_OPEN_WALL][0] = 51;
  solid_tiles[ORC_OPEN_WALL][1] = 0;
  solid_tiles[ORC_OPEN_WALL][2] = 87;
  solid_tiles[ORC_OPEN_WALL][3] = 0;
  solid_tiles[ORC_OPEN_WALL][4] = 101;

  solid_tiles[BRIDGE][0] = 384+17;
  solid_tiles[BRIDGE][1] = 384+22;
  solid_tiles[BRIDGE][1] = 384+26;
  solid_tiles[ROAD][0] = 416+8;
  solid_tiles[FORD][0] = 432+10;

  mixed_tiles[DARK_WATER_LIGHT_WATER][0x00] = 300;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x01] = 301;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x10] = 302;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x11] = 303;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x20] = 304;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x21] = 305;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x22] = 306;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x30] = 307;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x31] = 308;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x40] = 309;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x41] = 310;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x42] = 311;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x50] = 312;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x51] = 313;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x60] = 314;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x61] = 314;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x70] = 315;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x71] = 316;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x80] = 317;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x81] = 318;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x90] = 319;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x91] = 320;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x92] = 321;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA0] = 322;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA1] = 322;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB0] = 323;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB1] = 324;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB2] = 325;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC0] = 326;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC1] = 326;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD0] = 327;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD1] = 327;

  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x00] = 206;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x01] = 207;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x10] = 208;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x11] = 209;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x20] = 210;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x21] = 211;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x22] = 212;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x30] = 213;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x31] = 214;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x40] = 215;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x41] = 216;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x42] = 217;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x50] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x51] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x60] = 219;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x61] = 220;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x70] = 221;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x71] = 222;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x80] = 223;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x81] = 223;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x90] = 224;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x91] = 225;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x92] = 226;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA0] = 227;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA1] = 228;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB0] = 229;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB1] = 230;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB2] = 231;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC0] = 232;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC1] = 233;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD0] = 234;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD1] = 235;

  mixed_tiles[DARK_COAST_LIGHT_COAST][0x00] = 180;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x01] = 180;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x10] = 181;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x11] = 182;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x20] = 183;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x21] = 184;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x22] = 185;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x30] = 186;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x31] = 186;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x32] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x33] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x34] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x35] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x36] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x37] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x38] = 0;  /* 187; */
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x40] = 188;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x41] = 189;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x42] = 190;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x50] = 191;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x51] = 192;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x60] = 193;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x61] = 193;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x70] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x71] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x80] = 195;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x81] = 196;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x90] = 197;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x91] = 198;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x92] = 199;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA0] = 200;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA1] = 200;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB0] = 201;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB1] = 202;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB2] = 203;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC0] = 204;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC1] = 204;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD0] = 205;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD1] = 205;
  
  mixed_tiles[ROCKS_LIGHT_COAST][0x00] = 150;
  mixed_tiles[ROCKS_LIGHT_COAST][0x01] = 173;
  mixed_tiles[ROCKS_LIGHT_COAST][0x10] = 142;
  mixed_tiles[ROCKS_LIGHT_COAST][0x11] = 167;
  mixed_tiles[ROCKS_LIGHT_COAST][0x20] = 164;
  mixed_tiles[ROCKS_LIGHT_COAST][0x21] = 176;
  mixed_tiles[ROCKS_LIGHT_COAST][0x30] = 147;
  mixed_tiles[ROCKS_LIGHT_COAST][0x31] = 171;
  mixed_tiles[ROCKS_LIGHT_COAST][0x40] = 149;
  mixed_tiles[ROCKS_LIGHT_COAST][0x41] = 172;
  mixed_tiles[ROCKS_LIGHT_COAST][0x42] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x43] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x44] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x45] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x46] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x47] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x48] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x49] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x4A] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x4B] = 0;  /* 187; */
  mixed_tiles[ROCKS_LIGHT_COAST][0x50] = 154;
  mixed_tiles[ROCKS_LIGHT_COAST][0x51] = 175;
  mixed_tiles[ROCKS_LIGHT_COAST][0x60] = 151;
  mixed_tiles[ROCKS_LIGHT_COAST][0x70] = 144;
  mixed_tiles[ROCKS_LIGHT_COAST][0x71] = 169;
  mixed_tiles[ROCKS_LIGHT_COAST][0x80] = 153;
  mixed_tiles[ROCKS_LIGHT_COAST][0x81] = 174;
  mixed_tiles[ROCKS_LIGHT_COAST][0x90] = 143;
  mixed_tiles[ROCKS_LIGHT_COAST][0x91] = 168;
  mixed_tiles[ROCKS_LIGHT_COAST][0xA0] = 152;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB0] = 146;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB1] = 170;
  mixed_tiles[ROCKS_LIGHT_COAST][0xC0] = 148;
  mixed_tiles[ROCKS_LIGHT_COAST][0xD0] = 145;
  
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x00] = 270;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x01] = 271;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x10] = 272;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x11] = 273;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x20] = 274;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x21] = 275;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x22] = 276;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x30] = 277;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x31] = 278;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x40] = 279;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x41] = 280;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x42] = 281;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x50] = 282;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x51] = 283;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x60] = 284;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x61] = 284;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x70] = 285;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x71] = 286;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x80] = 287;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x81] = 288;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x90] = 289;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x91] = 290;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x92] = 291;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA0] = 292;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA1] = 292;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB0] = 293;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB1] = 294;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB2] = 295;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC0] = 296;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC1] = 297;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD0] = 298;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD1] = 299;
  
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x00] = 238;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x01] = 239;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x10] = 240;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x11] = 241;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x20] = 242;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x21] = 243;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x22] = 244;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x30] = 245;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x31] = 246;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x40] = 247;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x41] = 248;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x42] = 249;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x50] = 250;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x51] = 251;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x60] = 252;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x61] = 253;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x70] = 254;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x71] = 255;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x80] = 256;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x81] = 257;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x90] = 258;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x91] = 259;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x92] = 260;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA0] = 261;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA1] = 262;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB0] = 263;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB1] = 264;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB2] = 265;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC0] = 266;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC1] = 267;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD0] = 268;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD1] = 269;
  
  mixed_tiles[FOREST_LIGHT_GRASS][0x00] = 129;
  mixed_tiles[FOREST_LIGHT_GRASS][0x01] = 110;
  mixed_tiles[FOREST_LIGHT_GRASS][0x10] = 102;
  mixed_tiles[FOREST_LIGHT_GRASS][0x11] = 130;
  mixed_tiles[FOREST_LIGHT_GRASS][0x20] = 124;
  mixed_tiles[FOREST_LIGHT_GRASS][0x21] = 131;
  mixed_tiles[FOREST_LIGHT_GRASS][0x30] = 107;
  mixed_tiles[FOREST_LIGHT_GRASS][0x31] = 132;
  mixed_tiles[FOREST_LIGHT_GRASS][0x40] = 133;
  mixed_tiles[FOREST_LIGHT_GRASS][0x41] = 109;
  mixed_tiles[FOREST_LIGHT_GRASS][0x50] = 139;
  mixed_tiles[FOREST_LIGHT_GRASS][0x51] = 138;
  mixed_tiles[FOREST_LIGHT_GRASS][0x60] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x61] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x70] = 104;
  mixed_tiles[FOREST_LIGHT_GRASS][0x71] = 136;
  mixed_tiles[FOREST_LIGHT_GRASS][0x80] = 140;
  mixed_tiles[FOREST_LIGHT_GRASS][0x81] = 141;
  mixed_tiles[FOREST_LIGHT_GRASS][0x90] = 103;
  mixed_tiles[FOREST_LIGHT_GRASS][0x91] = 135;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA0] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA1] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB0] = 106;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB1] = 134;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC0] = 137;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC1] = 137;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD0] = 105;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD1] = 105;

  mixed_tiles[HUMAN_WALL_DARK_GRASS][0X00] = 17;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x02] = 53;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x10] = 18;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x12] = 54;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x20] = 19;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x22] = 55;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x30] = 20;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x32] = 56;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x40] = 21;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x41] = 22;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x43] = 57;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x44] = 58;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x46] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x47] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x50] = 23;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x52] = 59;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x54] = 94;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x60] = 24;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x62] = 60;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x64] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x70] = 25;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x72] = 61;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x74] = 96;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x80] = 26;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x82] = 62;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x84] = 97;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x90] = 27;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x91] = 28;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x93] = 63;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x94] = 64;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x96] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x97] = 99;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA0] = 29;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA2] = 65;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA4] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB0] = 30;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB2] = 66;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB4] = 100;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC0] = 31;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC2] = 67;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC4] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD0] = 32;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD2] = 68;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD4] = 99;

  mixed_tiles[ORC_WALL_DARK_GRASS][0x00] = 35;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x02] = 71;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x10] = 36;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x12] = 72;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x20] = 37;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x22] = 73;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x30] = 38;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x32] = 74;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x40] = 39;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x41] = 40;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x43] = 75;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x44] = 76;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x46] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x47] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x50] = 41;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x52] = 77;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x54] = 94;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x60] = 42;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x62] = 78;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x64] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x70] = 43;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x72] = 79;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x74] = 96;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x80] = 44;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x82] = 80;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x84] = 97;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x90] = 45;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x91] = 46;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x93] = 81;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x94] = 82;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x96] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x97] = 99;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA0] = 47;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA2] = 83;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA4] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB0] = 48;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB2] = 84;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB4] = 100;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC0] = 49;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC2] = 85;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC4] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD0] = 50;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD2] = 86;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD4] = 99;

  mixed_tiles[BRIDGE_LIGHT_COAST][0x00] = 384+0;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x10] = 384+2;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x20] = 384+14;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x30] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x40] = 384+18;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x50] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x60] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x70] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x80] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0x90] = 384+16;
  mixed_tiles[BRIDGE_LIGHT_COAST][0xA0] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0xB0] = 384+6;
  mixed_tiles[BRIDGE_LIGHT_COAST][0xC0] = 384;
  mixed_tiles[BRIDGE_LIGHT_COAST][0xD0] = 384;

  mixed_tiles[ROAD_LIGHT_GRASS][0x00] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x10] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x20] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x30] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x40] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x50] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x60] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x70] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x80] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0x90] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0xA0] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0xB0] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0xC0] = 416;
  mixed_tiles[ROAD_LIGHT_GRASS][0xD0] = 416;

  mixed_tiles[FORD_LIGHT_COAST][0x00] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x10] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x20] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x30] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x40] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x50] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x60] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x70] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x80] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0x90] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0xA0] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0xB0] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0xC0] = 432;
  mixed_tiles[FORD_LIGHT_COAST][0xD0] = 432;
}

static void load_winter_tileset(void)
{ /* FIXME: should use ccl (SIOD) */
  gint i, j;

  for (i=0 ; i<13 ; i++)
    for (j=0 ; j<16 ; j++)
      solid_tiles[i][j] = 0;
  for (i=0 ; i<10 ; i++)
    for (j=0 ; j<256 ; j++)
      mixed_tiles[i][j] = 0;

  solid_tiles[LIGHT_WATER][0] = 319;
  solid_tiles[LIGHT_WATER][1] = 320;
  solid_tiles[LIGHT_WATER][2] = 320;
  solid_tiles[LIGHT_WATER][3] = 321;
  solid_tiles[LIGHT_WATER][4] = 0;
  solid_tiles[LIGHT_WATER][5] = 322;
  solid_tiles[LIGHT_WATER][6] = 323;
  solid_tiles[LIGHT_WATER][7] = 324;

  solid_tiles[DARK_WATER][0] = 325;
  solid_tiles[DARK_WATER][1] = 326;
  solid_tiles[DARK_WATER][2] = 326;
  solid_tiles[DARK_WATER][3] = 327;
  solid_tiles[DARK_WATER][4] = 0;
  solid_tiles[DARK_WATER][5] = 328;
  solid_tiles[DARK_WATER][6] = 329;
  solid_tiles[DARK_WATER][7] = 330;

  solid_tiles[LIGHT_COAST][0]  = 331;
  solid_tiles[LIGHT_COAST][1]  = 332;
  solid_tiles[LIGHT_COAST][2]  = 333;
  solid_tiles[LIGHT_COAST][3]  = 0;
  solid_tiles[LIGHT_COAST][4]  = 334;
  solid_tiles[LIGHT_COAST][5]  = 335;
  solid_tiles[LIGHT_COAST][6]  = 336;
  solid_tiles[LIGHT_COAST][7]  = 337;
  solid_tiles[LIGHT_COAST][8]  = 338;
  solid_tiles[LIGHT_COAST][9]  = 339;
  solid_tiles[LIGHT_COAST][10] = 334;
  solid_tiles[LIGHT_COAST][11] = 338;

  solid_tiles[DARK_COAST][0]  = 340;
  solid_tiles[DARK_COAST][1]  = 341;
  solid_tiles[DARK_COAST][2]  = 342;
  solid_tiles[DARK_COAST][3]  = 0;
  solid_tiles[DARK_COAST][4]  = 343;
  solid_tiles[DARK_COAST][5]  = 344;
  solid_tiles[DARK_COAST][6]  = 345;
  solid_tiles[DARK_COAST][7]  = 346;
  solid_tiles[DARK_COAST][8]  = 347;
  solid_tiles[DARK_COAST][9]  = 348;
  solid_tiles[DARK_COAST][10] = 343;
  solid_tiles[DARK_COAST][11] = 347;

  solid_tiles[LIGHT_GRASS][0]  = 349;
  solid_tiles[LIGHT_GRASS][1]  = 350;
  solid_tiles[LIGHT_GRASS][2]  = 351;
  solid_tiles[LIGHT_GRASS][3]  = 0;
  solid_tiles[LIGHT_GRASS][4]  = 352;
  solid_tiles[LIGHT_GRASS][5]  = 353;
  solid_tiles[LIGHT_GRASS][6]  = 354;
  solid_tiles[LIGHT_GRASS][7]  = 355;
  solid_tiles[LIGHT_GRASS][8]  = 356;
  solid_tiles[LIGHT_GRASS][9]  = 357;
  solid_tiles[LIGHT_GRASS][10] = 358;
  solid_tiles[LIGHT_GRASS][11] = 359;
  solid_tiles[LIGHT_GRASS][12] = 360;
  solid_tiles[LIGHT_GRASS][13] = 361;
  solid_tiles[LIGHT_GRASS][14] = 362;
  solid_tiles[LIGHT_GRASS][15] = 363;

  solid_tiles[DARK_GRASS][0]  = 364;
  solid_tiles[DARK_GRASS][1]  = 365;
  solid_tiles[DARK_GRASS][2]  = 366;
  solid_tiles[DARK_GRASS][3]  = 0;
  solid_tiles[DARK_GRASS][4]  = 367;
  solid_tiles[DARK_GRASS][5]  = 368;
  solid_tiles[DARK_GRASS][6]  = 369;
  solid_tiles[DARK_GRASS][7]  = 370;
  solid_tiles[DARK_GRASS][8]  = 371;
  solid_tiles[DARK_GRASS][9]  = 372;
  solid_tiles[DARK_GRASS][10] = 373;
  solid_tiles[DARK_GRASS][11] = 374;
  solid_tiles[DARK_GRASS][12] = 375;
  solid_tiles[DARK_GRASS][13] = 376;
  solid_tiles[DARK_GRASS][14] = 377;
  solid_tiles[DARK_GRASS][15] = 378;

  solid_tiles[FOREST][0] = 125;
  solid_tiles[FOREST][1] = 135;
  solid_tiles[FOREST][2] = 136;

  solid_tiles[ROCKS][0] = 160;
  solid_tiles[ROCKS][1] = 172;
  solid_tiles[ROCKS][2] = 173;
  solid_tiles[ROCKS][3] = 174;

  solid_tiles[HUMAN_CLOSED_WALL][0] = 16;
  solid_tiles[HUMAN_CLOSED_WALL][1] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][2] = 52;
  solid_tiles[HUMAN_CLOSED_WALL][3] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][4] = 88;

  solid_tiles[ORC_CLOSED_WALL][0] = 34;
  solid_tiles[ORC_CLOSED_WALL][1] = 0;
  solid_tiles[ORC_CLOSED_WALL][2] = 70;
  solid_tiles[ORC_CLOSED_WALL][3] = 0;
  solid_tiles[ORC_CLOSED_WALL][4] = 88;

  solid_tiles[HUMAN_OPEN_WALL][0] = 33;
  solid_tiles[HUMAN_OPEN_WALL][1] = 0;
  solid_tiles[HUMAN_OPEN_WALL][2] = 69;
  solid_tiles[HUMAN_OPEN_WALL][3] = 0;
  solid_tiles[HUMAN_OPEN_WALL][4] = 101;

  solid_tiles[ORC_OPEN_WALL][0] = 51;
  solid_tiles[ORC_OPEN_WALL][1] = 0;
  solid_tiles[ORC_OPEN_WALL][2] = 87;
  solid_tiles[ORC_OPEN_WALL][3] = 0;
  solid_tiles[ORC_OPEN_WALL][4] = 101;

  mixed_tiles[DARK_WATER_LIGHT_WATER][0x00] = 291;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x01] = 292;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x10] = 293;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x11] = 294;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x20] = 295;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x21] = 296;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x22] = 297;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x30] = 298;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x31] = 299;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x40] = 300;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x41] = 301;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x42] = 302;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x50] = 303;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x51] = 304;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x60] = 305;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x61] = 305;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x70] = 306;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x71] = 307;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x80] = 308;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x81] = 309;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x90] = 310;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x91] = 311;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x92] = 312;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA0] = 313;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA1] = 313;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB0] = 314;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB1] = 315;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB2] = 316;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC0] = 317;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC1] = 317;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD0] = 318;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD1] = 318;

  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x00] = 199;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x01] = 200;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x10] = 201;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x11] = 202;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x20] = 203;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x21] = 204;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x22] = 205;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x30] = 206;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x31] = 207;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x40] = 208;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x41] = 209;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x42] = 210;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x50] = 211;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x51] = 211;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x60] = 212;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x61] = 213;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x70] = 214;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x71] = 215;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x80] = 216;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x81] = 216;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x90] = 217;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x91] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x92] = 219;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA0] = 220;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA1] = 221;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB0] = 222;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB1] = 223;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB2] = 224;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC0] = 225;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC1] = 226;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD0] = 227;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD1] = 228;

  mixed_tiles[DARK_COAST_LIGHT_COAST][0x00] = 175;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x01] = 176;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x10] = 177;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x11] = 178;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x20] = 179;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x21] = 180;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x22] = 179;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x30] = 181;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x31] = 182;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x40] = 183;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x41] = 184;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x42] = 183;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x50] = 185;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x51] = 186;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x60] = 187;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x61] = 187;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x70] = 188;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x71] = 189;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x80] = 190;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x81] = 191;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x90] = 192;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x91] = 193;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x92] = 192;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA0] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA1] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB0] = 195;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB1] = 196;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB2] = 195;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC0] = 197;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC1] = 197;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD0] = 198;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD1] = 198;

  mixed_tiles[ROCKS_LIGHT_COAST][0x00] = 145;
  mixed_tiles[ROCKS_LIGHT_COAST][0x01] = 168;
  mixed_tiles[ROCKS_LIGHT_COAST][0x10] = 137;
  mixed_tiles[ROCKS_LIGHT_COAST][0x11] = 162;
  mixed_tiles[ROCKS_LIGHT_COAST][0x20] = 159;
  mixed_tiles[ROCKS_LIGHT_COAST][0x21] = 171;
  mixed_tiles[ROCKS_LIGHT_COAST][0x30] = 142;
  mixed_tiles[ROCKS_LIGHT_COAST][0x31] = 166;
  mixed_tiles[ROCKS_LIGHT_COAST][0x40] = 144;
  mixed_tiles[ROCKS_LIGHT_COAST][0x41] = 167;
  mixed_tiles[ROCKS_LIGHT_COAST][0x50] = 149;
  mixed_tiles[ROCKS_LIGHT_COAST][0x51] = 170;
  mixed_tiles[ROCKS_LIGHT_COAST][0x60] = 146;
  mixed_tiles[ROCKS_LIGHT_COAST][0x70] = 139;
  mixed_tiles[ROCKS_LIGHT_COAST][0x71] = 164;
  mixed_tiles[ROCKS_LIGHT_COAST][0x80] = 148;
  mixed_tiles[ROCKS_LIGHT_COAST][0x81] = 169;
  mixed_tiles[ROCKS_LIGHT_COAST][0x90] = 138;
  mixed_tiles[ROCKS_LIGHT_COAST][0x91] = 163;
  mixed_tiles[ROCKS_LIGHT_COAST][0xA0] = 147;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB0] = 141;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB1] = 165;
  mixed_tiles[ROCKS_LIGHT_COAST][0xC0] = 143;
  mixed_tiles[ROCKS_LIGHT_COAST][0xD0] = 140;
  
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x00] = 259;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x01] = 260;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x10] = 261;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x11] = 262;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x20] = 263;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x21] = 264;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x22] = 265;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x30] = 266;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x31] = 267;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x40] = 268;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x41] = 269;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x42] = 270;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x50] = 271;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x51] = 272;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x60] = 273;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x61] = 274;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x70] = 275;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x71] = 276;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x80] = 277;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x81] = 278;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x90] = 279;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x91] = 280;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x92] = 281;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA0] = 282;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA1] = 283;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB0] = 284;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB1] = 285;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB2] = 286;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC0] = 287;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC1] = 288;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD0] = 289;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD1] = 290;

  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x00] = 231;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x01] = 232;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x10] = 233;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x11] = 234;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x20] = 235;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x21] = 236;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x22] = 237;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x30] = 238;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x31] = 239;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x40] = 240;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x41] = 241;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x42] = 242;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x50] = 243;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x51] = 244;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x60] = 245;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x61] = 245;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x70] = 246;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x71] = 247;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x80] = 248;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x81] = 249;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x90] = 250;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x91] = 251;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x92] = 252;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA0] = 253;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA1] = 253;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB0] = 254;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB1] = 255;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB2] = 256;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC0] = 257;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC1] = 257;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD0] = 258;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD1] = 258;

  mixed_tiles[FOREST_LIGHT_GRASS][0x00] = 110;
  mixed_tiles[FOREST_LIGHT_GRASS][0x01] = 133;
  mixed_tiles[FOREST_LIGHT_GRASS][0x10] = 102;
  mixed_tiles[FOREST_LIGHT_GRASS][0x11] = 127;
  mixed_tiles[FOREST_LIGHT_GRASS][0x20] = 124;
  mixed_tiles[FOREST_LIGHT_GRASS][0x21] = 134;
  mixed_tiles[FOREST_LIGHT_GRASS][0x30] = 107;
  mixed_tiles[FOREST_LIGHT_GRASS][0x31] = 131;
  mixed_tiles[FOREST_LIGHT_GRASS][0x40] = 109;
  mixed_tiles[FOREST_LIGHT_GRASS][0x41] = 132;
  mixed_tiles[FOREST_LIGHT_GRASS][0x50] = 114;
  mixed_tiles[FOREST_LIGHT_GRASS][0x51] = 114;
  mixed_tiles[FOREST_LIGHT_GRASS][0x60] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x61] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x70] = 104;
  mixed_tiles[FOREST_LIGHT_GRASS][0x71] = 129;
  mixed_tiles[FOREST_LIGHT_GRASS][0x80] = 113;
  mixed_tiles[FOREST_LIGHT_GRASS][0x81] = 113;
  mixed_tiles[FOREST_LIGHT_GRASS][0x90] = 103;
  mixed_tiles[FOREST_LIGHT_GRASS][0x91] = 128;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA0] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA1] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB0] = 106;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB1] = 130;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC0] = 108;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC1] = 108;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD0] = 105;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD1] = 105;

  mixed_tiles[HUMAN_WALL_DARK_GRASS][0X00] = 17;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x02] = 53;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x10] = 18;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x12] = 54;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x20] = 19;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x22] = 55;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x30] = 20;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x32] = 56;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x40] = 21;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x41] = 22;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x43] = 57;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x44] = 58;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x46] = 94;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x47] = 99;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x50] = 23;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x52] = 59;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x54] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x60] = 24;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x62] = 60;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x64] = 94;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x70] = 25;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x72] = 61;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x74] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x80] = 26;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x82] = 62;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x84] = 96;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x90] = 27;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x91] = 28;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x93] = 63;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x94] = 64;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x96] = 97;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x97] = 100;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA0] = 29;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA2] = 65;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA4] = 97;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB0] = 30;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB2] = 66;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB4] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC0] = 31;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC2] = 67;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC4] = 99;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD0] = 32;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD2] = 68;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD4] = 100;

  mixed_tiles[ORC_WALL_DARK_GRASS][0x00] = 35;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x02] = 71;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x10] = 36;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x12] = 72;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x20] = 37;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x22] = 73;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x30] = 38;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x32] = 74;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x40] = 39;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x41] = 40;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x43] = 75;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x44] = 76;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x46] = 94;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x47] = 99;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x50] = 41;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x52] = 77;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x54] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x60] = 42;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x62] = 78;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x64] = 94;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x70] = 43;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x72] = 79;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x74] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x80] = 44;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x82] = 80;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x84] = 96;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x90] = 45;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x91] = 46;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x93] = 81;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x94] = 82;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x96] = 97;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x97] = 100;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA0] = 47;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA2] = 83;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA4] = 97;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB0] = 48;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB2] = 84;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB4] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC0] = 49;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC2] = 85;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC4] = 99;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD0] = 50;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD2] = 86;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD4] = 100;
}

static void load_wasteland_tileset(void)
{ /* FIXME: should use ccl (SIOD) */
  gint i, j;

  for (i=0 ; i<13 ; i++)
    for (j=0 ; j<16 ; j++)
      solid_tiles[i][j] = 0;
  for (i=0 ; i<10 ; i++)
    for (j=0 ; j<256 ; j++)
      mixed_tiles[i][j] = 0;

  solid_tiles[LIGHT_WATER][0] = 324;
  solid_tiles[LIGHT_WATER][1] = 325;
  solid_tiles[LIGHT_WATER][2] = 325;
  solid_tiles[LIGHT_WATER][3] = 326;
  solid_tiles[LIGHT_WATER][4] = 0;
  solid_tiles[LIGHT_WATER][5] = 324;
  solid_tiles[LIGHT_WATER][6] = 325;
  solid_tiles[LIGHT_WATER][7] = 325;

  solid_tiles[DARK_WATER][0] = 327;
  solid_tiles[DARK_WATER][1] = 328;
  solid_tiles[DARK_WATER][2] = 328;
  solid_tiles[DARK_WATER][3] = 329;
  solid_tiles[DARK_WATER][4] = 0;
  solid_tiles[DARK_WATER][5] = 327;
  solid_tiles[DARK_WATER][6] = 328;
  solid_tiles[DARK_WATER][7] = 328;

  solid_tiles[LIGHT_COAST][0]  = 330;
  solid_tiles[LIGHT_COAST][1]  = 331;
  solid_tiles[LIGHT_COAST][2]  = 332;
  solid_tiles[LIGHT_COAST][3]  = 0;
  solid_tiles[LIGHT_COAST][4]  = 333;
  solid_tiles[LIGHT_COAST][5]  = 334;
  solid_tiles[LIGHT_COAST][6]  = 335;
  solid_tiles[LIGHT_COAST][7]  = 336;
  solid_tiles[LIGHT_COAST][8]  = 337;
  solid_tiles[LIGHT_COAST][9]  = 338;
  solid_tiles[LIGHT_COAST][10] = 334;
  solid_tiles[LIGHT_COAST][11] = 336;

  solid_tiles[DARK_COAST][0]  = 339;
  solid_tiles[DARK_COAST][1]  = 340;
  solid_tiles[DARK_COAST][2]  = 341;
  solid_tiles[DARK_COAST][3]  = 0;
  solid_tiles[DARK_COAST][4]  = 342;
  solid_tiles[DARK_COAST][5]  = 343;
  solid_tiles[DARK_COAST][6]  = 344;
  solid_tiles[DARK_COAST][7]  = 345;
  solid_tiles[DARK_COAST][8]  = 342;
  solid_tiles[DARK_COAST][9]  = 343;
  solid_tiles[DARK_COAST][10] = 340;
  solid_tiles[DARK_COAST][11] = 341;

  solid_tiles[LIGHT_GRASS][0]  = 346;
  solid_tiles[LIGHT_GRASS][1]  = 347;
  solid_tiles[LIGHT_GRASS][2]  = 348;
  solid_tiles[LIGHT_GRASS][3]  = 0;
  solid_tiles[LIGHT_GRASS][4]  = 349;
  solid_tiles[LIGHT_GRASS][5]  = 350;
  solid_tiles[LIGHT_GRASS][6]  = 351;
  solid_tiles[LIGHT_GRASS][7]  = 352;
  solid_tiles[LIGHT_GRASS][8]  = 353;
  solid_tiles[LIGHT_GRASS][9]  = 354;
  solid_tiles[LIGHT_GRASS][10] = 355;
  solid_tiles[LIGHT_GRASS][11] = 356;
  solid_tiles[LIGHT_GRASS][12] = 357;
  solid_tiles[LIGHT_GRASS][13] = 358;
  solid_tiles[LIGHT_GRASS][14] = 359;
  solid_tiles[LIGHT_GRASS][15] = 350;

  solid_tiles[DARK_GRASS][0]  = 261;
  solid_tiles[DARK_GRASS][1]  = 262;
  solid_tiles[DARK_GRASS][2]  = 263;
  solid_tiles[DARK_GRASS][3]  = 0;
  solid_tiles[DARK_GRASS][4]  = 361;
  solid_tiles[DARK_GRASS][5]  = 362;
  solid_tiles[DARK_GRASS][6]  = 363;
  solid_tiles[DARK_GRASS][7]  = 364;
  solid_tiles[DARK_GRASS][8]  = 365;
  solid_tiles[DARK_GRASS][9]  = 366;
  solid_tiles[DARK_GRASS][10] = 367;
  solid_tiles[DARK_GRASS][11] = 368;
  solid_tiles[DARK_GRASS][12] = 369;
  solid_tiles[DARK_GRASS][13] = 370;
  solid_tiles[DARK_GRASS][14] = 371;
  solid_tiles[DARK_GRASS][15] = 372;

  solid_tiles[FOREST][0] = 125;
  solid_tiles[FOREST][1] = 137;
  solid_tiles[FOREST][2] = 138;

  solid_tiles[ROCKS][0] = 162;
  solid_tiles[ROCKS][1] = 174;
  solid_tiles[ROCKS][2] = 175;
  solid_tiles[ROCKS][3] = 176;

  solid_tiles[HUMAN_CLOSED_WALL][0] = 16;
  solid_tiles[HUMAN_CLOSED_WALL][1] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][2] = 52;
  solid_tiles[HUMAN_CLOSED_WALL][3] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][4] = 88;

  solid_tiles[ORC_CLOSED_WALL][0] = 34;
  solid_tiles[ORC_CLOSED_WALL][1] = 0;
  solid_tiles[ORC_CLOSED_WALL][2] = 70;
  solid_tiles[ORC_CLOSED_WALL][3] = 0;
  solid_tiles[ORC_CLOSED_WALL][4] = 88;

  solid_tiles[HUMAN_OPEN_WALL][0] = 33;
  solid_tiles[HUMAN_OPEN_WALL][1] = 0;
  solid_tiles[HUMAN_OPEN_WALL][2] = 69;
  solid_tiles[HUMAN_OPEN_WALL][3] = 0;
  solid_tiles[HUMAN_OPEN_WALL][4] = 101;

  solid_tiles[ORC_OPEN_WALL][0] = 51;
  solid_tiles[ORC_OPEN_WALL][1] = 0;
  solid_tiles[ORC_OPEN_WALL][2] = 87;
  solid_tiles[ORC_OPEN_WALL][3] = 0;
  solid_tiles[ORC_OPEN_WALL][4] = 101;

  mixed_tiles[DARK_WATER_LIGHT_WATER][0x00] = 296;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x01] = 296;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x10] = 297;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x11] = 297;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x20] = 298;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x21] = 299;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x22] = 300;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x30] = 301;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x31] = 301;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x40] = 302;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x41] = 303;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x42] = 304;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x50] = 305;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x51] = 306;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x60] = 307;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x61] = 308;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x70] = 309;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x71] = 309;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x80] = 310;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x81] = 311;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x90] = 312;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x91] = 313;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x92] = 314;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA0] = 315;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA1] = 316;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB0] = 317;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB1] = 318;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB2] = 319;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC0] = 320;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC1] = 321;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD0] = 322;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD1] = 323;

  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x00] = 201;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x01] = 202;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x10] = 203;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x11] = 204;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x20] = 205;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x21] = 206;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x22] = 207;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x30] = 208;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x31] = 209;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x40] = 210;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x41] = 211;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x42] = 212;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x50] = 213;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x51] = 213;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x60] = 214;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x61] = 215;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x70] = 216;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x71] = 217;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x80] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x81] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x90] = 219;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x91] = 220;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x92] = 221;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA0] = 222;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA1] = 223;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB0] = 224;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB1] = 225;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB2] = 226;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC0] = 227;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC1] = 228;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD0] = 229;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD1] = 230;

  mixed_tiles[DARK_COAST_LIGHT_COAST][0x00] = 177;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x01] = 177;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x10] = 178;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x11] = 178;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x20] = 179;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x21] = 180;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x22] = 181;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x30] = 182;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x31] = 182;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x40] = 183;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x41] = 184;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x42] = 185;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x50] = 186;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x51] = 187;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x60] = 188;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x61] = 188;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x70] = 189;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x71] = 189;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x80] = 190;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x81] = 191;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x90] = 192;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x91] = 193;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x92] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA0] = 195;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA1] = 195;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB0] = 196;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB1] = 197;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB2] = 198;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC0] = 199;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC1] = 199;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD0] = 200;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD1] = 200;

  mixed_tiles[ROCKS_LIGHT_COAST][0x00] = 147;
  mixed_tiles[ROCKS_LIGHT_COAST][0x01] = 170;
  mixed_tiles[ROCKS_LIGHT_COAST][0x10] = 139;
  mixed_tiles[ROCKS_LIGHT_COAST][0x11] = 164;
  mixed_tiles[ROCKS_LIGHT_COAST][0x20] = 161;
  mixed_tiles[ROCKS_LIGHT_COAST][0x21] = 173;
  mixed_tiles[ROCKS_LIGHT_COAST][0x30] = 144;
  mixed_tiles[ROCKS_LIGHT_COAST][0x31] = 168;
  mixed_tiles[ROCKS_LIGHT_COAST][0x40] = 146;
  mixed_tiles[ROCKS_LIGHT_COAST][0x41] = 169;
  mixed_tiles[ROCKS_LIGHT_COAST][0x50] = 151;
  mixed_tiles[ROCKS_LIGHT_COAST][0x51] = 172;
  mixed_tiles[ROCKS_LIGHT_COAST][0x60] = 148;
  mixed_tiles[ROCKS_LIGHT_COAST][0x70] = 141;
  mixed_tiles[ROCKS_LIGHT_COAST][0x71] = 166;
  mixed_tiles[ROCKS_LIGHT_COAST][0x80] = 150;
  mixed_tiles[ROCKS_LIGHT_COAST][0x81] = 171;
  mixed_tiles[ROCKS_LIGHT_COAST][0x90] = 140;
  mixed_tiles[ROCKS_LIGHT_COAST][0x91] = 165;
  mixed_tiles[ROCKS_LIGHT_COAST][0xA0] = 149;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB0] = 143;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB1] = 167;
  mixed_tiles[ROCKS_LIGHT_COAST][0xC0] = 145;
  mixed_tiles[ROCKS_LIGHT_COAST][0xD0] = 142;

  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x00] = 264;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x01] = 265;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x10] = 266;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x11] = 267;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x20] = 268;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x21] = 269;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x22] = 270;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x30] = 271;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x31] = 272;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x40] = 273;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x41] = 274;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x42] = 275;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x50] = 276;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x51] = 277;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x60] = 278;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x61] = 279;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x70] = 280;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x71] = 281;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x80] = 282;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x81] = 283;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x90] = 284;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x91] = 285;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x92] = 286;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA0] = 287;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA1] = 288;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB0] = 289;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB1] = 290;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB2] = 291;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC0] = 292;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC1] = 293;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD0] = 294;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD1] = 295;

  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x00] = 233;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x01] = 234;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x10] = 235;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x11] = 236;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x20] = 237;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x21] = 238;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x22] = 239;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x30] = 240;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x31] = 241;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x40] = 242;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x41] = 243;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x42] = 244;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x50] = 245;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x51] = 246;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x60] = 247;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x61] = 247;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x70] = 248;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x71] = 249;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x80] = 250;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x81] = 251;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x90] = 252;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x91] = 253;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x92] = 254;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA0] = 255;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA1] = 255;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB0] = 256;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB1] = 257;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB2] = 258;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC0] = 259;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC1] = 259;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD0] = 260;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD1] = 260;

  mixed_tiles[FOREST_LIGHT_GRASS][0x00] = 110;
  mixed_tiles[FOREST_LIGHT_GRASS][0x01] = 134;
  mixed_tiles[FOREST_LIGHT_GRASS][0x10] = 102;
  mixed_tiles[FOREST_LIGHT_GRASS][0x11] = 127;
  mixed_tiles[FOREST_LIGHT_GRASS][0x20] = 124;
  mixed_tiles[FOREST_LIGHT_GRASS][0x21] = 136;
  mixed_tiles[FOREST_LIGHT_GRASS][0x30] = 107;
  mixed_tiles[FOREST_LIGHT_GRASS][0x31] = 131;
  mixed_tiles[FOREST_LIGHT_GRASS][0x40] = 109;
  mixed_tiles[FOREST_LIGHT_GRASS][0x41] = 133;
  mixed_tiles[FOREST_LIGHT_GRASS][0x50] = 114;
  mixed_tiles[FOREST_LIGHT_GRASS][0x51] = 114;
  mixed_tiles[FOREST_LIGHT_GRASS][0x60] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x61] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x70] = 104;
  mixed_tiles[FOREST_LIGHT_GRASS][0x71] = 129;
  mixed_tiles[FOREST_LIGHT_GRASS][0x80] = 113;
  mixed_tiles[FOREST_LIGHT_GRASS][0x81] = 113;
  mixed_tiles[FOREST_LIGHT_GRASS][0x90] = 103;
  mixed_tiles[FOREST_LIGHT_GRASS][0x91] = 128;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA0] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA1] = 135;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB0] = 106;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB1] = 130;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC0] = 108;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC1] = 132;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD0] = 105;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD1] = 105;

  mixed_tiles[HUMAN_WALL_DARK_GRASS][0X00] = 17;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x02] = 53;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x10] = 18;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x12] = 54;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x20] = 19;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x22] = 55;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x30] = 20;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x32] = 56;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x40] = 21;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x41] = 22;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x43] = 57;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x44] = 58;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x46] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x47] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x50] = 23;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x52] = 59;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x54] = 94;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x60] = 24;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x62] = 60;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x64] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x70] = 25;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x72] = 61;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x74] = 96;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x80] = 26;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x82] = 62;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x84] = 97;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x90] = 27;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x91] = 28;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x93] = 63;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x94] = 64;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x96] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x97] = 99;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA0] = 29;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA2] = 65;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA4] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB0] = 30;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB2] = 66;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB4] = 100;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC0] = 31;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC2] = 67;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC4] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD0] = 32;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD2] = 68;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD4] = 99;

  mixed_tiles[ORC_WALL_DARK_GRASS][0x00] = 35;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x02] = 71;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x10] = 36;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x12] = 72;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x20] = 37;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x22] = 73;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x30] = 38;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x32] = 74;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x40] = 39;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x41] = 40;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x43] = 75;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x44] = 76;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x46] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x47] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x50] = 41;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x52] = 77;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x54] = 94;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x60] = 42;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x62] = 78;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x64] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x70] = 43;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x72] = 79;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x74] = 96;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x80] = 44;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x82] = 80;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x84] = 97;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x90] = 45;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x91] = 46;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x93] = 81;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x94] = 82;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x96] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x97] = 99;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA0] = 47;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA2] = 83;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA4] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB0] = 48;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB2] = 84;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB4] = 100;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC0] = 49;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC2] = 85;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC4] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD0] = 50;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD2] = 86;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD4] = 99;
}

static void load_swamp_tileset(void)
{ /* FIXME: should use ccl (SIOD) */
  /* FIXME: can someone send me this? This certainly is all wrong */
  gint i, j;

  for (i=0 ; i<13 ; i++)
    for (j=0 ; j<16 ; j++)
      solid_tiles[i][j] = 0;
  for (i=0 ; i<10 ; i++)
    for (j=0 ; j<256 ; j++)
      mixed_tiles[i][j] = 0;

  solid_tiles[LIGHT_WATER][0] = 328;
  solid_tiles[LIGHT_WATER][1] = 329;
  solid_tiles[LIGHT_WATER][2] = 329;
  solid_tiles[LIGHT_WATER][3] = 330;

  solid_tiles[DARK_WATER][0] = 331;
  solid_tiles[DARK_WATER][1] = 332;
  solid_tiles[DARK_WATER][2] = 332;
  solid_tiles[DARK_WATER][3] = 333;

  solid_tiles[LIGHT_COAST][0]  = 334;
  solid_tiles[LIGHT_COAST][1]  = 335;
  solid_tiles[LIGHT_COAST][2]  = 336;
  solid_tiles[LIGHT_COAST][3]  = 0;
  solid_tiles[LIGHT_COAST][4]  = 337;
  solid_tiles[LIGHT_COAST][5]  = 338;
  solid_tiles[LIGHT_COAST][6]  = 339;
  solid_tiles[LIGHT_COAST][7]  = 340;
  solid_tiles[LIGHT_COAST][8]  = 341;
  solid_tiles[LIGHT_COAST][9]  = 342;
  solid_tiles[LIGHT_COAST][10] = 343;
  solid_tiles[LIGHT_COAST][11] = 344;

  solid_tiles[DARK_COAST][0]  = 345;
  solid_tiles[DARK_COAST][1]  = 346;
  solid_tiles[DARK_COAST][2]  = 347;
  solid_tiles[DARK_COAST][3]  = 0;
  solid_tiles[DARK_COAST][4]  = 348;
  solid_tiles[DARK_COAST][5]  = 349;
  solid_tiles[DARK_COAST][6]  = 350;
  solid_tiles[DARK_COAST][7]  = 351;
  solid_tiles[DARK_COAST][8]  = 352;
  solid_tiles[DARK_COAST][9]  = 353;
  solid_tiles[DARK_COAST][10] = 354;
  solid_tiles[DARK_COAST][11] = 355;

  solid_tiles[LIGHT_GRASS][0]  = 356;
  solid_tiles[LIGHT_GRASS][1]  = 357;
  solid_tiles[LIGHT_GRASS][2]  = 356;
  solid_tiles[LIGHT_GRASS][3]  = 0;
  solid_tiles[LIGHT_GRASS][4]  = 358;
  solid_tiles[LIGHT_GRASS][5]  = 359;
  solid_tiles[LIGHT_GRASS][6]  = 360;
  solid_tiles[LIGHT_GRASS][7]  = 361;
  solid_tiles[LIGHT_GRASS][8]  = 362;
  solid_tiles[LIGHT_GRASS][9]  = 363;
  solid_tiles[LIGHT_GRASS][10] = 358;
  solid_tiles[LIGHT_GRASS][11] = 359;
  solid_tiles[LIGHT_GRASS][12] = 358;
  solid_tiles[LIGHT_GRASS][13] = 359;
  solid_tiles[LIGHT_GRASS][14] = 358;
  solid_tiles[LIGHT_GRASS][15] = 359;

  solid_tiles[DARK_GRASS][0]  = 364;
  solid_tiles[DARK_GRASS][1]  = 365;
  solid_tiles[DARK_GRASS][2]  = 364;
  solid_tiles[DARK_GRASS][3]  = 0;
  solid_tiles[DARK_GRASS][4]  = 366;
  solid_tiles[DARK_GRASS][5]  = 367;
  solid_tiles[DARK_GRASS][6]  = 368;
  solid_tiles[DARK_GRASS][7]  = 369;
  solid_tiles[DARK_GRASS][8]  = 370;
  solid_tiles[DARK_GRASS][9]  = 371;
  solid_tiles[DARK_GRASS][10] = 366;
  solid_tiles[DARK_GRASS][11] = 367;
  solid_tiles[DARK_GRASS][12] = 366;
  solid_tiles[DARK_GRASS][13] = 367;
  solid_tiles[DARK_GRASS][14] = 366;
  solid_tiles[DARK_GRASS][15] = 367;

  solid_tiles[FOREST][0] = 125;
  solid_tiles[FOREST][1] = 127;
  solid_tiles[FOREST][2] = 128;

  solid_tiles[ROCKS][0] = 165;
  solid_tiles[ROCKS][1] = 177;
  solid_tiles[ROCKS][2] = 178;
  solid_tiles[ROCKS][3] = 179;

  solid_tiles[HUMAN_CLOSED_WALL][0] = 16;
  solid_tiles[HUMAN_CLOSED_WALL][1] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][2] = 52;
  solid_tiles[HUMAN_CLOSED_WALL][3] = 0;
  solid_tiles[HUMAN_CLOSED_WALL][4] = 88;

  solid_tiles[ORC_CLOSED_WALL][0] = 34;
  solid_tiles[ORC_CLOSED_WALL][1] = 0;
  solid_tiles[ORC_CLOSED_WALL][2] = 70;
  solid_tiles[ORC_CLOSED_WALL][3] = 0;
  solid_tiles[ORC_CLOSED_WALL][4] = 88;

  solid_tiles[HUMAN_OPEN_WALL][0] = 33;
  solid_tiles[HUMAN_OPEN_WALL][1] = 0;
  solid_tiles[HUMAN_OPEN_WALL][2] = 69;
  solid_tiles[HUMAN_OPEN_WALL][3] = 0;
  solid_tiles[HUMAN_OPEN_WALL][4] = 101;

  solid_tiles[ORC_OPEN_WALL][0] = 51;
  solid_tiles[ORC_OPEN_WALL][1] = 0;
  solid_tiles[ORC_OPEN_WALL][2] = 87;
  solid_tiles[ORC_OPEN_WALL][3] = 0;
  solid_tiles[ORC_OPEN_WALL][4] = 101;

  mixed_tiles[DARK_WATER_LIGHT_WATER][0x00] = 300;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x01] = 301;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x10] = 302;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x11] = 303;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x20] = 304;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x21] = 305;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x22] = 306;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x30] = 307;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x31] = 308;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x40] = 309;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x41] = 310;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x42] = 311;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x50] = 312;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x51] = 313;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x60] = 314;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x61] = 314;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x70] = 315;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x71] = 316;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x80] = 317;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x81] = 318;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x90] = 319;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x91] = 320;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0x92] = 321;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA0] = 322;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xA1] = 322;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB0] = 323;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB1] = 324;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xB2] = 325;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC0] = 326;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xC1] = 326;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD0] = 327;
  mixed_tiles[DARK_WATER_LIGHT_WATER][0xD1] = 327;

  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x00] = 206;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x01] = 207;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x10] = 208;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x11] = 209;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x20] = 210;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x21] = 211;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x22] = 212;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x30] = 213;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x31] = 214;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x40] = 215;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x41] = 216;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x42] = 217;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x50] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x51] = 218;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x60] = 219;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x61] = 220;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x70] = 221;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x71] = 222;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x80] = 223;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x81] = 223;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x90] = 224;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x91] = 225;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0x92] = 226;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA0] = 227;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xA1] = 228;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB0] = 229;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB1] = 230;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xB2] = 231;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC0] = 232;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xC1] = 233;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD0] = 234;
  mixed_tiles[LIGHT_WATER_LIGHT_COAST][0xD1] = 235;

  mixed_tiles[DARK_COAST_LIGHT_COAST][0x00] = 180;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x01] = 180;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x10] = 181;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x11] = 182;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x20] = 183;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x21] = 184;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x22] = 185;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x30] = 186;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x31] = 186;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x32] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x33] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x34] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x35] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x36] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x37] = 0;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x38] = 0;  /* 187; */
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x40] = 188;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x41] = 189;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x42] = 190;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x50] = 191;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x51] = 192;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x60] = 193;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x61] = 193;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x70] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x71] = 194;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x80] = 195;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x81] = 196;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x90] = 197;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x91] = 198;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0x92] = 199;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA0] = 200;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xA1] = 200;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB0] = 201;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB1] = 202;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xB2] = 203;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC0] = 204;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xC1] = 204;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD0] = 205;
  mixed_tiles[DARK_COAST_LIGHT_COAST][0xD1] = 205;
  
  mixed_tiles[ROCKS_LIGHT_COAST][0x00] = 150;
  mixed_tiles[ROCKS_LIGHT_COAST][0x01] = 173;
  mixed_tiles[ROCKS_LIGHT_COAST][0x10] = 142;
  mixed_tiles[ROCKS_LIGHT_COAST][0x11] = 167;
  mixed_tiles[ROCKS_LIGHT_COAST][0x20] = 164;
  mixed_tiles[ROCKS_LIGHT_COAST][0x21] = 176;
  mixed_tiles[ROCKS_LIGHT_COAST][0x30] = 147;
  mixed_tiles[ROCKS_LIGHT_COAST][0x31] = 171;
  mixed_tiles[ROCKS_LIGHT_COAST][0x40] = 149;
  mixed_tiles[ROCKS_LIGHT_COAST][0x41] = 172;
  mixed_tiles[ROCKS_LIGHT_COAST][0x42] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x43] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x44] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x45] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x46] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x47] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x48] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x49] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x4A] = 0;
  mixed_tiles[ROCKS_LIGHT_COAST][0x4B] = 0;  /* 187; */
  mixed_tiles[ROCKS_LIGHT_COAST][0x50] = 154;
  mixed_tiles[ROCKS_LIGHT_COAST][0x51] = 175;
  mixed_tiles[ROCKS_LIGHT_COAST][0x60] = 151;
  mixed_tiles[ROCKS_LIGHT_COAST][0x70] = 144;
  mixed_tiles[ROCKS_LIGHT_COAST][0x71] = 169;
  mixed_tiles[ROCKS_LIGHT_COAST][0x80] = 153;
  mixed_tiles[ROCKS_LIGHT_COAST][0x81] = 174;
  mixed_tiles[ROCKS_LIGHT_COAST][0x90] = 143;
  mixed_tiles[ROCKS_LIGHT_COAST][0x91] = 168;
  mixed_tiles[ROCKS_LIGHT_COAST][0xA0] = 152;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB0] = 146;
  mixed_tiles[ROCKS_LIGHT_COAST][0xB1] = 170;
  mixed_tiles[ROCKS_LIGHT_COAST][0xC0] = 148;
  mixed_tiles[ROCKS_LIGHT_COAST][0xD0] = 145;
  
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x00] = 270;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x01] = 271;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x10] = 272;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x11] = 273;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x20] = 274;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x21] = 275;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x22] = 276;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x30] = 277;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x31] = 278;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x40] = 279;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x41] = 280;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x42] = 281;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x50] = 282;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x51] = 283;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x60] = 284;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x61] = 284;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x70] = 285;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x71] = 286;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x80] = 287;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x81] = 288;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x90] = 289;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x91] = 290;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0x92] = 291;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA0] = 292;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xA1] = 292;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB0] = 293;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB1] = 294;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xB2] = 295;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC0] = 296;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xC1] = 297;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD0] = 298;
  mixed_tiles[LIGHT_COAST_LIGHT_GRASS][0xD1] = 299;
  
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x00] = 238;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x01] = 239;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x10] = 240;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x11] = 241;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x20] = 242;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x21] = 243;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x22] = 244;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x30] = 245;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x31] = 246;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x40] = 247;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x41] = 248;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x42] = 249;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x50] = 250;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x51] = 251;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x60] = 252;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x61] = 253;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x70] = 254;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x71] = 255;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x80] = 256;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x81] = 257;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x90] = 258;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x91] = 259;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0x92] = 260;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA0] = 261;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xA1] = 262;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB0] = 263;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB1] = 264;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xB2] = 265;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC0] = 266;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xC1] = 267;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD0] = 268;
  mixed_tiles[DARK_GRASS_LIGHT_GRASS][0xD1] = 269;
  
  mixed_tiles[FOREST_LIGHT_GRASS][0x00] = 129;
  mixed_tiles[FOREST_LIGHT_GRASS][0x01] = 110;
  mixed_tiles[FOREST_LIGHT_GRASS][0x10] = 102;
  mixed_tiles[FOREST_LIGHT_GRASS][0x11] = 130;
  mixed_tiles[FOREST_LIGHT_GRASS][0x20] = 124;
  mixed_tiles[FOREST_LIGHT_GRASS][0x21] = 131;
  mixed_tiles[FOREST_LIGHT_GRASS][0x30] = 107;
  mixed_tiles[FOREST_LIGHT_GRASS][0x31] = 132;
  mixed_tiles[FOREST_LIGHT_GRASS][0x40] = 133;
  mixed_tiles[FOREST_LIGHT_GRASS][0x41] = 109;
  mixed_tiles[FOREST_LIGHT_GRASS][0x50] = 139;
  mixed_tiles[FOREST_LIGHT_GRASS][0x51] = 138;
  mixed_tiles[FOREST_LIGHT_GRASS][0x60] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x61] = 111;
  mixed_tiles[FOREST_LIGHT_GRASS][0x70] = 104;
  mixed_tiles[FOREST_LIGHT_GRASS][0x71] = 136;
  mixed_tiles[FOREST_LIGHT_GRASS][0x80] = 140;
  mixed_tiles[FOREST_LIGHT_GRASS][0x81] = 141;
  mixed_tiles[FOREST_LIGHT_GRASS][0x90] = 103;
  mixed_tiles[FOREST_LIGHT_GRASS][0x91] = 135;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA0] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xA1] = 112;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB0] = 106;
  mixed_tiles[FOREST_LIGHT_GRASS][0xB1] = 134;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC0] = 137;
  mixed_tiles[FOREST_LIGHT_GRASS][0xC1] = 137;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD0] = 105;
  mixed_tiles[FOREST_LIGHT_GRASS][0xD1] = 105;

  mixed_tiles[HUMAN_WALL_DARK_GRASS][0X00] = 17;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x02] = 53;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x10] = 18;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x12] = 54;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x20] = 19;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x22] = 55;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x30] = 20;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x32] = 56;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x40] = 21;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x41] = 22;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x43] = 57;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x44] = 58;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x46] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x47] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x50] = 23;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x52] = 59;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x54] = 94;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x60] = 24;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x62] = 60;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x64] = 93;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x70] = 25;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x72] = 61;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x74] = 96;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x80] = 26;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x82] = 62;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x84] = 97;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x90] = 27;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x91] = 28;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x93] = 63;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x94] = 64;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x96] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0x97] = 99;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA0] = 29;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA2] = 65;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xA4] = 98;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB0] = 30;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB2] = 66;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xB4] = 100;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC0] = 31;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC2] = 67;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xC4] = 95;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD0] = 32;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD2] = 68;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[HUMAN_WALL_DARK_GRASS][0xD4] = 99;

  mixed_tiles[ORC_WALL_DARK_GRASS][0x00] = 35;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x01] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x02] = 71;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x03] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x04] = 89;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x10] = 36;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x11] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x12] = 72;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x13] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x14] = 90;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x20] = 37;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x21] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x22] = 73;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x23] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x24] = 91;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x30] = 38;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x31] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x32] = 74;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x33] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x34] = 92;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x40] = 39;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x41] = 40;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x42] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x43] = 75;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x44] = 76;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x45] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x46] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x47] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x50] = 41;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x51] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x52] = 77;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x53] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x54] = 94;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x60] = 42;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x61] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x62] = 78;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x63] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x64] = 93;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x70] = 43;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x71] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x72] = 79;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x73] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x74] = 96;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x80] = 44;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x81] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x82] = 80;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x83] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x84] = 97;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x90] = 45;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x91] = 46;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x92] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x93] = 81;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x94] = 82;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x95] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x96] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0x97] = 99;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA0] = 47;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA2] = 83;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xA4] = 98;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB0] = 48;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB2] = 84;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xB4] = 100;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC0] = 49;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC2] = 85;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xC4] = 95;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD0] = 50;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD1] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD2] = 86;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD3] = 0;
  mixed_tiles[ORC_WALL_DARK_GRASS][0xD4] = 99;
}

void load_tileset(gint terrain)
{
  switch (terrain)
  {
    case 0:
      load_summer_tileset();
      break;
    case 1:
      load_winter_tileset();
      break;
    case 2:
      load_wasteland_tileset();
      break;
    case 3:
      load_swamp_tileset();
      break;
  }
}

