/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdlib.h>
#include <string.h>

#ifndef __STRINGLIST_H
#define __STRINGLIST_H

/*
 * Doubly linked list
 */
struct string_list {
  struct string_node *first;
  struct string_node *last;
};
/*
 * Node
 */
struct string_node {
  char string[255];
  struct string_node *next;
  struct string_node *prev;
};

/*
 * Frees all the elements of the list.
 * Returns the number of freed elements.
 * 
 */
int string_list_free_sublist(struct string_list *list, struct string_node *start);

/*
 * Initializes a new string_list and 
 * returns a reference to it
 *
 */
struct string_list *string_list_new(void);

/*
 * Initializes a new string_node and 
 * returns a reference to it
 *
 */
struct string_node *string_node_new(void);

/*
 * Appends a node to the list
 * 
 */
void string_list_append(struct string_list *list, struct string_node *node);

#endif
