/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "libsys.h"

int libsys_init(void) {
  struct stat sb;
  int rc;
  
  rc = stat(APM_PROC_FILE, &sb);
  if (rc < 0) {
    cp_log(LOG_ERR, "libsys_init(): %s: %s\n", APM_PROC_FILE, strerror(errno));
    return -1;
  }
  return 0;
}

void libsys_fini (void) {}

/* int scan_system_info(sys_info *s) 
 *
 * Reads APM info and fills the input sys_info struct.
 * Implements the prototype needed by cpufreqd to get
 * info from the PM layer.
 *
 * Returns 0 on success, -1 otherwise
 *
 */
int scan_system_info(sys_info *s) {
  
  FILE *fp;
  char buf[101];
  
  /***** APM SCAN *****/
  char ignore3[101];
  int ignore;
  unsigned int ignore2;
    
  fp = fopen(APM_PROC_FILE , "r");
  if (!fp) {
    cp_log(LOG_ERR, "scan_system_info(): %s: %s\n", APM_PROC_FILE, strerror(errno));
    return(-1);
  }
    
  if (!fgets(buf, 100, fp)) {
    fclose(fp);
    cp_log(LOG_ERR, "scan_system_info(): %s: %s\n", APM_PROC_FILE, strerror(errno));
    return(-1);
  }
    
  sscanf(buf, "%s %d.%d %x %x %x %x %d%% %d %s\n",
                    s->version, &ignore, &ignore, &s->flags, &s->ac, &ignore2,
                    &ignore2, &s->battery_percent, &s->battery_time, ignore3);

  if (!strncmp(ignore3, "sec", 3)) {
    s->battery_time /= 60;
  }
    
  if (s->battery_percent > 100) {
    s->battery_percent = -1;
  }
    
  fclose(fp);
/*  s->cpu_percent = get_cpu(); */
  
  cp_log(LOG_INFO, "scan_system_info(): battery %s - %d - %s cpu %d\n",
                    s->has_battery?"present":"absent", 
                    s->battery_percent, 
                    s->ac?"on-line":"off-line",
		    s->cpu_percent );
  return 0;
}


