/* $Id: cpl_stats.h,v 1.13 2010/11/11 15:28:46 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2010/11/11 15:28:46 $
 * $Revision: 1.13 $
 * $Name: cpl-5_3_0-BRANCH $
 */

#ifndef CPL_STATS_H
#define CPL_STATS_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "cpl_image.h"

#include <stdio.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/
/* No mode has the value 1, which makes the (mis)use of logical or detectable */
#define CPL_STATS_MIN        ((unsigned) 1 <<  1)
#define CPL_STATS_MAX        ((unsigned) 1 <<  2)
#define CPL_STATS_MEAN       ((unsigned) 1 <<  3)
#define CPL_STATS_MEDIAN     ((unsigned) 1 <<  4)
#define CPL_STATS_STDEV      ((unsigned) 1 <<  5)
#define CPL_STATS_FLUX       ((unsigned) 1 <<  6)
#define CPL_STATS_ABSFLUX    ((unsigned) 1 <<  7)
#define CPL_STATS_SQFLUX     ((unsigned) 1 <<  8)
#define CPL_STATS_MINPOS     ((unsigned) 1 <<  9)
#define CPL_STATS_MAXPOS     ((unsigned) 1 << 10)
#define CPL_STATS_CENTROID   ((unsigned) 1 << 11)
#define CPL_STATS_MEDIAN_DEV ((unsigned) 1 << 12)
#define CPL_STATS_ALL        ((unsigned)(1 << 13)-2)

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _cpl_stats_ cpl_stats;

/*-----------------------------------------------------------------------------
                            Function prototypes
 -----------------------------------------------------------------------------*/

/* Accessor functions */
double cpl_stats_get_min(const cpl_stats *);
double cpl_stats_get_max(const cpl_stats *);
double cpl_stats_get_mean(const cpl_stats *);
double cpl_stats_get_median(const cpl_stats *);
double cpl_stats_get_median_dev(const cpl_stats *);
double cpl_stats_get_stdev(const cpl_stats *);
double cpl_stats_get_flux(const cpl_stats *);
double cpl_stats_get_absflux(const cpl_stats *);
double cpl_stats_get_sqflux(const cpl_stats *);
double cpl_stats_get_centroid_x(const cpl_stats *);
double cpl_stats_get_centroid_y(const cpl_stats *);
int cpl_stats_get_min_x(const cpl_stats *);
int cpl_stats_get_min_y(const cpl_stats *);
int cpl_stats_get_max_x(const cpl_stats *);
int cpl_stats_get_max_y(const cpl_stats *);
int cpl_stats_get_npix(const cpl_stats *);

void cpl_stats_delete(cpl_stats *);

/* Statistics computations */
cpl_stats * cpl_stats_new_from_image(const cpl_image *,
                                     unsigned) CPL_ATTR_ALLOC;
cpl_stats * cpl_stats_new_from_image_window(const cpl_image *, unsigned, int,
                                      int, int, int) CPL_ATTR_ALLOC;
cpl_error_code cpl_stats_dump(const cpl_stats *, unsigned, FILE *);

CPL_END_DECLS

#endif 
