/* $Id: kmo_priv_multi_reconstruct.h,v 1.13 2013-09-16 13:40:02 aagudo Exp $
 *
 * This file is part of the KMOS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-09-16 13:40:02 $
 * $Revision: 1.13 $
 * $Name: not supported by cvs2svn $
 */

#ifndef KMOS_PRIV_MULTI_RECONSTRUCT_H
#define KMOS_PRIV_MULTI_RECONSTRUCT_H

/*-----------------------------------------------------------------------------
 *                              Includes
 *----------------------------------------------------------------------------*/

#include <cpl.h>

#include "kmo_functions.h"

/*------------------------------------------------------------------------------
 *                        Prototypes
 *----------------------------------------------------------------------------*/

double          kmo_mr_get_rot_angle(
                            cpl_frame *frame);

cpl_imagelist** kmo_mr_create_datacubes(armNameStruct *arm_name_struct,
                            int arm_id,
                            cpl_frameset *frameset,
                            const gridDefinition gd,
                            int xcal_interpolation);

cpl_propertylist** kmo_mr_get_headers(armNameStruct *arm_name_struct,
                            int arm_id,
                            cpl_frameset *frameset,
                            const gridDefinition gd);

cpl_error_code  kmo_mr_get_offsets(
                            armNameStruct *arm_name_struct,
                            int arm_id,
                            const char *smethod,
                            const char *imethod,
                            const char *filename,
                            cpl_frameset *frameset,
                            cpl_imagelist **data_cube_list,
                            cpl_propertylist **sub_headers,
                            const char *fmethod,
                            const char *cmethod,
                            double cpos_rej,
                            double cneg_rej,
                            int citer,
                            int cmin,
                            int cmax,
                            int dev_cal,
                            char *mapping_mode,
                            double **xshifts,
                            double **yshifts);

cpl_error_code  kmo_mr_load_super_image(
                            int ix,
                            cpl_image *superImg,
                            cpl_image *tmpImg,
                            int *image_offsets,
                            int ifu_nr,
                            int *bounds);

cpl_image*      kmo_new_xcal_index(
                            int new_ifu_nr,
                            cpl_image* xcalImg);

#endif
