# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

""" Cordova Ubuntu Autopilot Test Base Class. """

import os
import os.path
import subprocess

from testtools.matchers import Contains, Equals

from autopilot.input import Mouse, Touch, Pointer
from autopilot.matchers import Eventually
from autopilot.platform import model
from autopilot.testcase import AutopilotTestCase

class CordovaUbuntuTestCase(AutopilotTestCase):
    """ Base class for Cordova Ubuntu Test Cases """
    LOCAL_CORDOVA_CONTAINER_PATH = os.path.abspath("%s/%s" % (os.path.dirname(os.path.realpath(__file__)),
        '../../tools/qml/main-local.qml'))
    INSTALLED_CORDOVA_CONTAINER_PATH = '/usr/share/cordova-ubuntu-tests/autopilot-tests/qml/main.qml'
    arch = subprocess.check_output(["dpkg-architecture",
        "-qDEB_HOST_MULTIARCH"]).strip()
    QML_LAUNCHER = "/usr/lib/" + arch + "/qt5/bin/qmlscene"

    # TODO: fix version
    # mobile_spec_path = '/usr/share/cordova-ubuntu-tests/www/'
    LOCAL_WWW_DIR_PATH = os.path.abspath("%s/%s" % (os.path.dirname(os.path.realpath(__file__)),
        '../../../www/'))
    WWW_DIR_PATH = '/usr/share/cordova-ubuntu-tests/www/'

    def get_www_dir_path(self):
        if os.path.exists(self.WWW_DIR_PATH):
            return self.WWW_DIR_PATH
        return self.WWW_DIR_PATH

    def get_cordova_container_path(self):
        if os.path.exists(self.LOCAL_CORDOVA_CONTAINER_PATH):
            return self.LOCAL_CORDOVA_CONTAINER_PATH
        return self.INSTALLED_CORDOVA_CONTAINER_PATH

    def setUp(self):
        print self.QML_LAUNCHER, self.LOCAL_CORDOVA_CONTAINER_PATH, self.get_cordova_container_path()
        self.app = self.launch_test_application(
            self.QML_LAUNCHER,
            self.get_cordova_container_path(),
            app_type='qt')

        super(CordovaUbuntuTestCase, self).setUp()

    def tearDown(self):
        super(CordovaUbuntuTestCase, self).tearDown()

    def pick_app_launcher(self, app_path):
        # force Qt app introspection
        from autopilot.introspection.qt import QtApplicationLauncher
        return QtApplicationLauncher()

    def get_cordovaview(self):
        return self.app.select_single(objectName="cordovaView")

    def get_webview(self):
        return self.app.select_single(objectName="webView")

