---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Руководство по разработке расширений

Мосты плагин Cordova a bit of функциональность между WebView питания Cordova-приложение и родной платформе Cordova-приложение работает на. Плагины состоят из единого интерфейса JavaScript, используемых на всех платформах и встроенных реализаций после платформа специфического плагин интерфейсы, которые вызывает JavaScript. Все основные Cordova API реализованы с помощью этой архитектуры.

Этом руководстве шаги процесса написания простой плагин эхо передает строку из JavaScript и отправляет его в родной среде для поддерживаемых платформ. Машинный код затем возвращает ту же строку обратно на обратные вызовы внутри плагина JavaScript.

Это руководство предоставляет достаточно обзор, на котором можно построить писать более сложные плагины.

## JavaScript

Точка входа для любого плагина является JavaScript. Причина разработчиков использовать Cordova, поэтому они могут использовать и писать JavaScript, не Objective-C, не Java, C#. Интерфейс JavaScript для вашего плагина является передней и возможно наиболее важной частью Cordova плагин.

Можно структурировать ваш плагин JavaScript, как вам нравится. Одна вещь, вы *должны* использовать для связи между Cordova JavaScript и родной среды `cordova.exec` функции. Вот пример:

        cordova.exec(function(winParam) {}, function(error) {}, "service",
                     "action", ["firstArgument", "secondArgument", 42,
                     false]);
    

Параметры описаны ниже:

*   `function(winParam) {}`: Успех функции обратного вызова. Если ваш `exec` вызов завершается успешно, эта функция вызывается (при необходимости с любыми параметрами, вы проходите к нему).

*   `function(error) {}`: Ошибка функции обратного вызова. Если операция не завершена успешно, эта функция вызывается (при необходимости с параметром ошибка).

*   `"service"`: Имя службы, для вызова на родной стороне. Это сопоставляется собственный класс, о котором более подробная информация доступна в родной гидов, перечисленных ниже.

*   `"action"`: Имя действия для вызова. Это взял на получение собственного класса `exec` вызов и, в зависимости от платформы, по существу карты к методу класса. Перечисленные ниже родной руководствах детали.

*   `[/* arguments */]`: Аргументы для передачи в родной среде.

### Пример JavaScript плагин эхо

        window.echo = function(str, callback) {
            cordova.exec(callback, function(err) {
                callback('Nothing to echo.');
            }, "Echo", "echo", [str]);
        };
    

Обсудим это. Плагин прикрепляется к `window` , специально для `echo` функции. Плагин пользователей будет затем использовать его следующим образом:

        window.echo("echome", function(echoValue) {
            alert(echoValue == "echome"); // should alert true.
        });
    

Во-первых Давайте рассмотрим три последние аргументы для `exec` функции. Мы будет вызывать `Echo` «услуг», с просьбой `echo` «action» и пройдя массив аргументов, содержащих строку эхо, который является первым параметром в `window.echo` функции.

Успех обратного вызова передается в `exec` это просто ссылка на обратный вызов функцию, `window.echo` принимает. Мы делаем немного больше для обратного вызова ошибки: Если родной стороне запускает обратный вызов для ошибки, мы просто успех обратного вызова и передайте в него строку «по умолчанию».

## Модуль Спецификация

Cordova имеет плагин спецификации доступны для включения автоматической установки плагина для Android, iOS, платформы BlackBerry 10 и Windows Phone. Структурирование ваш плагин определенным образом и добавив `plugin.xml` файл манифеста, можно разрешить пользователям устанавливать ваш плагин через командной строки инструмента.

*   Модуль Спецификация

## Родной

После того, как вы определяете JavaScript для вашего плагина, вы должны дополнить его по крайней мере один собственной реализации. Ниже перечислены детали, чтобы сделать это для каждой платформы. Эти руководства по-прежнему опираться на простой пример эхо плагин, рассмотренных выше.

*   Андроид плагины
*   Ежевика плагины
*   Ежевика 10 плагинов
*   iOS, плагины
*   Windows Phone плагины

В настоящее время Tizen платформа не поддерживает плагины.