#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at:
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
# 
#
# author : Jd <jd_jedi@users.sourceforge.net>
#


# VMM for the Xen Platform
from convirt.core.model.VMM import VMM
from convirt.core.utils.utils import dynamic_map,search_tree
from XenServerProxy import ServerProxy, SSHTunnelTransport

# Map the sxp info
class XenVMInfo(dynamic_map):
    def __init__(self, sxp_info):
        dynamic_map.__init__(self)
        self.sxp_info = sxp_info

    def __getattr__(self, name):
        if not self.has_key(name):
            val = search_tree(self.sxp_info, name)
            self.__setattr__(name, val)

        return dynamic_map.__getattr__(self, name)

    def __getitem__(self,name):
        if not self.has_key(name):
            val = search_tree(self.sxp_info, name)
            self.__setattr__(name, val)

        return dynamic_map.__getitem__(self, name)
        


class XenVMM(VMM):
    DEFAULT_PATH = '/RPC2'

    def __init__(self, protocol, host, port, is_remote,
                 ssh_transport=None,
                 ssh_port=22,
                 user = None,
                 password = None,
                 use_keys = None,
                 node = None): # special case, required config.

        # initialize the proxy here..
        self.protocol = protocol
        self.hostname = host
        self.tcp_port = port
        self.is_remote = is_remote
        self.ssh_transport = ssh_transport
        self.username = user
        self.password = password
        self.use_keys = use_keys
        self.node = node

        self.xen_proxy = None
        self.xen_proxy = self._init_vmm()
        self._info = None
        

    def _init_vmm(self):
        if self.xen_proxy is not None:
            return self.xen_proxy

        # share the transport from the node_proxy
        if self.is_remote:
           if self.protocol == "tcp":
               self.xen_proxy = ServerProxy('http://' + self.hostname + ':' + 
                                            str(self.tcp_port) + self.DEFAULT_PATH)

           if self.protocol == "ssl":
              self.xen_proxy = ServerProxy('https://' + self.hostname + ':' + 
                                      str(self.tcp_port) + self.DEFAULT_PATH)
            
           if self.protocol == "ssh":
              self.xen_proxy = ServerProxy('ssh://' + self.username +'@' +
                                      self.hostname + self.DEFAULT_PATH)

           if self.protocol == "ssh_tunnel":
              self.xen_proxy = ServerProxy('ssh_tunnel://' + self.username +
                                      '@' +
                                      self.hostname + ":" +
                                      str(self.tcp_port) +
                                      self.DEFAULT_PATH,
                                      ssh_transport = self.ssh_transport,
                                      user = self.username,
                                      password=self.password,
                                      use_keys = self.use_keys )    
        else:
           self.xen_proxy = ServerProxy('httpu:///var/run/xend/xmlrpc.sock')
           
        return self.xen_proxy


    # implement the interface
    def info(self):
        if self._info == None:
            self._info = XenVMInfo(self.xen_proxy.xend.node.info()) # dom0 special VM Info
        return self._info

    def is_in_error(self):
        if isinstance(self.xen_proxy, ServerProxy):
          if self.xen_proxy is not None:
             return  self.xen_proxy._last_error is not None
          else:
             return True
       #elif isinstance(self.xen_proxy, base_pkg.ServerProxy):
       #   return False


    def connect(self):
        self._init_vmm()

    def disconnect(self):
        self.xen_proxy.close()
        self.xen_proxy = None



    # VM List
    def get_vms(self):
        vm_list_info = []
        use_3_0_api = self.node.config.getDefault("use_3_0_api")
        use_3_1_api = self.node.config.getDefault("use_3_1_api")
        if use_3_0_api is None :
            use_3_0_api = False
        else:
            use_3_0_api = eval(use_3_0_api)
            
        if use_3_1_api is None :
            use_3_1_api = False
        else:
            use_3_1_api = eval(use_3_1_api)

            
        # get the current running doms
        if use_3_0_api : # Force 3_0
            vm_list_info = self.xen_proxy.xend.domains(1)
        elif use_3_1_api : # Force 3_1 
            vm_list_info = self.xen_proxy.xend.domains_with_state(True, #details
                                                                  'all',#state
                                                                  1) # full
        elif self.node["xen_major"] == 3 and \
           self.node["xen_minor"] == 0 or use_3_0_api :
           vm_list_info = self.xen_proxy.xend.domains(1)
        else:
           # new API
           vm_list_info = self.xen_proxy.xend.domains_with_state(True, # details
                                                                 'all', #state
                                                                 1) # full
        if vm_list_info:
            ndx = 0
            for info in vm_list_info:
                vm_list_info[ndx] = XenVMInfo(info[1:])
                ndx += 1
                
        return vm_list_info
       
 


    # VM ops
    

    """ refresh the vm information """
    def refresh(self,id):
        return XenVMInfo(self.xen_proxy.xend.domain(id))


    def save(self, id, filename):
        self.xen_proxy.xend.domain.save(id, filename)

    def restore(self,filename):
        self.xen_proxy.xend.domain.restore(filename)


    def reboot(self, id):
        self.xen_proxy.xend.domain.shutdown(id, 'reboot')


    def start_dom(self, id):
        pass

    def shutdown(self,id):
        self.xen_proxy.xend.domain.shutdown(id, 'halt')


    def destroy(self,id):
        self.xen_proxy.xend.domain.destroy(id)


    def pause(self,id):
        self.xen_proxy.xend.domain.pause(id)


    def unpause(self,id):
        self.xen_proxy.xend.domain.unpause(id)


    def suspend(self,id):
        self.xen_proxy.xend.domain.suspend(id)


    def resume(self,id):
        self.xen_proxy.xend.domain.resume(id)


    def migrate(self, id, dst,live,port):
        self.xen_proxy.xend.domain.migrate(id,
                                           dst.get_address(),
                                           live, 0, port) 
        
    def start(self,config):
        raise Excepton("Not implemented")



    # change to live running VM
    def setVCPUs(self, id, value):
        self.xen_proxy.xend.domain.setVCpuCount(id, value)

    def setMem(self, id, value):
        self.xen_proxy.xend.domain.setMemoryTarget(id, value)




    
