#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at:
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
# 
#
#

# Module containing classes for VM Settings and handlers

import re,pprint, traceback
import types
import os, sys,copy
import gtk, gtk.glade, gobject

from convirt.client.VMSettings import GeneralPage
from convirt.client.VMSettings import SettingsNotebook,VMNotebook
from convirt.client.VMSettings import VMSettingsDlg

from convirt.client.ui_utils import *

class KVMGeneralPage(GeneralPage):
    def __init__(self, context):
        GeneralPage.__init__(self, context)
        

    def get_widgets_to_disable(self, mode):
        base_list = GeneralPage.get_widgets_to_disable(self, mode)
        if mode in ["EDIT_VM_INFO",]:
            kvm_list = [ self.widgets[w] for w in ["vm_memory_entry",
                                               "vm_vcpu_spinbtn",
                                               ]]
            return base_list + kvm_list
        return base_list

class KVMNotebook(VMNotebook):
    def __init__(self, context):
        VMNotebook.__init__(self, context)
        
    def get_gen_page(self):
        return KVMGeneralPage(self.context)


class KVMSettingsNotebook(SettingsNotebook):
    def __init__(self, context):
        SettingsNotebook.__init__(self, context)

    def get_vm_notebook_page(self):
        return KVMNotebook(self.context)

class KVMSettingsDlg(VMSettingsDlg):
    def __init__(self, mode,ctx, parent_win = None):
        VMSettingsDlg.__init__(self, mode,ctx, parent_win)

    def get_settings_notebook(self):
        return KVMSettingsNotebook(self.context)


class KVMSettingsDlg(VMSettingsDlg):
    def __init__(self, mode,ctx, parent_win = None):
        VMSettingsDlg.__init__(self, mode,ctx, parent_win)

    def get_settings_notebook(self):
        return KVMSettingsNotebook(self.context)









