#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Jd & Hap Hazard
#   ======
#
# ConVirt is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#


_version = "0.8.2"
fox_header = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.4) Gecko/20070603 Fedora/2.0.0.4-2.fc7 Firefox/2.0.0.4 ConVirt/" + _version


#
# constants definitions
#

# config properties
prop_disks_dir = 'disks_dir'
prop_snapshots_dir = 'snapshots_dir'
prop_xenconf_dir = 'xenconf_dir'
prop_cache_dir = 'cache_dir'
prop_kernel = 'kernel'
prop_ramdisk = 'ramdisk'
prop_dom0_kernel = 'dom0_kernel'
#prop_staging_location = 'staging_location'
#prop_staging_path_kernel = 'staging_path_kernel'
#prop_staging_path_ramdisk = 'staging_path_ramdisk'
prop_snapshot_file_ext = 'snapshot_file_ext'
#prop_bootloader = 'bootloader'
prop_lvm = 'lvm_enabled'

prop_isRemote = 'is_remote'
prop_image_store="image_store"
prop_appliance_store="appliance_store"
prop_log_dir='log_dir'
prop_exec_path = 'exec_path'
prop_default_computed_options="default_computed_options"

prop_updates_url = "updates_url"
prop_updates_file = "updates_file"
prop_ref_update_time = "ref_update_time"

# node specific properties
prop_xen_protocol = "xen_protocol"
prop_xen_port = "xen_port"
prop_login = "login"
prop_ssh_port= "ssh_port"
prop_migration_port= "migration_port"
prop_use_keys= "use_keys"
prop_address = "address"

# ManagedNode environment identifiers
prop_env_SYSTEM = 'SYSTEM'
prop_env_RELEASE = 'RELEASE'
prop_env_VER = 'VERSION'
prop_env_MACHINE_TYPE = 'MACHINE'
prop_env_NODE_NAME = 'NODE'
prop_env_PROCESSOR = 'PROCESSOR'
prop_env_KERNEL = 'RELEASE'

#client config properties
prop_gnome_vfs_enabled = "gnome_vfs_enabled"      # by default True
prop_init_confirmation = 'confirm_dialog'
#prop_browser = "html_browser"       # Location of browser
prop_imagestore_default = 'default_image'

prop_enable_paramiko_log="enable_paramiko_log"
prop_paramiko_log_file = 'paramiko_log_file'

prop_enable_log="enable_log"
prop_log_file = "log_file"

prop_vncviewer = "vncviewer"
prop_local_vncviewer = "local_vncviewer"
prop_default_ssh_port= "default_ssh_port"
prop_default_migration_port= "default_migration_port"
prop_default_xen_protocol= "default_xen_protocol"
prop_default_xen_port= "default_xen_port"
prop_default_use_keys = "default_use_keys"

prop_http_proxy = "http_proxy"
prop_ftp_proxy = "ftp_proxy"

prop_chk_updates_on_startup = "check_updates_on_startup"
prop_guess_proxy = "guess_proxy"
# Global identifiers
LOCALHOST = 'localhost'
DEFAULT_LOG_DIR="/var/log/convirt"

# APP DATA section
prop_domfiles = "vms"
prop_groups = "groups"

