#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Jd & Hap Hazard
#   ======
#
# ConVirt is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#
# author : Jd <jd_jedi@users.sourceforge.net>
#

###
#  PROXY for KVM/qemu operations
###
  
from phelper import *
from NodeProxy import *

import select

QEMU_PROMPT = "(qemu)"
START_TOKEN = '\x1b'+ '[D'
STOP_TOKEN  = '\x1b' + '[K'
####
# TODO : Error handling on socat
#        parse cmd line : populate other fields. tricky as there are various
#                          ways to specify the same option.
#        
#        qemu parsing for each command and semantics. : currently no output is
#                     considered success. This is/may not be true.
#
#        Think if the list needs to be here. : If not think how to get
#                     monitor option.
#
#
#
#
#

class KVMProxy:

    # TODO: see if the option parsing code can be reused.
    kvm_options = ("no-reload-module", "install","memory", "m", "debugger",
                   "no-tap","mac", "vnc", "image","cdrom", "loadvm", "monitor",
                   "stopped", "dry-run")
    qemu_options = kvm_options + ("hda", "boot")

    # share the proxy operations and ssh_transport
    def __init__(self, node_proxy):
        self.node = node_proxy
        self.transport = self.node.ssh_transport
        self.channel_map = {}
        self.dom_list = None

    # would be useful when we allow transport/proxy to be re-initialized
    def set_node_proxy(self,node_proxy):
        self.node = node_proxy
        self.transport = self.node.ssh_transport
        for id in self.channel_map.keys():
            ch = self.channel_map[id]
            ch.shutdown(2)
        self.channel_map.clear()
        self.dom_list.clear()

    def _get_channel(self, id):
        info = self.dom_list[id]
        monitor = info.get("monitor")
        if monitor is None:
            raise Exception("Can not connect to monitor: monitor option not specified")
        if self.channel_map.has_key(id):
            return self.channel_map[id]
        else:
            # create a new channel and return it.
            transport = self.node.ssh_transport
            chan = transport.open_session()
            chan.set_combine_stderr(True)
            chan.setblocking(0)
            m = monitor.split(',')[0]
            chan.exec_command("socat stdin " + m)
            
            self.channel_map[id] = chan
            # read intro message and qemu prompt
            self.read_till_prompt(id)
            
            ## check if chan established... and working.. or socat
            ## failed.

            return chan


    # read from the channel till a particular pattern is found
    def read_till_prompt(self,id):
        chan = self._get_channel(id)
        resp = ""
        try:
            while True:
                r, w, e = select.select([chan], [], [])
                if chan in r:
                    try:
                        x = chan.recv(512)
                        if len(x) == 0:
                            print '\n channel closed.\n',
                            break
                        resp += x
                        if x.strip().endswith(QEMU_PROMPT):
                            return resp
                            break
                    except socket.timeout:
                        pass
        finally:
            print "in finally block"


    def _sanitize(self,output):
        start_pos = output.rfind( START_TOKEN )
        token = None
        if start_pos > 0 :
            start_pos = start_pos + len(START_TOKEN)
            end_pos = output.rfind(STOP_TOKEN)
            if end_pos > 0 and end_pos > start_pos:
                token = output[start_pos:end_pos]
                return token + output[end_pos + len(STOP_TOKEN):]
            
        return output
                

    def send_command(self, id, command):
        chan = self._get_channel(id)
        chan.send(command + "\n")
        output = self.read_till_prompt(id)
        if output:
            output = self._sanitize(output)
        if output and output.strip().endswith(QEMU_PROMPT):
            output = output.strip()[:0-len(QEMU_PROMPT)]
            return (output.strip(), True)
        else:
            return (output, False)


    def get_domains(self):
        if self.dom_list is None:
            self.refresh()
        return self.dom_list

    def get_dom_info(self, name):
        doms = self.get_domains()
        print "@@@@", doms
        return doms.get(name)

    # return a list of running domains
    # take adv of -pid file option if possible.
    def refresh(self):
        domains = {}
        x = self.node.listdir("/proc")
        for p in x:
            if not p.isdigit() : continue
            #if p != '5938': continue
            f = os.path.join('/proc',p,'cmdline')
            cmd = None
            try:
                i = open(f)
                cmd = i.readline()
                i.close()
            except Exception, ex:
                pass
            if cmd is None or cmd.strip() == '': continue
            if cmd.split(chr(0),1)[0].endswith("qemu"):
                type = "QEMU"
                if cmd.find("kvm"): #later look at fds and see if /dev/kvm used
                    type = "KVM"
                pid = int(p)
                info = {}
                info["type"] = type
                info["cmdline"]= cmd
                info["id"] = pid
                self.populate_info_from_cmdline(info, cmd)
                if info.get("name") is None:
                    info["name"] = info["id"]

                # allow access by name of id
                domains[info["name"]] = info
                domains[pid]=info

        self.dom_list = domains

        return domains


    # TODO : Use nested maps to represent networks and disks
    #        Also seperation between arguments with values and
    #        boolean arguments
    def populate_info_from_cmdline(self, info, cmdline):
        # for  now only pick the monitor and vnc
        options = cmdline.split(chr(0))
        ndx = 0
        for o in options:
            ndx += 1
            o = o.strip()
            if o.endswith("-monitor") or o.endswith("-vnc") or \
                   o.endswith("-name"):
                if o.find('-') == 0:
                    key = o[1:]
                if o.find('--') == 0:
                    key = o[2:]
                if len(options) > ndx:
                    if key == ("monitor"):
                        value = options[ndx].split(",")[0]
                    else:
                        value = options[ndx]
                    info[key] = value   # clean up value too.
                    
        # guess the name from the monitor name file.
        if info.get("name") == None:
            m = info.get("monitor")
            if m is not None:
                info["name"] = m[m.rfind('/')+1:]

    ################ Implement some of the VMM operations #############
    # Start, Stop, Pause, Resume, Kill, Take snapshot, Restore Snapshot

    # Use the config and start a new vm.
    def start(self,config):
        if config is None:
            raise Exception("No context provided to start the vm")
        
        # take the config.. and generate a cmdline for kvm/qemu
        if config["type"] == "KVM":
            cmd = "/usr/local/kvm/bin/qemu"   #take care of the path
            known_options = self.qemu_options
        else:
            cmd = "qemu"
            self.qemu_options

        # build the cmd line
        cmdline = cmd 
        for opt in config.keys():
            if opt in known_options:
                cmdline = cmdline + " -" + opt
                value = config.get(opt)
                if value is not None:
                    value = str(value)
                    if opt == "monitor" and value.find(",")== -1 :
                        #value = value + ",server,nowait"
                        print "IGNORING : monitor value ", value
                        continue
                    cmdline = cmdline + " " + value
                    
        # The following is done to have the convention and
        # temporarily have the name of VM available in the command line.
        if not config.get("monitor"):
            cmdline = cmdline + " -monitor unix:/tmp/" + config.get("name") + \
                      ",server,nowait"
                    
                    # Add handling of nested options
                    #else if isinstance(value,dict):
                    #else if isinstance(value,list):
                    #
        # daemonize.. the command can return
        cmdline = cmdline + " -daemonize"
        print cmdline
        (output, ret) = self.node.exec_cmd(cmdline)
        #if ret != 0:
        #    print "start failed :", cmdline,output
        #    raise Exception(output)
        self.refresh()
        return output,ret

    # Stop/Pause running VM
    # When u pause the output returned is weired.
    def pause(self,id):
        (output,prompt) = self.send_command(id,"stop")
        if prompt and output == "stop":
            return True
        else:
            raise Exception("pause:" +  output)
        
    def resume(self,id):
        (output,prompt) = self.send_command(id,"cont")
        if prompt and output == "cont":
            return True
        else:
            raise Exception("resume:" + output)
        
    def save_vm(self,id, tag):
        cmd = "savevm " + tag
        (output,prompt) = self.send_command(id, cmd)
        if prompt and output == cmd:
            return True
        else:
            raise Exception(cmd + ":" + output)

    def load_vm(self,id, tag):
        cmd = "loadvm " + tag
        (output,prompt) = self.send_command(id, cmd)
        if prompt and output == cmd:
            return True
        else:
            raise Exception(cmd + ":" +output)
        

    def quit_vm(self,id):
        cmd = "quit"
        (output,prompt) = self.send_command(id, cmd)
        if prompt and output == cmd:
            return True

        # After VM quits.. there is no output from the monitor.
        #else:
        #    raise Exception(cmd + ":" + output)
                
        return True

    def kill_vm(self, id):
        # hard kill to be implemented later.
        # look for the process, make sure it is a qemu process
        # kill the process.

        # for now just quit
        return self.quit_vm(id)
        
    # available snapshots
    def list_snapshots(self,id):
        cmd = "info snapshots"
        (output,prompt) = self.send_command(id, cmd)
        if prompt and output.find(cmd) == 0:
            print output.split()
            return output
        else:
            raise Exception(cmd + ":" + output)


if __name__ == '__main__':
    print "Enter password :"
    pwd = sys.stdin.readline().strip()
    node_proxy = Node( hostname = "192.168.12.101",
                       ssh_port=22,
                       username="root",
                       password=pwd,
                       isRemote=True)

    vmm = KVMProxy(node_proxy)
    
    config = {}
    config["type"]="KVM"
    config["hda"]="/mnt/home/jd/kvm/kvm-19/ubuntu-6.qcow"
    config["m"] = 1024
    config["monitor"] = "unix:/tmp/xyz"
    config["vnc"] = ":5"

 ##   vmm.start(config)
    
    doms = vmm.get_domains()

    for id in doms.keys():
        print doms[id]

    sys.exit(0)
    print "enter pid "
    pid = sys.stdin.readline().strip()
    if pid.isdigit():
        pid = int(pid)
        print "pausing", pid
        vmm.pause(pid)
        print "paused."
        
        sys.stdin.readline()
        print "continue", pid
        vmm.resume(pid)
        print "resumed."
        
        sys.stdin.readline()
        print "saving snapshot x"
        vmm.save_vm(id, "x")
        print "saved vm x"
        

        sys.stdin.readline()
        print "restoring snapshot x"
        vmm.load_vm(id, "x")
        print "restored vm x"

        sys.stdin.readline()
        print "quiting vm"
        vmm.quit_vm(id)
        print "vm quit"
        
    else :
        print "Invalid PID"

    
    sys.exit(0)
    
    #transport = node_proxy.ssh_transport
    #chan = transport.open_session()
    #chan.set_combine_stderr(True)
    #chan.setblocking(0)
    #chan.exec_command("socat stdin tcp:0:5555")

    #if chan.recv_ready():
    #    print "recv ready"
    #else:
    #    print "can not connect to terminal"
    #    sys.exit(0)
        
    
    #vmm.read_till_prompt(chan)
    #output =  vmm.send_command(chan, "help")
    #print output
    
    ## while True:
##         try:
##             command = sys.stdin.readline()
##             if command.strip() == "quit":
##                 break
##             output = vmm.send_command(chan,command.strip())
##             print output
##         except Exception, ex:
##             print ex
            
        
    
                                   

