/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// qt specific
#include <qpopmenu.h>
#include <qapplication.h>
#include <qclipboard.h>
// kde specific
#include <klocale.h>
#include <kiconloader.h>
// menu specific
#include "lazyfillmenu.h"
#include "addressmenufiller.h"

static const int AddressBaseId = 1000;


void AddressMenuFiller::createEntry( const KABC::Addressee Contact, QPopupMenu *Menu )
{
    int NoOfAddresses = Contact.addresses().size();
    if( NoOfAddresses > 0 )
    {
        LazyFillMenu *SubMenu = new LazyFillMenu( new AddressMenuFiller(Contact), false, Menu );
        Menu->insertItem( SmallIconSet("kfm_home"), 
                          NoOfAddresses==1?i18n("&Address"):i18n("&Addresses"), SubMenu  );
    }
}


AddressMenuFiller::AddressMenuFiller( const KABC::Addressee C )
: Contact( C )
{
}


void AddressMenuFiller::fill( QPopupMenu *Menu )
{
    connect( Menu, SIGNAL(activated(int)), this, SLOT(copy(int)) );

    const KABC::Address::List Addresses = Contact.addresses();
    int i = AddressBaseId;
    KABC::Address::List::ConstIterator it = Addresses.begin();
    while( it != Addresses.end() )
        Menu->insertItem( protectAmpersand((*it++).formattedAddress()), i++ );
}



void AddressMenuFiller::copy( int id )
{
    if( id >= AddressBaseId )
    {
        // Copy text into the clipboard
        QApplication::clipboard()->setText( Contact.addresses()[id-AddressBaseId].formattedAddress(), QClipboard::Clipboard );
    }
}

#include "addressmenufiller.moc"
