#!/usr/bin/env python

# This script installs or uninstalls Comix on your system.

import os, shutil, sys

INSTALL_DIR = '/usr/local'

def info():
	
	print
	print 'Run "python install.py install" as root to install Comix in /usr/local.'
	print 'To uninstall, simply run "python install.py uninstall".'
	print
	print 'If you wish to install Comix in another base directory, use the --installdir'
	print 'option. Example: "python install.py install --installdir /usr".'
	print 'If you have installed with --installdir, do not forget to use the same option'
	print 'when uninstalling.'
	print

if len(sys.argv) > 1:
	
	if len(sys.argv) > 3:
		
		if '--installdir' in sys.argv[1:-1]:
			
			INSTALL_DIR = sys.argv[sys.argv.index('--installdir') + 1]
			sys.argv.pop(sys.argv.index('--installdir') + 1)
			sys.argv.pop(sys.argv.index('--installdir'))
			
	if os.path.isdir(INSTALL_DIR):
		
		if INSTALL_DIR.endswith('/'):
			INSTALL_DIR = INSTALL_DIR[:-1]
		
		if len(sys.argv) == 2:
			
			if sys.argv[1] == 'install':
				
				# Make new directories if they do not exist.
				if not os.path.exists(INSTALL_DIR + '/bin'):
					os.makedirs(INSTALL_DIR + '/bin', 0755)
				if not os.path.exists(INSTALL_DIR + '/share/applications'):
					os.makedirs(INSTALL_DIR + '/share/applications', 0755)
				if not os.path.exists(INSTALL_DIR + '/share/pixmaps'):
					os.makedirs(INSTALL_DIR + '/share/pixmaps', 0755)
				if not os.path.exists(INSTALL_DIR + '/share/man/man1'):
					os.makedirs(INSTALL_DIR + '/share/man/man1', 0755)
					
				# If the directories exist, copy the files to them.
				if os.path.isdir(INSTALL_DIR + '/bin'):
					shutil.copy('comix', INSTALL_DIR + '/bin/comix')
					os.chmod(INSTALL_DIR + '/bin/comix', 0755)
					print 'installed ' +  INSTALL_DIR + '/bin/comix'
					
				if os.path.isdir(INSTALL_DIR + '/share/applications'):
					shutil.copy('comix.desktop', INSTALL_DIR + '/share/applications/comix.desktop')
					os.chmod(INSTALL_DIR + '/share/applications/comix.desktop', 0644)
					print 'installed ' +  INSTALL_DIR + '/share/applications/comix.desktop'
					
				if os.path.isdir(INSTALL_DIR + '/share/pixmaps'):
					shutil.copy('comix.png', INSTALL_DIR + '/share/pixmaps/comix.png')
					os.chmod(INSTALL_DIR + '/share/pixmaps/comix.png', 0644)
					print 'installed ' +  INSTALL_DIR + '/share/pixmaps/comix.png'
					
				if os.path.isdir(INSTALL_DIR + '/share/man/man1'):
					shutil.copy('comix.1.gz', INSTALL_DIR + '/share/man/man1/comix.1.gz')
					os.chmod(INSTALL_DIR + '/share/man/man1/comix.1.gz', 0644)
					print 'installed ' +  INSTALL_DIR + '/share/man/man1/comix.1.gz'
					
			elif sys.argv[1] == 'uninstall':
				
				# Remove the files if they exist
				if os.path.exists(INSTALL_DIR + '/bin/comix'):
					os.remove(INSTALL_DIR + '/bin/comix')
					print 'removed ' +  INSTALL_DIR + '/bin/comix'
				if os.path.exists(INSTALL_DIR + '/share/applications/comix.desktop'):
					os.remove(INSTALL_DIR + '/share/applications/comix.desktop')
					print 'removed ' +  INSTALL_DIR + '/share/applications/comix.desktop'
				if os.path.exists(INSTALL_DIR + '/share/pixmaps/comix.png'):
					os.remove(INSTALL_DIR + '/share/pixmaps/comix.png')
					print 'removed ' +  INSTALL_DIR + '/share/pixmaps/comix.png'
				if os.path.exists(INSTALL_DIR + '/share/man/man1/comix.1.gz'):
					os.remove(INSTALL_DIR + '/share/man/man1/comix.1.gz')
					print 'removed ' +  INSTALL_DIR + '/share/man/man1/comix.1.gz'
				if os.path.exists('/tmp/comix'):	
					shutil.rmtree('/tmp/comix')
					print 'removed /tmp/comix'
					
			else:
				info()
				
		else:
			info()
			
	else:
		print
		print INSTALL_DIR, 'does not exist.'
		info()
	
else:
	info()	