import gtk, gobject

from cohoba.common.ProfileList import ProfileList
from cohoba.common.ui.ProfileIcons import ProfileIcons

class ProfileComboBox(gtk.ComboBox):
	def __init__(self):
		gtk.ComboBox.__init__(self, ProfileList())
		
		cell = gtk.CellRendererPixbuf()
		self.pack_start(cell, False)
		self.set_cell_data_func(cell, self.get_profile_icon)
		
		cell = gtk.CellRendererText()
		self.pack_start(cell, True)
		self.set_cell_data_func(cell, self.get_profile_description)
		
		if len(self.get_model()) > 0:
			self.set_active(0)

	def get_profile_icon(self, layout, cell, model, iter):
		cell.set_property('pixbuf', ProfileIcons().get_icon(model[iter].name))
		
	def get_profile_description(self, layout, cell, model, iter):
		cell.set_property('markup', "<b>%s</b> <span size='small'>(%s)</span>" % (model[iter].get_description(), model[iter].manager))
		
	def set_active_profile(self, connmgr):
		iter = self.get_model().get_iter_for_object(connmgr)
		if iter != None:
			self.set_active_iter(iter)	
	
	def get_active_profile(self):
		iter = self.get_active_iter()
		if iter != None:
			return self.get_model()[iter]
