from cohoba.common.Utils import load_icon
import gtk.gdk

class PresenceIcons:
	def __init__(self):
		self.icons = {}
		
	def get_icon(self, presence, avatar=None):
		if avatar != None:
			loader = gtk.gdk.PixbufLoader()
			loader.set_size(48, 48)
			loader.write(avatar)
			loader.close()
			pixbuf = loader.get_pixbuf()
			return (pixbuf.scale_simple(24, 24, gtk.gdk.INTERP_BILINEAR), pixbuf)
		if presence not in self.icons:
			self.icons[presence] = (load_icon("presence-%s.png" % presence), load_icon("presence-%s-48.png" % presence))
		
		return self.icons[presence]

presence_icons = PresenceIcons()
def get_presence_icons(name=None, avatar=None):
	if name == None:
		return presence_icons
	else:
		return presence_icons.get_icon(name, avatar)
